/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.content;

import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.virtual.IConnectionNode;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.virtual.IKnownConnectionNode;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.services.IServerExplorerContentService;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.services.IServicesManager;


/**
 * @author ljulien
 */
public class ConnectionNodeUtil
{
    public static IConnectionNode getConnectionNode (ConnectionInfo connectionInfo) throws ServerNotFoundException
    {
        IConnectionNode currentNode;
        IServerExplorerContentService service = IServicesManager.INSTANCE.getServerExplorerContentService();
        if (service != null)
        {
	        IKnownConnectionNode node = IServicesManager.INSTANCE.getServerExplorerContentService().getKnownServerNode();
	        Object [] children = node.getChildrenArray();
	        for (int i = 0, n = children.length; i < n; i++)
	        {
	            IConnectionNode serverNode = (IConnectionNode) children[i];
	            if (serverNode.getConnectionInfo().equals(connectionInfo))
	            {
	                return serverNode;
	            }
	        }
        }
        throw new ServerNotFoundException();
    }
}
class ServerNotFoundException extends Exception 
{

	/**
	 * Comment for <code>serialVersionUID</code>
	 */
	private static final long serialVersionUID = 6557041570235977955L;
}
