/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.content;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.LinkedList;
import java.util.List;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.virtual.IConnectionNode;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionSharingListener;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.ServerUIPlugin;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.dialogs.SQLExceptionDialog;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.services.IServerStatusDecorationService;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.services.IServicesManager;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.util.resources.ResourceLoader;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.swt.widgets.Display;


/**
 * @author ljulien
 */
public class ServerExplorerConnectionSharingListener implements ConnectionSharingListener
{
    private static final String SQLMESSAGE = ResourceLoader.INSTANCE.queryString("DATATOOLS.SERVER.UI.CONNECTION.SQLEXCEPTION.SQLMESSAGE"); //$NON-NLS-1$

    private void disconnect (ConnectionInfo info)
    {
//        try
//        {
//            DisconnectServerAction action = new DisconnectServerAction ();
//            action.selectionChanged(null, new StructuredSelection(ConnectionNodeUtil.getConnectionNode(info)));
//            action.run(null);
//        }
//        catch (ServerNotFoundException e)
//        {
//        }
    }
    
    private void reconnect (ConnectionInfo info)
    {
//        try
//        {
//            ConnectServerAction action = new ConnectServerAction ();
//            action.selectionChanged (null, new StructuredSelection(ConnectionNodeUtil.getConnectionNode(info)));
//            action.run(null);
//        }
//        catch (ServerNotFoundException e)
//        {
//        }
    }
    
    private IStatus [] getStatus (SQLException sqlException)
    {
        List statusList = new LinkedList ();
        SQLException current = sqlException;
        do 
        {
            statusList.add(new Status (	IStatus.ERROR, 
  										ServerUIPlugin.getDefault().getBundle().getSymbolicName(),
  										current.getErrorCode(),
  										current.getMessage(),
  										current));
        } 
        while ((current = current.getNextException()) != null);
        return (IStatus []) statusList.toArray (new IStatus [statusList.size()]);
    }

    public void sharedConnectionAdded(ConnectionInfo info, Connection connection)
    {
    }

    public void sharedConnectionRemove(ConnectionInfo info, Connection connection)
    {
    }

    public void sharedDatabaseAdded(final ConnectionInfo info, final Database database)
    {
        Display.getDefault().asyncExec(new Runnable()
        {
            public void run()
            {
                try
                {
                    IConnectionNode node = ConnectionNodeUtil.getConnectionNode(info);
                    node.shouldDisconnect(false);
                    IServicesManager.INSTANCE.getServerExplorerContentService().addNode(node, database);
                    IServerStatusDecorationService service = IServicesManager.INSTANCE
                            .getServerStatusDecorationService();
                    if (service != null)
                    {
                        service.refreshDecoration(new Object[] { node });
                    }
                }
                catch (ServerNotFoundException e)
                {
                }
            }
        });
    }

    public void sharedDatabaseRemove(final ConnectionInfo info, final Database database)
    {
        Display.getDefault().asyncExec(new Runnable ()
        {
            public void run ()
            {
                try
                {
                    IConnectionNode node = ConnectionNodeUtil.getConnectionNode(info);
                    node.shouldDisconnect(true);
                    IServicesManager.INSTANCE.getServerExplorerContentService().removeNode(node, database);
                }
                catch (ServerNotFoundException e)
                {
                }
            }
        });
    }

    public void onSQLException(final ConnectionInfo info, Connection connection, SQLException exception) 
    {
        if(info.getSharedConnection() != connection || exception instanceof SQLWarning) 
        {
            return;
        }
        
        IStatus status = new MultiStatus(ServerUIPlugin.getDefault().getBundle().getSymbolicName(),
      			exception.getErrorCode(), 
      			getStatus (exception),
      			SQLMESSAGE,
      			null);
        
        final SQLExceptionDialog dialog = new SQLExceptionDialog(status);
        dialog.open();
        
        if (dialog.getReturnCode() == SQLExceptionDialog.DISCONNECT_ID)
        {
            disconnect (info);
        }
        else if (dialog.getReturnCode() == SQLExceptionDialog.RECONNECT_ID)
        {
            disconnect (info);
            reconnect (info);
        }
    }
}
