/**
 * <copyright>
 * </copyright>
 *
 * $Id: ColumnNameImpl.java,v 1.3 2005/12/22 22:18:48 bpayton Exp $
 */
package org.eclipse.datatools.modelbase.sql.query.impl;

import java.util.Collection;

import org.eclipse.datatools.modelbase.sql.query.ColumnName;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryModelPackage;
import org.eclipse.datatools.modelbase.sql.query.TableCorrelation;
import org.eclipse.datatools.modelbase.sql.query.WithTableSpecification;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;



/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>SQL Column Name</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.datatools.modelbase.sql.query.impl.ColumnNameImpl#getTableCorrelation <em>Table Correlation</em>}</li>
 *   <li>{@link org.eclipse.datatools.modelbase.sql.query.impl.ColumnNameImpl#getWithTableSpecification <em>With Table Specification</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ColumnNameImpl extends SQLQueryObjectImpl implements ColumnName {
	/**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    protected ColumnNameImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    protected EClass eStaticClass() {
		return SQLQueryModelPackage.eINSTANCE.getColumnName();
	}

	/**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public TableCorrelation getTableCorrelation() {
		if (eContainerFeatureID != SQLQueryModelPackage.COLUMN_NAME__TABLE_CORRELATION) return null;
		return (TableCorrelation)eContainer;
	}

	/**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public void setTableCorrelation(TableCorrelation newTableCorrelation) {
		if (newTableCorrelation != eContainer || (eContainerFeatureID != SQLQueryModelPackage.COLUMN_NAME__TABLE_CORRELATION && newTableCorrelation != null)) {
			if (EcoreUtil.isAncestor(this, newTableCorrelation))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eContainer != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newTableCorrelation != null)
				msgs = ((InternalEObject)newTableCorrelation).eInverseAdd(this, SQLQueryModelPackage.TABLE_CORRELATION__COLUMN_NAME_LIST, TableCorrelation.class, msgs);
			msgs = eBasicSetContainer((InternalEObject)newTableCorrelation, SQLQueryModelPackage.COLUMN_NAME__TABLE_CORRELATION, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SQLQueryModelPackage.COLUMN_NAME__TABLE_CORRELATION, newTableCorrelation, newTableCorrelation));
	}

	/**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public WithTableSpecification getWithTableSpecification() {
		if (eContainerFeatureID != SQLQueryModelPackage.COLUMN_NAME__WITH_TABLE_SPECIFICATION) return null;
		return (WithTableSpecification)eContainer;
	}

	/**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public void setWithTableSpecification(WithTableSpecification newWithTableSpecification) {
		if (newWithTableSpecification != eContainer || (eContainerFeatureID != SQLQueryModelPackage.COLUMN_NAME__WITH_TABLE_SPECIFICATION && newWithTableSpecification != null)) {
			if (EcoreUtil.isAncestor(this, newWithTableSpecification))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eContainer != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newWithTableSpecification != null)
				msgs = ((InternalEObject)newWithTableSpecification).eInverseAdd(this, SQLQueryModelPackage.WITH_TABLE_SPECIFICATION__COLUMN_NAME_LIST, WithTableSpecification.class, msgs);
			msgs = eBasicSetContainer((InternalEObject)newWithTableSpecification, SQLQueryModelPackage.COLUMN_NAME__WITH_TABLE_SPECIFICATION, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SQLQueryModelPackage.COLUMN_NAME__WITH_TABLE_SPECIFICATION, newWithTableSpecification, newWithTableSpecification));
	}

	/**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case SQLQueryModelPackage.COLUMN_NAME__EANNOTATIONS:
					return ((InternalEList)getEAnnotations()).basicAdd(otherEnd, msgs);
				case SQLQueryModelPackage.COLUMN_NAME__TABLE_CORRELATION:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, SQLQueryModelPackage.COLUMN_NAME__TABLE_CORRELATION, msgs);
				case SQLQueryModelPackage.COLUMN_NAME__WITH_TABLE_SPECIFICATION:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, SQLQueryModelPackage.COLUMN_NAME__WITH_TABLE_SPECIFICATION, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case SQLQueryModelPackage.COLUMN_NAME__EANNOTATIONS:
					return ((InternalEList)getEAnnotations()).basicRemove(otherEnd, msgs);
				case SQLQueryModelPackage.COLUMN_NAME__DEPENDENCIES:
					return ((InternalEList)getDependencies()).basicRemove(otherEnd, msgs);
				case SQLQueryModelPackage.COLUMN_NAME__TABLE_CORRELATION:
					return eBasicSetContainer(null, SQLQueryModelPackage.COLUMN_NAME__TABLE_CORRELATION, msgs);
				case SQLQueryModelPackage.COLUMN_NAME__WITH_TABLE_SPECIFICATION:
					return eBasicSetContainer(null, SQLQueryModelPackage.COLUMN_NAME__WITH_TABLE_SPECIFICATION, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case SQLQueryModelPackage.COLUMN_NAME__TABLE_CORRELATION:
					return eContainer.eInverseRemove(this, SQLQueryModelPackage.TABLE_CORRELATION__COLUMN_NAME_LIST, TableCorrelation.class, msgs);
				case SQLQueryModelPackage.COLUMN_NAME__WITH_TABLE_SPECIFICATION:
					return eContainer.eInverseRemove(this, SQLQueryModelPackage.WITH_TABLE_SPECIFICATION__COLUMN_NAME_LIST, WithTableSpecification.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return eContainer.eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case SQLQueryModelPackage.COLUMN_NAME__EANNOTATIONS:
				return getEAnnotations();
			case SQLQueryModelPackage.COLUMN_NAME__NAME:
				return getName();
			case SQLQueryModelPackage.COLUMN_NAME__DEPENDENCIES:
				return getDependencies();
			case SQLQueryModelPackage.COLUMN_NAME__DESCRIPTION:
				return getDescription();
			case SQLQueryModelPackage.COLUMN_NAME__LABEL:
				return getLabel();
			case SQLQueryModelPackage.COLUMN_NAME__TABLE_CORRELATION:
				return getTableCorrelation();
			case SQLQueryModelPackage.COLUMN_NAME__WITH_TABLE_SPECIFICATION:
				return getWithTableSpecification();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case SQLQueryModelPackage.COLUMN_NAME__EANNOTATIONS:
				getEAnnotations().clear();
				getEAnnotations().addAll((Collection)newValue);
				return;
			case SQLQueryModelPackage.COLUMN_NAME__NAME:
				setName((String)newValue);
				return;
			case SQLQueryModelPackage.COLUMN_NAME__DEPENDENCIES:
				getDependencies().clear();
				getDependencies().addAll((Collection)newValue);
				return;
			case SQLQueryModelPackage.COLUMN_NAME__DESCRIPTION:
				setDescription((String)newValue);
				return;
			case SQLQueryModelPackage.COLUMN_NAME__LABEL:
				setLabel((String)newValue);
				return;
			case SQLQueryModelPackage.COLUMN_NAME__TABLE_CORRELATION:
				setTableCorrelation((TableCorrelation)newValue);
				return;
			case SQLQueryModelPackage.COLUMN_NAME__WITH_TABLE_SPECIFICATION:
				setWithTableSpecification((WithTableSpecification)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case SQLQueryModelPackage.COLUMN_NAME__EANNOTATIONS:
				getEAnnotations().clear();
				return;
			case SQLQueryModelPackage.COLUMN_NAME__NAME:
				setName(NAME_EDEFAULT);
				return;
			case SQLQueryModelPackage.COLUMN_NAME__DEPENDENCIES:
				getDependencies().clear();
				return;
			case SQLQueryModelPackage.COLUMN_NAME__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
			case SQLQueryModelPackage.COLUMN_NAME__LABEL:
				setLabel(LABEL_EDEFAULT);
				return;
			case SQLQueryModelPackage.COLUMN_NAME__TABLE_CORRELATION:
				setTableCorrelation((TableCorrelation)null);
				return;
			case SQLQueryModelPackage.COLUMN_NAME__WITH_TABLE_SPECIFICATION:
				setWithTableSpecification((WithTableSpecification)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case SQLQueryModelPackage.COLUMN_NAME__EANNOTATIONS:
				return eAnnotations != null && !eAnnotations.isEmpty();
			case SQLQueryModelPackage.COLUMN_NAME__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case SQLQueryModelPackage.COLUMN_NAME__DEPENDENCIES:
				return dependencies != null && !dependencies.isEmpty();
			case SQLQueryModelPackage.COLUMN_NAME__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
			case SQLQueryModelPackage.COLUMN_NAME__LABEL:
				return LABEL_EDEFAULT == null ? label != null : !LABEL_EDEFAULT.equals(label);
			case SQLQueryModelPackage.COLUMN_NAME__TABLE_CORRELATION:
				return getTableCorrelation() != null;
			case SQLQueryModelPackage.COLUMN_NAME__WITH_TABLE_SPECIFICATION:
				return getWithTableSpecification() != null;
		}
		return eDynamicIsSet(eFeature);
	}

} //SQLColumnNameImpl
