/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.flatfile.util.querytextutil;

import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.flatfile.i18n.Messages;

public class QueryTextUtil {
    private static final char QUERY_TEXT_DELIMITER = ':';
    private static final char COLUMNSINFO_BEGIN_DELIMITER = '{';
    static final /* synthetic */ boolean $assertionsDisabled;

    private QueryTextUtil() {
    }

    public static String getQuery(String queryText) throws OdaException {
        return QueryTextUtil.splitQueryText(queryText)[0];
    }

    public static String getColumnsInfo(String queryText) throws OdaException {
        if (!$assertionsDisabled && queryText == null) {
            throw new AssertionError();
        }
        return QueryTextUtil.splitQueryText(queryText)[1];
    }

    private static String[] splitQueryText(String queryText) throws OdaException {
        int delimiterIndex = -1;
        int columnsInfoBeginIndex = -1;
        String trimmedQueryText = queryText.trim();
        String[] splittedQueryText = new String[]{"", ""};
        boolean inQuote = false;
        boolean isEscaped = false;
        char[] chars = trimmedQueryText.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '\"') {
                if (!isEscaped) {
                    inQuote = !inQuote;
                    continue;
                }
                isEscaped = !isEscaped;
                continue;
            }
            if (chars[i] == '\\') {
                isEscaped = !isEscaped;
                continue;
            }
            if (!inQuote && chars[i] == ':') {
                delimiterIndex = i;
                continue;
            }
            if (inQuote || chars[i] != '{') continue;
            columnsInfoBeginIndex = i;
            break;
        }
        if (inQuote) {
            throw new OdaException(Messages.getString("query_text_error"));
        }
        if (delimiterIndex != -1 && columnsInfoBeginIndex != -1) {
            splittedQueryText[0] = trimmedQueryText.substring(0, delimiterIndex).trim();
            splittedQueryText[1] = trimmedQueryText.substring(columnsInfoBeginIndex + 1, trimmedQueryText.length() - 1).trim();
        } else if (delimiterIndex == -1 && columnsInfoBeginIndex == -1) {
            splittedQueryText[0] = trimmedQueryText;
        } else {
            throw new OdaException(Messages.getString("query_text_error"));
        }
        return splittedQueryText;
    }

    static {
        $assertionsDisabled = !QueryTextUtil.class.desiredAssertionStatus();
    }
}

