/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.routineeditor.ui.launching;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.EditorCorePlugin;
import org.eclipse.datatools.sqltools.core.IControlConnection;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.dbitem.IDBItem;
import org.eclipse.datatools.sqltools.core.dbitem.IEvent;
import org.eclipse.datatools.sqltools.core.dbitem.ISPUDF;
import org.eclipse.datatools.sqltools.core.dbitem.ParameterDescriptor;
import org.eclipse.datatools.sqltools.core.dbitem.ParameterWrapper;
import org.eclipse.datatools.sqltools.core.profile.NoSuchProfileException;
import org.eclipse.datatools.sqltools.routineeditor.internal.RoutineEditorActivator;
import org.eclipse.datatools.sqltools.routineeditor.launching.LaunchHelper;
import org.eclipse.datatools.sqltools.routineeditor.parameter.EventParameter;
import org.eclipse.datatools.sqltools.routineeditor.parameter.ParameterInOutWrapper;
import org.eclipse.datatools.sqltools.routineeditor.parameter.internal.EventParameterTableDialog;
import org.eclipse.datatools.sqltools.routineeditor.parameter.internal.ParameterTableDialog;
import org.eclipse.datatools.sqltools.routineeditor.ui.launching.Messages;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;

public class LaunchUI {
    public static ParameterInOutWrapper[] getAllParameterWrappers(ProcIdentifier proc) throws SQLException, NoSuchProfileException {
        IControlConnection con = EditorCorePlugin.getControlConnectionManager().getOrCreateControlConnection(proc.getDatabaseIdentifier());
        IDBItem item = con.getDBItem(proc);
        if (item instanceof ISPUDF) {
            ParameterDescriptor[] descs = ((ISPUDF)item).getParameterDescriptor();
            ParameterInOutWrapper[] _pw = new ParameterInOutWrapper[descs.length];
            int j = 0;
            int k = 0;
            for (int i = 0; i < descs.length; ++i) {
                int paramType = descs[i].getParmType();
                if (paramType == 4 || paramType == 0) {
                    _pw[descs.length - 1 - k] = new ParameterInOutWrapper(descs[i]);
                    ++k;
                    continue;
                }
                _pw[j] = new ParameterInOutWrapper(descs[i]);
                ++j;
            }
            return _pw;
        }
        return new ParameterInOutWrapper[0];
    }

    public static ParameterInOutWrapper[] getAllParameterWrappersByOrder(ProcIdentifier proc) throws SQLException, NoSuchProfileException {
        IControlConnection con = EditorCorePlugin.getControlConnectionManager().getOrCreateControlConnection(proc.getDatabaseIdentifier());
        IDBItem item = con.getDBItem(proc);
        if (item instanceof ISPUDF) {
            ParameterDescriptor[] descs = ((ISPUDF)item).getParameterDescriptor();
            ParameterInOutWrapper[] _pw = new ParameterInOutWrapper[descs.length];
            for (int i = 0; i < descs.length; ++i) {
                int paramType = descs[i].getParmType();
                _pw[i] = new ParameterInOutWrapper(descs[i]);
            }
            return _pw;
        }
        return new ParameterInOutWrapper[0];
    }

    public static ParameterDescriptor[] getAllParameterDescriptors(ProcIdentifier proc) throws SQLException, NoSuchProfileException {
        IControlConnection con = EditorCorePlugin.getControlConnectionManager().getOrCreateControlConnection(proc.getDatabaseIdentifier());
        IDBItem item = con.getDBItem(proc);
        if (item instanceof ISPUDF) {
            ParameterDescriptor[] descs = ((ISPUDF)item).getParameterDescriptor();
            return descs;
        }
        return new ParameterDescriptor[0];
    }

    public static ParameterDescriptor[] getParameterDescriptors(ProcIdentifier proc) throws SQLException, NoSuchProfileException {
        IControlConnection con = EditorCorePlugin.getControlConnectionManager().getOrCreateControlConnection(proc.getDatabaseIdentifier());
        IDBItem item = con.getDBItem(proc);
        if (item instanceof ISPUDF) {
            ParameterDescriptor[] descs = ((ISPUDF)item).getParameterDescriptor();
            ArrayList<ParameterDescriptor> l = new ArrayList<ParameterDescriptor>(descs.length);
            for (int i = 0; i < descs.length; ++i) {
                if (descs[i].getParmType() == 5 || descs[i].getParmType() == 4 || descs[i].getParmType() == 3 || descs[i].getParmType() == 0) continue;
                l.add(descs[i]);
            }
            return l.toArray(new ParameterDescriptor[l.size()]);
        }
        return new ParameterDescriptor[0];
    }

    public static List configParameter(Shell shell, ParameterDescriptor[] pds, List valueList, boolean always, ILaunchConfiguration configuration) {
        if (!(pds != null && pds.length != 0 || always)) {
            valueList.clear();
            return valueList;
        }
        ParameterWrapper[] wrappers = LaunchUI.getParameterWrapper(pds, valueList);
        ParameterTableDialog dialog = null;
        try {
            DatabaseIdentifier dbid = LaunchHelper.readDatabaseIdentifier(configuration);
            SQLDevToolsConfiguration conf = SQLToolsFacade.getConfiguration((DatabaseIdentifier)dbid, null);
            dialog = conf.getUIComponentService().getParameterTableDialog(shell, wrappers, configuration);
        }
        catch (CoreException e) {
            RoutineEditorActivator.getDefault().log(e);
        }
        if (dialog == null) {
            dialog = new ParameterTableDialog(shell, wrappers);
        }
        if (dialog.open() == 0) {
            valueList.clear();
            for (int i = 0; i < wrappers.length; ++i) {
                if (wrappers[i].isNull()) {
                    valueList.add(null);
                    continue;
                }
                valueList.add(wrappers[i].getValue());
            }
            return valueList;
        }
        return null;
    }

    public static ParameterWrapper[] getParameterWrapper(ParameterDescriptor[] pds, List valueList) {
        ParameterWrapper[] wrappers = new ParameterWrapper[pds.length];
        for (int i = 0; i < pds.length; ++i) {
            wrappers[i] = new ParameterWrapper(pds[i]);
            if (valueList.size() > i && valueList.get(i) != null) {
                wrappers[i].setNull(false);
                wrappers[i].setValue((String)valueList.get(i));
                continue;
            }
            String defaultValue = wrappers[i].getParameterDescriptor().getDefaultValue();
            if (defaultValue != null) {
                wrappers[i].setNull(false);
                wrappers[i].setValue(defaultValue);
                continue;
            }
            wrappers[i].setNull(true);
        }
        return wrappers;
    }

    public static boolean configEventParameters(Shell shell, String[] pNames, Map eventTriggerParams, ProcIdentifier proc) {
        for (int i = 0; i < pNames.length; ++i) {
            if (eventTriggerParams.containsKey(pNames[i])) continue;
            eventTriggerParams.put(pNames[i], "");
        }
        EventParameter[] eps = new EventParameter[eventTriggerParams.size()];
        int mapsize = eventTriggerParams.size();
        Iterator keyValuePairs1 = eventTriggerParams.entrySet().iterator();
        for (int i = 0; i < mapsize; ++i) {
            Map.Entry entry = keyValuePairs1.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (eps[i] == null) {
                eps[i] = new EventParameter();
            }
            if (key != null) {
                eps[i].setName((String)key);
            }
            if (value == null) continue;
            eps[i].setValue((String)value);
        }
        if (eps.length >= 0) {
            IControlConnection con;
            try {
                con = EditorCorePlugin.getControlConnectionManager().getOrCreateControlConnection(proc.getDatabaseIdentifier());
            }
            catch (Exception e) {
                RoutineEditorActivator.getDefault().log(e);
                return false;
            }
            EventParameterTableDialog dlg = new EventParameterTableDialog(shell, eps, (IEvent)con.getDBItem(proc));
            if (dlg.open() == 0) {
                eps = dlg.getEventParameter();
                eventTriggerParams.clear();
                for (int i = 0; i < eps.length; ++i) {
                    if (eps[i].getValue() == null || "".equals(eps[i].getValue()) || "''".equals(eps[i].getValue())) continue;
                    String name = eps[i].getName();
                    String value = eps[i].getValue();
                    eventTriggerParams.put(name, value);
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public static ProcIdentifier getActiveProcIdentifier() {
        Object obj;
        IStructuredSelection ss;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        ISelection selection = page.getSelection();
        if (selection instanceof IStructuredSelection && !(ss = (IStructuredSelection)selection).isEmpty() && (obj = ss.getFirstElement()) instanceof ProcIdentifier) {
            return (ProcIdentifier)obj;
        }
        IEditorPart part = page.getActiveEditor();
        if (part != null) {
            IEditorInput input = part.getEditorInput();
            return (ProcIdentifier)input.getAdapter(ProcIdentifier.class);
        }
        return null;
    }

    public static ProcIdentifier selectDatabaseObject(Shell shell, DatabaseIdentifier databaseIdentifier, int type, ProcIdentifier old) throws SQLException, NoSuchProfileException {
        IControlConnection controlCon = EditorCorePlugin.getControlConnectionManager().getOrCreateControlConnection(databaseIdentifier);
        ProcIdentifier[] procids = controlCon.getAllProcs();
        ArrayList<ProcIdentifier> resultlist = new ArrayList<ProcIdentifier>();
        for (int i = 0; i < procids.length; ++i) {
            if (type != procids[i].getType()) continue;
            resultlist.add(procids[i]);
        }
        procids = resultlist.toArray(new ProcIdentifier[resultlist.size()]);
        ListDialog dialog = new ListDialog(shell);
        switch (type) {
            case 0: {
                dialog.setTitle(Messages.LaunchUI_selectSP);
                dialog.setMessage(Messages.LaunchUI_selectSPMessage);
                break;
            }
            case 1: {
                dialog.setTitle(Messages.LaunchUI_selectUDF);
                dialog.setMessage(Messages.LaunchUI_selectUDFMessage);
                break;
            }
            case 2: {
                dialog.setTitle(Messages.LaunchUI_selectEVENT);
                dialog.setMessage(Messages.LaunchUI_selectEVENTMessage);
                break;
            }
            case 3: {
                dialog.setTitle(Messages.LaunchUI_selectTRIGGER);
                dialog.setMessage(Messages.LaunchUI_selectTRIGGERMessage);
            }
        }
        dialog.setInput((Object)procids);
        dialog.setContentProvider(new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        dialog.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ProcIdentifier)element).getLongDisplayString();
            }
        });
        if (old != null) {
            dialog.setInitialSelections(new Object[]{old});
        }
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            if (result == null || result.length == 0) {
                return null;
            }
            return (ProcIdentifier)result[0];
        }
        return null;
    }
}

