/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.debugger.actions;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.EditorCorePlugin;
import org.eclipse.datatools.sqltools.core.IControlConnection;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.debugger.actions.ToggleBreakpointAdapter;
import org.eclipse.datatools.sqltools.debugger.core.internal.DebuggerCorePlugin;
import org.eclipse.datatools.sqltools.debugger.core.internal.DebuggerMessages;
import org.eclipse.datatools.sqltools.debugger.model.SPDebugModelUtil;
import org.eclipse.datatools.sqltools.routineeditor.ProcEditorInput;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public class ManageBreakpointRulerAction
extends Action
implements IUpdate {
    private IVerticalRulerInfo fRuler;
    private ITextEditor fTextEditor;
    private ToggleBreakpointAdapter fBreakpointAdapter;

    public ManageBreakpointRulerAction(IVerticalRulerInfo ruler, ITextEditor editor) {
        super(DebuggerMessages.ManageBreakpointRulerAction_label);
        this.fRuler = ruler;
        this.fTextEditor = editor;
        this.fBreakpointAdapter = new ToggleBreakpointAdapter();
    }

    public void dispose() {
        this.fTextEditor = null;
        this.fRuler = null;
    }

    protected IVerticalRulerInfo getVerticalRulerInfo() {
        return this.fRuler;
    }

    protected ITextEditor getTextEditor() {
        return this.fTextEditor;
    }

    protected Shell getShell() {
        return this.fTextEditor.getSite().getShell();
    }

    protected IDocument getDocument() {
        IDocumentProvider provider = this.fTextEditor.getDocumentProvider();
        return provider.getDocument((Object)this.fTextEditor.getEditorInput());
    }

    public void run() {
        if (this.getTextEditor().isDirty()) {
            String preferenceKey = "debug.prompt.settingBreakPointDisable";
            String notPrompt = DebuggerCorePlugin.getDefault().getPreferenceStore().getString(preferenceKey);
            if ("always".equals(notPrompt)) {
                this.fBreakpointAdapter.report(DebuggerMessages.ToggleBreakpointAdapter_canToggleLineBreakpoints_message, (IWorkbenchPart)this.getTextEditor());
                return;
            }
            IWorkbenchWindow window = DebuggerCorePlugin.getActiveWorkbenchWindow();
            Shell shell = window.getShell();
            if (shell == null) {
                return;
            }
            if (shell.getMinimized()) {
                shell.setMinimized(false);
            }
            MessageDialogWithToggle dialog = MessageDialogWithToggle.openInformation((Shell)shell, (String)DebuggerMessages.ToggleBreakpointAdapter_canToggleLineBreakpoints_title, (String)DebuggerMessages.ToggleBreakpointAdapter_canToggleLineBreakpoints_message, (String)DebuggerMessages.ToggleBreakpointAdapter_canToggleLineBreakpoints_toggleMessage, (boolean)false, (IPreferenceStore)DebuggerCorePlugin.getDefault().getPreferenceStore(), (String)preferenceKey);
            return;
        }
        try {
            int lineNumber = this.getVerticalRulerInfo().getLineOfLastMouseButtonActivity() + 1;
            IEditorInput input = this.fTextEditor.getEditorInput();
            if (!(input instanceof ProcEditorInput)) {
                return;
            }
            ProcIdentifier procid = ((ProcEditorInput)input).getProcIdentifier();
            List list = SPDebugModelUtil.findAllLineBreakpoint(procid, lineNumber);
            if (list.isEmpty()) {
                this.fBreakpointAdapter.toggleLineBreakpoints((IEditorPart)this.fTextEditor, lineNumber);
            } else {
                IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    IBreakpoint breakpoint = (IBreakpoint)iterator.next();
                    if (breakpoint == null) continue;
                    breakpoint.delete();
                }
            }
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)DebuggerMessages.ManageBreakpointRulerAction_error, (String)DebuggerMessages.ManageBreakpointRulerAction_fail, (IStatus)DebuggerCorePlugin.getDefault().createErrorStatus(e));
        }
    }

    protected AbstractMarkerAnnotationModel getAnnotationModel() {
        IDocumentProvider provider = this.fTextEditor.getDocumentProvider();
        IAnnotationModel model = provider.getAnnotationModel((Object)this.fTextEditor.getEditorInput());
        if (model instanceof AbstractMarkerAnnotationModel) {
            return (AbstractMarkerAnnotationModel)model;
        }
        return null;
    }

    protected boolean includesRulerLine(Position position, IDocument document) {
        if (position != null) {
            try {
                int markerLine = document.getLineOfOffset(position.getOffset());
                int line = this.fRuler.getLineOfLastMouseButtonActivity();
                if (line == markerLine) {
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return false;
    }

    public void update() {
        if (this.fTextEditor instanceof SQLEditor) {
            SQLEditor sqlEditor = (SQLEditor)this.fTextEditor;
            if (sqlEditor.getEditorInput() instanceof ProcEditorInput) {
                IControlConnection con = null;
                try {
                    DatabaseIdentifier dbid = new DatabaseIdentifier(sqlEditor.getConnectionInfo().getConnectionProfileName(), sqlEditor.getConnectionInfo().getDatabaseName());
                    con = EditorCorePlugin.getControlConnectionManager().getOrCreateControlConnection(dbid);
                }
                catch (Exception e) {
                    DebuggerCorePlugin.getDefault().log(DebuggerMessages.ManageBreakpointRulerAction_exception_getControlConnection, e);
                }
                this.setEnabled(con != null && con.supportsDebugging());
            } else {
                this.setEnabled(false);
            }
        }
    }
}

