/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.debugger.core;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.datatools.connectivity.ConnectEvent;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.EditorCorePlugin;
import org.eclipse.datatools.sqltools.core.IResourceDisposeListener;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.ServerIdentifier;
import org.eclipse.datatools.sqltools.core.profile.ConnectProfile;
import org.eclipse.datatools.sqltools.core.profile.ISQLToolsProfileListener;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.datatools.sqltools.core.profile.SQLToolsProfileListenersManager;
import org.eclipse.datatools.sqltools.debugger.core.IDebugHandler;
import org.eclipse.datatools.sqltools.debugger.core.IDebugHandlerManager;
import org.eclipse.datatools.sqltools.debugger.core.SQLDebuggerConfiguration;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLToolsConnectListener;
import org.eclipse.datatools.sqltools.editor.core.connection.SQLToolsConnectListenersManager;

public class DebugHandlerManager
implements IDebugHandlerManager,
ISQLToolsProfileListener,
ISQLToolsConnectListener {
    Map _debugHandlers = new Hashtable();

    public DebugHandlerManager() {
        SQLToolsProfileListenersManager pManager = SQLToolsProfileListenersManager.getInstance();
        pManager.addProfileListener((ISQLToolsProfileListener)this);
        SQLToolsConnectListenersManager cManager = SQLToolsConnectListenersManager.getInstance();
        cManager.addConnectListener((ISQLToolsConnectListener)this);
    }

    public synchronized IDebugHandler getOrCreateDebugHandler(String profileName) {
        SQLDevToolsConfiguration conf;
        IDebugHandler debugHandler = (IDebugHandler)this._debugHandlers.get(profileName);
        if (debugHandler == null && (conf = SQLToolsFacade.getConfigurationByProfileName((String)profileName)) != null && conf instanceof SQLDebuggerConfiguration) {
            SQLDebuggerConfiguration factory = (SQLDebuggerConfiguration)conf;
            debugHandler = factory.createDebugHandler(profileName);
            this._debugHandlers.put(profileName, debugHandler);
            EditorCorePlugin.getControlConnectionManager().addResourceDisposeListener(profileName, (IResourceDisposeListener)new DebugHandlerDisposeListener(debugHandler));
            debugHandler.init();
        }
        return debugHandler;
    }

    public synchronized void dispose() {
        SQLToolsProfileListenersManager pManager = SQLToolsProfileListenersManager.getInstance();
        pManager.removeProfileListener((ISQLToolsProfileListener)this);
        SQLToolsConnectListenersManager cManager = SQLToolsConnectListenersManager.getInstance();
        cManager.removeConnectListener((ISQLToolsConnectListener)this);
        Iterator iter = this._debugHandlers.values().iterator();
        while (iter.hasNext()) {
            IDebugHandler handler = (IDebugHandler)iter.next();
            handler.dispose();
        }
        this._debugHandlers.clear();
    }

    public boolean okToClose(ConnectEvent event) {
        return true;
    }

    public void aboutToClose(ConnectEvent event) {
    }

    public void profileConnected(ConnectEvent event) {
    }

    public void closeConnection(ConnectEvent event) {
        IDebugHandler handler = (IDebugHandler)this._debugHandlers.get(event.getConnectionProfile().getName());
        if (handler != null) {
            handler.dispose();
            this._debugHandlers.remove(event.getConnectionProfile().getName());
        }
    }

    public void profileChanged(IConnectionProfile profile, String oldName, String oldDesc, Boolean oldAutoConnect, boolean onlyNameChanged, ConnectProfile oldProfile) {
        IDebugHandler handler = (IDebugHandler)this._debugHandlers.get(oldName);
        if (handler != null) {
            this._debugHandlers.remove(oldName);
            this._debugHandlers.put(profile.getName(), handler);
            EditorCorePlugin.getControlConnectionManager().removeResourceDisposeListener(oldName);
            EditorCorePlugin.getControlConnectionManager().addResourceDisposeListener(profile.getName(), (IResourceDisposeListener)new DebugHandlerDisposeListener(handler));
        }
    }

    public void profileAdded(IConnectionProfile profile) {
        if (!ProfileUtil.isSupportedProfile((IConnectionProfile)profile)) {
            return;
        }
    }

    public void profileDeleted(IConnectionProfile profile) {
        IDebugHandler handler = (IDebugHandler)this._debugHandlers.get(profile.getName());
        if (handler != null) {
            handler.dispose();
            this._debugHandlers.remove(profile.getName());
            EditorCorePlugin.getControlConnectionManager().removeResourceDisposeListener(profile.getName());
        }
    }

    public void profileChanged(IConnectionProfile profile) {
    }

    public IDebugHandler[] getDebugHandler(ServerIdentifier serverIdentifier) {
        ArrayList handlers = new ArrayList();
        Iterator iter = this._debugHandlers.keySet().iterator();
        while (iter.hasNext()) {
            String profile = (String)iter.next();
            ServerIdentifier serverId = ProfileUtil.getServerIdentifier((DatabaseIdentifier)new DatabaseIdentifier(profile));
            if (!serverId.equals((Object)serverIdentifier)) continue;
            handlers.add(this._debugHandlers.get(profile));
        }
        return handlers.toArray(new IDebugHandler[handlers.size()]);
    }

    public IDebugHandler[] getDebugHandlers() {
        return this._debugHandlers.values().toArray(new IDebugHandler[this._debugHandlers.values().size()]);
    }

    public IDebugHandler getDebugHandler(String profileName) {
        return (IDebugHandler)this._debugHandlers.get(profileName);
    }

    public ServerIdentifier[] getServerIdentifiers() {
        ArrayList<ServerIdentifier> servers = new ArrayList<ServerIdentifier>();
        Iterator iter = this._debugHandlers.keySet().iterator();
        while (iter.hasNext()) {
            ServerIdentifier serverIdentifier = ProfileUtil.getServerIdentifier((DatabaseIdentifier)new DatabaseIdentifier((String)iter.next()));
            if (serverIdentifier == null || servers.contains(serverIdentifier)) continue;
            servers.add(serverIdentifier);
        }
        return servers.toArray(new ServerIdentifier[servers.size()]);
    }

    class DebugHandlerDisposeListener
    implements IResourceDisposeListener {
        IDebugHandler _debugHandler;

        public DebugHandlerDisposeListener(IDebugHandler debugHandler) {
            this._debugHandler = debugHandler;
        }

        public void dispose() {
            this._debugHandler.dispose();
            Iterator iter = DebugHandlerManager.this._debugHandlers.keySet().iterator();
            String shouldRemoveProfile = null;
            while (iter.hasNext()) {
                String profile = (String)iter.next();
                if (DebugHandlerManager.this._debugHandlers.get(profile) != this._debugHandler) continue;
                shouldRemoveProfile = profile;
                break;
            }
            if (shouldRemoveProfile != null) {
                DebugHandlerManager.this._debugHandlers.remove(shouldRemoveProfile);
            }
        }
    }
}

