/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.internal.designsession;

import java.io.File;
import java.util.Properties;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.DesignSessionRequest;
import org.eclipse.datatools.connectivity.oda.design.DesignerState;
import org.eclipse.datatools.connectivity.oda.design.OdaDesignSession;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.DesignerUtil;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.OdaProfileUIExplorer;
import org.eclipse.datatools.connectivity.oda.design.ui.nls.Messages;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSourceEditorPage;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.NewDataSourceWizard;
import org.eclipse.datatools.connectivity.oda.profile.OdaProfileExplorer;
import org.eclipse.datatools.connectivity.ui.wizards.NewConnectionProfileWizardPage;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class DataSourceDesignSessionBase {
    private String m_odaDataSourceId;
    private OdaDesignSession m_designSession;
    private NewDataSourceWizard m_wizard;
    private ProfileReferenceBase m_wizardProfileRef;
    private DataSourceEditorPage m_editorPage;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected DataSourceDesignSessionBase(String odaDataSourceId) {
        if (!($assertionsDisabled || odaDataSourceId != null && odaDataSourceId.length() > 0)) {
            throw new AssertionError();
        }
        this.m_odaDataSourceId = odaDataSourceId;
    }

    protected DataSourceDesignSessionBase() {
    }

    protected void restartNewDesign(String odaDataSourceId, String newDataSourceName, ProfileReferenceBase profileRef, DesignSessionRequest request) throws OdaException {
        if (!this.m_odaDataSourceId.equals(odaDataSourceId)) {
            this.m_odaDataSourceId = odaDataSourceId;
            if (this.m_wizard != null) {
                this.m_wizard.dispose();
            }
            this.m_wizard = null;
        }
        this.initNewDesign(newDataSourceName, profileRef, request);
    }

    protected void initNewDesign(String newDataSourceName, ProfileReferenceBase profileRef, DesignSessionRequest request) throws OdaException {
        NewDataSourceWizard wizard = this.getExtendedWizard();
        Properties profileProps = null;
        String profileName = null;
        String profileDesc = null;
        if (profileRef != null && !profileRef.equals(this.m_wizardProfileRef)) {
            profileProps = this.getProfileProperties(profileRef.getInstanceId());
            IConnectionProfile profileInstance = OdaProfileExplorer.getInstance().getProfile(profileRef.getInstanceId());
            if (!$assertionsDisabled && profileInstance == null) {
                throw new AssertionError();
            }
            profileName = profileInstance.getName();
            profileDesc = profileInstance.getDescription();
            if (newDataSourceName == null || newDataSourceName.length() == 0) {
                newDataSourceName = profileName;
            }
        }
        this.initWizard(wizard, newDataSourceName, profileDesc, profileProps);
        this.m_wizardProfileRef = profileRef;
        if (profileRef != null && profileRef.maintainExternalLink()) {
            wizard.setLinkedProfile(profileName, profileRef.getStorageFile());
        }
    }

    protected void initEditDesign(DesignSessionRequest request, DataSourceEditorPage editorPage) throws OdaException {
        if (editorPage == null) {
            editorPage = this.getExtendedEditorPage();
        }
        OdaDesignSession odaDesign = DesignFactory.eINSTANCE.createOdaDesignSession();
        odaDesign.setRequest(request);
        editorPage.initEditSession(odaDesign);
        if (this.m_editorPage != editorPage) {
            this.m_editorPage = editorPage;
        }
        this.m_designSession = odaDesign;
    }

    protected DesignSessionRequest getRequest() {
        if (this.m_designSession == null) {
            return null;
        }
        return this.m_designSession.getRequest();
    }

    protected OdaDesignSession finish() throws OdaException {
        OdaDesignSession finishedSession = this.m_wizard != null ? this.finishNewDataSource() : this.finishEditDataSource();
        this.m_designSession = null;
        this.disposePages();
        return finishedSession;
    }

    protected OdaDesignSession cancel() {
        if (this.m_designSession == null) {
            this.m_designSession = DesignFactory.eINSTANCE.createRequestDesignSession(null);
        }
        this.m_designSession.setResponseInCancelledState();
        OdaDesignSession cancelledSession = this.m_designSession;
        this.m_designSession = null;
        this.disposePages();
        return cancelledSession;
    }

    private void disposePages() {
        if (this.m_wizard != null) {
            this.m_wizard.dispose();
            this.m_wizard = null;
        }
        if (this.m_editorPage != null) {
            this.m_editorPage.dispose();
            this.m_editorPage = null;
        }
        this.m_wizardProfileRef = null;
    }

    protected IWizard getNewWizard() throws OdaException {
        return this.getExtendedWizard();
    }

    protected IWizardPage getWizardStartingPage() throws OdaException {
        return this.getExtendedWizard().getCustomStartingPage();
    }

    protected NewDataSourceWizard getExtendedWizard() throws OdaException {
        if (this.m_wizard == null) {
            this.m_wizard = OdaProfileUIExplorer.getInstance().getNewDataSourceWizardByType(this.m_odaDataSourceId);
            if (this.m_wizard == null) {
                this.m_wizard = new NewDataSourceWizard(this.m_odaDataSourceId);
            }
        }
        return this.m_wizard;
    }

    private void initWizard(NewDataSourceWizard wizard, String aDataSourceName, String aDataSourceDesc, Properties dataSourceProps) throws OdaException {
        wizard.setInOdaDesignSession(true);
        wizard.addPages();
        if (wizard.getStartingPage() instanceof NewConnectionProfileWizardPage) {
            if (aDataSourceName == null || aDataSourceName.length() == 0) {
                throw new OdaException(Messages.designSession_invalidArgument);
            }
            NewConnectionProfileWizardPage profileNamePage = (NewConnectionProfileWizardPage)wizard.getStartingPage();
            profileNamePage.setProfileName(aDataSourceName);
            profileNamePage.setProfileDescription(aDataSourceDesc);
            profileNamePage.setPageComplete(true);
        }
        if (dataSourceProps != null && !dataSourceProps.isEmpty()) {
            wizard.setInitialProperties(dataSourceProps);
        }
    }

    protected PropertyPage getEditorPage() throws OdaException {
        return this.getAdaptableEditorPage();
    }

    protected IAdaptable getEditPropertyPageElement() throws OdaException {
        if (this.m_designSession == null) {
            throw new OdaException(Messages.common_notInDesignSession);
        }
        return DesignerUtil.getAdaptableDataSourceDesign(this.m_designSession);
    }

    protected DataSourceEditorPage getAdaptableEditorPage() throws OdaException {
        DataSourceEditorPage editorPage = this.getExtendedEditorPage();
        if (editorPage.getElement() == null) {
            editorPage.setElement(this.getEditPropertyPageElement());
        }
        return editorPage;
    }

    protected DataSourceEditorPage getExtendedEditorPage() throws OdaException {
        if (this.m_editorPage == null) {
            this.m_editorPage = OdaProfileUIExplorer.getInstance().getDataSourceEditorPage(this.m_odaDataSourceId);
            if (this.m_editorPage == null) {
                throw new OdaException(Messages.extension_missingPropertyPage);
            }
        }
        return this.m_editorPage;
    }

    private Properties getProfileProperties(String profileInstanceId) throws OdaException {
        Properties profileProps;
        try {
            IConnectionProfile profile = OdaProfileExplorer.getInstance().getProfile(profileInstanceId);
            if (!this.m_odaDataSourceId.equalsIgnoreCase(profile.getProviderId())) {
                throw new IllegalArgumentException();
            }
            profileProps = profile.getBaseProperties();
        }
        catch (Exception ex) {
            throw new OdaException((Throwable)ex);
        }
        return profileProps;
    }

    protected OdaDesignSession finishNewDataSource() throws OdaException {
        NewDataSourceWizard wizard = null;
        try {
            wizard = this.getExtendedWizard();
        }
        catch (OdaException e) {
            e.printStackTrace();
        }
        DataSourceDesign newDataSourceDesign = wizard != null ? wizard.getDataSourceDesign() : null;
        return DataSourceDesignSessionBase.createResponseDesignSession(newDataSourceDesign, wizard);
    }

    protected OdaDesignSession finishNewDesignFromProfile(String newDataSourceName, ProfileReferenceBase profileRef) throws OdaException {
        NewDataSourceWizard wizard = this.getExtendedWizard();
        DataSourceDesign newDataSourceDesign = wizard.finishDataSourceDesign();
        if (newDataSourceDesign != null) {
            IConnectionProfile profileInstance = OdaProfileExplorer.getInstance().getProfile(profileRef.getInstanceId());
            if (!$assertionsDisabled && profileInstance == null) {
                throw new AssertionError();
            }
            if (newDataSourceName == null || newDataSourceName.length() == 0) {
                newDataSourceName = profileInstance.getName();
            }
            newDataSourceDesign.setName(newDataSourceName);
            newDataSourceDesign.setDisplayName(profileInstance.getDescription());
        }
        return DataSourceDesignSessionBase.createResponseDesignSession(newDataSourceDesign, wizard);
    }

    protected static OdaDesignSession createResponseDesignSession(DataSourceDesign newDataSourceDesign, NewDataSourceWizard wizard) {
        DesignerState customState;
        boolean isSessionOk = newDataSourceDesign != null;
        OdaDesignSession responseSession = DesignFactory.eINSTANCE.createResponseDesignSession(isSessionOk, newDataSourceDesign);
        if (wizard != null && (customState = wizard.getResponseDesignerState()) != null) {
            responseSession.getResponse().setDesignerState(customState);
        }
        return responseSession;
    }

    protected OdaDesignSession finishEditDataSource() throws OdaException {
        if (!$assertionsDisabled && this.m_designSession == null) {
            throw new AssertionError();
        }
        DataSourceEditorPage editorPage = null;
        editorPage = this.getExtendedEditorPage();
        if (!$assertionsDisabled && editorPage == null) {
            throw new AssertionError();
        }
        return editorPage.getEditSessionResponse();
    }

    static {
        $assertionsDisabled = !DataSourceDesignSessionBase.class.desiredAssertionStatus();
    }

    public static class ProfileReferenceBase {
        private String m_profileInstanceId;
        private File m_storageFile;
        private boolean m_maintainLink;

        public ProfileReferenceBase(String profileInstanceId, File storageFile, boolean maintainExternalLink) {
            this.m_profileInstanceId = profileInstanceId;
            this.m_storageFile = storageFile;
            this.m_maintainLink = maintainExternalLink;
        }

        public String getInstanceId() {
            return this.m_profileInstanceId;
        }

        public File getStorageFile() {
            return this.m_storageFile;
        }

        public boolean maintainExternalLink() {
            return this.m_maintainLink;
        }

        public boolean equals(ProfileReferenceBase aProfileRef) {
            if (aProfileRef == null) {
                return false;
            }
            return this.m_profileInstanceId.equals(aProfileRef.m_profileInstanceId) && this.m_storageFile.equals(aProfileRef.m_storageFile) && this.m_maintainLink == aProfileRef.m_maintainLink;
        }
    }
}

