/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.ui.view;

import java.util.List;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IProfileListener;
import org.eclipse.datatools.connectivity.IProfileListener1;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.sqltools.result.internal.ResultsViewPlugin;
import org.eclipse.datatools.sqltools.result.internal.core.IResultManagerListener;
import org.eclipse.datatools.sqltools.result.internal.filters.ConnectionProfileFilter;
import org.eclipse.datatools.sqltools.result.internal.filters.ResultStatusFilter;
import org.eclipse.datatools.sqltools.result.internal.model.IResultInstance;
import org.eclipse.datatools.sqltools.result.internal.model.ResultItem;
import org.eclipse.datatools.sqltools.result.internal.ui.actions.RemoveAllVisibleFinishedResultAction;
import org.eclipse.datatools.sqltools.result.internal.ui.actions.RemoveResultAction;
import org.eclipse.datatools.sqltools.result.internal.ui.actions.SaveResultInstanceAction;
import org.eclipse.datatools.sqltools.result.internal.ui.actions.TerminateInstanceAction;
import org.eclipse.datatools.sqltools.result.internal.ui.filters.OpenFilterDialogAction;
import org.eclipse.datatools.sqltools.result.internal.ui.view.ResultHistorySection;
import org.eclipse.datatools.sqltools.result.internal.ui.view.ResultSection;
import org.eclipse.datatools.sqltools.result.internal.ui.view.ResultSectionFactory;
import org.eclipse.datatools.sqltools.result.internal.ui.view.SingleTabDisplayAction;
import org.eclipse.datatools.sqltools.result.internal.ui.view.TextModeDisplayAction;
import org.eclipse.datatools.sqltools.result.internal.utils.Images;
import org.eclipse.datatools.sqltools.result.internal.utils.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.part.ViewPart;

public class ResultsView
extends ViewPart
implements IPropertyChangeListener,
IProfileListener1 {
    private SashForm _sashform;
    private Composite _leftArea;
    private Composite _detailArea;
    private ResultSection _resultSection;
    private IResultInstance _currentInstance = null;
    private Action _preferenceAction = null;
    private IMemento _memento;
    private IPreferenceStore _store;
    private Display _display;
    private ResultHistorySection _resultHistory;
    private RemoveResultAction _removeResultAction;
    private RemoveAllVisibleFinishedResultAction _removeAllVisibleFinishedResultAction;
    private TerminateInstanceAction _terminateAction;
    private SaveResultInstanceAction _saveResultInstanceAction;
    private VerticalLayoutAction _vLayoutAction;
    private HorizontalLayoutAction _hLayoutAction;
    private OpenFilterDialogAction _openFilterDialogAction;
    SingleTabDisplayAction _singleTabDisplayAction = null;
    TextModeDisplayAction _textModeDisplayAction = null;
    static final String ORIENTATION_GROUP = "orientation";
    private IResultManagerListener _listener = new IResultManagerListener(){

        public void resultInstanceCreated(IResultInstance result) {
            ResultsView.this._display.syncExec(new Runnable(this, result){
                private final /* synthetic */ IResultInstance val$result;
                private final /* synthetic */ 1 this$1;
                {
                    this.this$1 = this$1;
                    this.val$result = val$result;
                }

                public void run() {
                    1.access$000(this.this$1).clearStatusLine();
                    ResultsView.access$100(1.access$000(this.this$1)).search();
                    ResultsView.access$100(1.access$000(this.this$1)).refresh();
                    ResultsView.access$100(1.access$000(this.this$1)).getResultTable().setSelection((ISelection)new StructuredSelection((Object)this.val$result));
                    ResultsView.access$202(1.access$000(this.this$1), this.val$result);
                }
            });
        }

        public void resultInstanceRemoved(IResultInstance result) {
            ResultsView.this._display.syncExec(new Runnable(this){
                private final /* synthetic */ 1 this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    1.access$000(this.this$1).clearStatusLine();
                    ResultsView.access$100(1.access$000(this.this$1)).search();
                    ResultsView.access$100(1.access$000(this.this$1)).refresh();
                }
            });
        }

        public void resultInstancesRemoved(IResultInstance[] results) {
            ResultsView.this._display.syncExec(new Runnable(this){
                private final /* synthetic */ 1 this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    1.access$000(this.this$1).clearStatusLine();
                    ResultsView.access$100(1.access$000(this.this$1)).search();
                    ResultsView.access$100(1.access$000(this.this$1)).refresh();
                }
            });
        }

        public void allResultInstancesRemoved() {
            ResultsView.this._display.syncExec(new Runnable(this){
                private final /* synthetic */ 1 this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    1.access$000(this.this$1).clearStatusLine();
                    ResultsView.access$100(1.access$000(this.this$1)).search();
                    ResultsView.access$100(1.access$000(this.this$1)).refresh();
                }
            });
        }

        public void resultInstanceAppended(IResultInstance instance, ResultItem result, int index) {
            if (instance != ResultsView.this._currentInstance) {
                return;
            }
            ResultsView.this._sashform.getDisplay().syncExec(new Runnable(this, result, index){
                private final /* synthetic */ ResultItem val$result;
                private final /* synthetic */ int val$index;
                private final /* synthetic */ 1 this$1;
                {
                    this.this$1 = this$1;
                    this.val$result = val$result;
                    this.val$index = val$index;
                }

                public void run() {
                    ResultsView.access$400(1.access$000(this.this$1)).onNewItemAppended(this.val$result, this.val$index);
                }
            });
        }

        public void resultInstanceStatusUpdated(IResultInstance instance) {
            if (instance.isFinished()) {
                ResultsView.this._terminateAction.update();
                ResultsView.this._removeResultAction.update();
            }
            ResultsView.this._display.syncExec(new Runnable(this, instance){
                private final /* synthetic */ IResultInstance val$instance;
                private final /* synthetic */ 1 this$1;
                {
                    this.this$1 = this$1;
                    this.val$instance = val$instance;
                }

                public void run() {
                    ResultsView.access$100(1.access$000(this.this$1)).refresh();
                    if (this.val$instance == ResultsView.access$200(1.access$000(this.this$1)) && this.val$instance.isFinished()) {
                        ResultsView.access$400(1.access$000(this.this$1)).onInstanceFinished();
                    }
                }
            });
        }

        public void resultInstanceReset(IResultInstance instance) {
            ResultsView.this._display.syncExec(new Runnable(this, instance){
                private final /* synthetic */ IResultInstance val$instance;
                private final /* synthetic */ 1 this$1;
                {
                    this.this$1 = this$1;
                    this.val$instance = val$instance;
                }

                public void run() {
                    ResultsView.access$100(1.access$000(this.this$1)).search();
                    ResultsView.access$100(1.access$000(this.this$1)).refresh();
                    if (this.val$instance == ResultsView.access$200(1.access$000(this.this$1))) {
                        ResultsView.access$400(1.access$000(this.this$1)).onInstanceReseted();
                    }
                }
            });
        }

        public void parametersShow(IResultInstance instance, List params) {
            if (instance != ResultsView.this._currentInstance) {
                return;
            }
            ResultsView.this._display.syncExec(new Runnable(this, params){
                private final /* synthetic */ List val$params;
                private final /* synthetic */ 1 this$1;
                {
                    this.this$1 = this$1;
                    this.val$params = val$params;
                }

                public void run() {
                    ResultsView.access$400(1.access$000(this.this$1)).onParametersShown(this.val$params);
                }
            });
        }

        static /* synthetic */ ResultsView access$000(1 x0) {
            return x0.ResultsView.this;
        }
    };

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this._memento = memento;
        this._store = ResultsViewPlugin.getDefault().getPreferenceStore();
        this._store.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        this._resultHistory.saveState(memento);
    }

    public void createPartControl(Composite parent) {
        this.setTitleToolTip(Messages.ResultsView_tooltip);
        this._sashform = new SashForm(parent, ResultsViewPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.datatools.sqltools.result.preferences.results.vertical") ? 512 : 65792);
        this._display = this._sashform.getDisplay();
        this._leftArea = new Composite((Composite)this._sashform, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        this._leftArea.setLayout((Layout)layout);
        this._leftArea.layout(true);
        this._detailArea = new Composite((Composite)this._sashform, 0);
        this._detailArea.setLayout((Layout)new FillLayout());
        this._resultSection = ResultSectionFactory.createResultSection(this._detailArea, this);
        this._resultHistory = new ResultHistorySection(this._leftArea, this._detailArea, this);
        this._resultHistory.applyState(this._memento);
        ResultsViewPlugin.getResultManager().addResultManagerListener(this._listener);
        this.getSite().setSelectionProvider((ISelectionProvider)this._resultHistory.getResultTable());
        this.createActions();
        this.initActionBars();
        MenuManager menuBar = (MenuManager)this.getViewSite().getActionBars().getMenuManager();
        menuBar.add((IContributionItem)new Separator());
        menuBar.add((IAction)this._openFilterDialogAction);
        menuBar.add((IAction)this._preferenceAction);
        menuBar.add((IContributionItem)new Separator(ORIENTATION_GROUP));
        menuBar.appendToGroup(ORIENTATION_GROUP, (IAction)this._vLayoutAction);
        menuBar.appendToGroup(ORIENTATION_GROUP, (IAction)this._hLayoutAction);
        ProfileManager pMgr = ProfileManager.getInstance();
        pMgr.addProfileListener((IProfileListener)this);
        this._resultHistory.getResultTable().addFilter((ViewerFilter)new ConnectionProfileFilter(ResultsViewPlugin.getDefault().getPreferenceStore()));
        this._resultHistory.getResultTable().addFilter((ViewerFilter)new ResultStatusFilter(ResultsViewPlugin.getDefault().getPreferenceStore()));
    }

    protected void createActions() {
        this._textModeDisplayAction = new TextModeDisplayAction();
        this._textModeDisplayAction.update();
        this._singleTabDisplayAction = new SingleTabDisplayAction();
        this._singleTabDisplayAction.update();
        IKeyBindingService keyBinding = this.getViewSite().getKeyBindingService();
        IActionBars actionBars = this.getViewSite().getActionBars();
        this._terminateAction = new TerminateInstanceAction((ISelectionProvider)this._resultHistory.getResultTable());
        this._terminateAction.setActionDefinitionId("org.eclipse.datatools.sqltools.result.terminate");
        actionBars.setGlobalActionHandler("org.eclipse.datatools.sqltools.result.terminate", (IAction)this._terminateAction);
        this._saveResultInstanceAction = new SaveResultInstanceAction(this._resultHistory.getResultTable().getTree().getShell(), (ISelectionProvider)this._resultHistory.getResultTable());
        this._removeResultAction = new RemoveResultAction((ISelectionProvider)this._resultHistory.getResultTable());
        this._removeResultAction.setActionDefinitionId("org.eclipse.datatools.sqltools.result.removeInstance");
        actionBars.setGlobalActionHandler("org.eclipse.datatools.sqltools.result.removeInstance", (IAction)this._removeResultAction);
        this._removeAllVisibleFinishedResultAction = new RemoveAllVisibleFinishedResultAction((ISelectionProvider)this._resultHistory.getResultTable(), null);
        this._removeAllVisibleFinishedResultAction.setActionDefinitionId("org.eclipse.datatools.sqltools.result.removeAllInstances");
        actionBars.setGlobalActionHandler("org.eclipse.datatools.sqltools.result.removeAllInstances", (IAction)this._removeAllVisibleFinishedResultAction);
        keyBinding.registerAction((IAction)this._removeResultAction);
        keyBinding.registerAction((IAction)this._removeAllVisibleFinishedResultAction);
        keyBinding.registerAction((IAction)this._terminateAction);
        actionBars.updateActionBars();
        this._preferenceAction = new Action(Messages.ResultsView_preference){

            public void run() {
                String[] preferencePages = new String[]{"org.eclipse.datatools.sqltools.result.displayOption", "org.eclipse.datatools.sqltools.result.resultHistory", "org.eclipse.datatools.sqltools.result.exportFormat"};
                PreferencesUtil.createPreferenceDialogOn(null, (String)preferencePages[0], (String[])preferencePages, null).open();
            }
        };
    }

    protected void initActionBars() {
        IActionBars actionbars = this.getViewSite().getActionBars();
        actionbars.getToolBarManager().add((IAction)this._terminateAction);
        actionbars.getToolBarManager().add((IAction)this._removeResultAction);
        actionbars.getToolBarManager().add((IAction)this._removeAllVisibleFinishedResultAction);
        actionbars.getToolBarManager().add((IContributionItem)new Separator());
        actionbars.getToolBarManager().add((IAction)this._singleTabDisplayAction);
        actionbars.getToolBarManager().add((IAction)this._textModeDisplayAction);
        this._vLayoutAction = new VerticalLayoutAction(this._sashform);
        this._hLayoutAction = new HorizontalLayoutAction(this._sashform);
        this._openFilterDialogAction = new OpenFilterDialogAction(this._resultHistory.getResultTable().getTree().getShell());
        if (ResultsViewPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.datatools.sqltools.result.preferences.results.vertical")) {
            this._vLayoutAction.setChecked(true);
            this._hLayoutAction.setChecked(false);
        } else {
            this._hLayoutAction.setChecked(true);
            this._vLayoutAction.setChecked(false);
        }
        actionbars.getToolBarManager().add((IContributionItem)new Separator());
        actionbars.getToolBarManager().add((IAction)this._openFilterDialogAction);
    }

    public void setFocus() {
        if (this._sashform != null && !this._sashform.isDisposed()) {
            this._sashform.setFocus();
        }
    }

    public void dispose() {
        super.dispose();
        ResultsViewPlugin.getResultManager().removeResultManagerListener(this._listener);
        this._terminateAction.dispose();
        this._removeResultAction.dispose();
        this._store.removePropertyChangeListener((IPropertyChangeListener)this);
        ProfileManager pMgr = ProfileManager.getInstance();
        pMgr.removeProfileListener((IProfileListener)this);
        ResultsViewPlugin.getResultManager().removeResultManagerListener(this._listener);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("org.eclipse.datatools.sqltools.result.preferences.display.displaymode") || event.getProperty().equals("org.eclipse.datatools.sqltools.result.preferences.display.displaywindow") || event.getProperty().equals("org.eclipse.datatools.sqltools.result.preferences.display.nulldisplaystr") || event.getProperty().equals("org.eclipse.datatools.sqltools.result.preferences.display.showrownumber") || event.getProperty().equals("org.eclipse.datatools.sqltools.result.preferences.display.showheadings") || event.getProperty().equals("org.eclipse.datatools.sqltools.result.preferences.display.showrowcountmsg") || event.getProperty().equals("org.eclipse.datatools.sqltools.result.preferences.display.splitmessages") || event.getProperty().equals("org.eclipse.datatools.sqltools.result.preferences.display.tabsnumber")) {
            this._singleTabDisplayAction.update();
            this._textModeDisplayAction.update();
            ISelection selection = this._resultHistory.getSelection();
            IStructuredSelection sSelection = null;
            if (!(selection instanceof IStructuredSelection)) {
                return;
            }
            sSelection = (IStructuredSelection)selection;
            IResultInstance instance = (IResultInstance)sSelection.getFirstElement();
            this.reDisplay(instance);
        }
        if (event.getProperty().equals("org.eclipse.datatools.sqltools.result.ResultsFilterDialog.limitcheck") || event.getProperty().equals("org.eclipse.datatools.sqltools.result.ResultsFilterDialog.limitnum") || event.getProperty().equals("org.eclipse.datatools.sqltools.result.ResultsFilterDialog.critical") || event.getProperty().equals("org.eclipse.datatools.sqltools.result.ResultsFilterDialog.warning") || event.getProperty().equals("org.eclipse.datatools.sqltools.result.ResultsFilterDialog.failed") || event.getProperty().equals("org.eclipse.datatools.sqltools.result.ResultsFilterDialog.success") || event.getProperty().equals("org.eclipse.datatools.sqltools.result.ResultsFilterDialog.terminated") || event.getProperty().equals("org.eclipse.datatools.sqltools.result.ResultsFilterDialog.unknownProfile") || event.getProperty().equals("org.eclipse.datatools.sqltools.result.ResultsFilterDialog.profileFilter.change")) {
            this._resultHistory.getResultTable().refresh();
        }
        if (event.getProperty().equals("org.eclipse.datatools.sqltools.result.preferences.resulthistory.status") || event.getProperty().equals("org.eclipse.datatools.sqltools.result.preferences.resulthistory.operation") || event.getProperty().equals("org.eclipse.datatools.sqltools.result.preferences.resulthistory.frequency") || event.getProperty().equals("org.eclipse.datatools.sqltools.result.preferences.resulthistory.date") || event.getProperty().equals("org.eclipse.datatools.sqltools.result.preferences.resulthistory.action") || event.getProperty().equals("org.eclipse.datatools.sqltools.result.preferences.resulthistory.consumer") || event.getProperty().equals("org.eclipse.datatools.sqltools.result.preferences.resulthistory.profile")) {
            this._resultHistory.reDisplayResults();
        }
    }

    private void reDisplay(final IResultInstance instance) {
        if (instance != null) {
            this._display.syncExec(new Runnable(){

                public void run() {
                    Composite comp;
                    if (ResultsView.this._resultSection != null && (comp = ResultsView.this._resultSection.getControl()) != null && !comp.isDisposed()) {
                        comp.dispose();
                    }
                    ResultsView.this._resultSection = ResultSectionFactory.createResultSection(ResultsView.this._detailArea, ResultsView.this);
                    ResultsView.this._detailArea.layout(true);
                    ResultsView.this._resultSection.showDetail(instance);
                    ResultsView.this._resultHistory.refresh();
                }
            });
        } else {
            this._display.syncExec(new Runnable(){

                public void run() {
                    Composite comp;
                    if (ResultsView.this._resultSection != null && (comp = ResultsView.this._resultSection.getControl()) != null && !comp.isDisposed()) {
                        comp.dispose();
                    }
                    ResultsView.this._resultSection = ResultSectionFactory.createResultSection(ResultsView.this._detailArea, ResultsView.this);
                    ResultsView.this._detailArea.layout(true);
                }
            });
        }
    }

    public ResultSection getResultSection() {
        return this._resultSection;
    }

    public void setResultSection(ResultSection section) {
        this._resultSection = section;
    }

    public IResultInstance getCurrentInstance() {
        return this._currentInstance;
    }

    public IAction[] getRegisteredActions() {
        return new IAction[]{this._removeResultAction, this._removeAllVisibleFinishedResultAction, this._terminateAction, this._saveResultInstanceAction};
    }

    public void clearStatusLine() {
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(null);
    }

    public void refreshResults() {
        this._resultHistory.getResultTable().refresh();
    }

    public void setCurrentInstance(IResultInstance instance) {
        this._currentInstance = instance;
    }

    public void profileChanged(IConnectionProfile profile, String oldName, String oldDesc, Boolean oldAutoConnect) {
        this._sashform.getDisplay().syncExec(new Runnable(){

            public void run() {
                ResultsView.this._resultHistory.getResultTable().refresh();
            }
        });
    }

    public void profileAdded(IConnectionProfile profile) {
        this._sashform.getDisplay().syncExec(new Runnable(){

            public void run() {
                ResultsView.this._resultHistory.getResultTable().refresh();
            }
        });
    }

    public void profileDeleted(IConnectionProfile profile) {
        this._sashform.getDisplay().syncExec(new Runnable(){

            public void run() {
                ResultsView.this._resultHistory.getResultTable().refresh();
            }
        });
    }

    public void profileChanged(IConnectionProfile profile) {
        this._sashform.getDisplay().syncExec(new Runnable(){

            public void run() {
                ResultsView.this._resultHistory.getResultTable().refresh();
            }
        });
    }

    public RemoveAllVisibleFinishedResultAction getRemoveAllVisibleFinishedResultAction() {
        return this._removeAllVisibleFinishedResultAction;
    }

    static /* synthetic */ IResultInstance access$202(ResultsView x0, IResultInstance x1) {
        x0._currentInstance = x1;
        return x0._currentInstance;
    }

    class HorizontalLayoutAction
    extends Action {
        SashForm _sash;

        public HorizontalLayoutAction(SashForm sash) {
            super(Messages.ResultsView_layout_horizontal, 8);
            this._sash = sash;
        }

        public void run() {
            this._sash.setOrientation(256);
            ResultsViewPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.datatools.sqltools.result.preferences.results.vertical", false);
        }

        public ImageDescriptor getImageDescriptor() {
            return Images.DESC_HORIZONTAL_RESULTS_VIEW;
        }
    }

    class VerticalLayoutAction
    extends Action {
        SashForm _sash;

        public VerticalLayoutAction(SashForm sash) {
            super(Messages.ResultsView_layout_vertical, 8);
            this._sash = sash;
        }

        public void run() {
            this._sash.setOrientation(512);
            ResultsViewPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.datatools.sqltools.result.preferences.results.vertical", true);
        }

        public ImageDescriptor getImageDescriptor() {
            return Images.DESC_VERTICAL_RESULTS_VIEW;
        }
    }
}

