/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.ui.viewer;

import org.eclipse.datatools.sqltools.result.IResultSetObject;
import org.eclipse.datatools.sqltools.result.IResultSetRow;
import org.eclipse.datatools.sqltools.result.internal.ResultsViewPlugin;
import org.eclipse.datatools.sqltools.result.internal.utils.HexHelper;
import org.eclipse.datatools.sqltools.result.internal.utils.Messages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

public class ResultSetLabelProvider
implements ITableLabelProvider {
    private IResultSetObject _result;
    private boolean _showRowCount;

    public ResultSetLabelProvider(IResultSetObject result, boolean showRowCount) {
        this._result = result;
        this._showRowCount = showRowCount;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0 && this._showRowCount) {
            return null;
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        IResultSetRow rowdata;
        if (this._showRowCount) {
            if (columnIndex == 0) {
                return Integer.toString((Integer)element + 1);
            }
            --columnIndex;
        }
        if ((rowdata = this._result.getRowData((Integer)element)) == null) {
            IPreferenceStore store = ResultsViewPlugin.getDefault().getPreferenceStore();
            return store.getString("org.eclipse.datatools.sqltools.result.preferences.display.nulldisplaystr");
        }
        Object data = rowdata.getData(columnIndex);
        if (data == null) {
            IPreferenceStore store = ResultsViewPlugin.getDefault().getPreferenceStore();
            return store.getString("org.eclipse.datatools.sqltools.result.preferences.display.nulldisplaystr");
        }
        String outValue = "";
        if (data instanceof byte[]) {
            byte[] os = (byte[])data;
            outValue = HexHelper.toHexString(os);
        } else {
            outValue = data.toString();
        }
        if (outValue.length() > 100) {
            return Messages.ResultSetLabelProvider_longdata;
        }
        return outValue;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

