/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.ui.wizards;

import java.util.Map;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.enablement.oda.xml.ui.utils.XMLRelationInfoUtil;

public class XMLInformationHolder {
    private static Properties prop;

    public static void saveProperties(Properties newProp) {
        if (prop == null) {
            prop = new Properties();
        }
        prop.putAll((Map<?, ?>)newProp);
    }

    public static Properties getProperties() {
        return prop;
    }

    public static String getPropertyValue(String key) {
        if (prop == null) {
            return null;
        }
        return prop.getProperty(key);
    }

    public static void setPropertyValue(String key, String value) {
        if (prop == null) {
            prop = new Properties();
        }
        if (value != null) {
            prop.setProperty(key, value);
        }
    }

    public static void start(DataSetDesign dataSetDesign) {
        String maxRow;
        if (dataSetDesign == null) {
            return;
        }
        String queryText = dataSetDesign.getQueryText();
        if (queryText != null && queryText.trim().length() > 0) {
            XMLInformationHolder.setPropertyValue("RELATIONINFORMATION", queryText);
            String tableName = XMLRelationInfoUtil.getTableName(queryText);
            XMLInformationHolder.setPropertyValue("TABLENAME", tableName);
            String xpath = XMLRelationInfoUtil.getXPathExpression(queryText, tableName);
            XMLInformationHolder.setPropertyValue("XPATHTEXT", xpath);
        }
        if (dataSetDesign.getPrivateProperties() != null) {
            XMLInformationHolder.setPropertyValue("XML_FILE", dataSetDesign.getPrivateProperties().findProperty("XML_FILE").getValue());
            maxRow = dataSetDesign.getPrivateProperties().findProperty("MAX_ROW").getValue();
            XMLInformationHolder.setPropertyValue("MAX_ROW", maxRow != null ? maxRow : "-1");
        } else if (dataSetDesign.getPublicProperties() != null) {
            XMLInformationHolder.setPropertyValue("XML_FILE", dataSetDesign.getPublicProperties().findProperty("XML_FILE").getValue());
            maxRow = dataSetDesign.getPublicProperties().findProperty("MAX_ROW").getValue();
            XMLInformationHolder.setPropertyValue("MAX_ROW", maxRow != null ? maxRow : "-1");
            dataSetDesign.getPublicProperties().unsetProperty("MAX_ROW");
            dataSetDesign.getPublicProperties().unsetProperty("XML_FILE");
        }
        if (dataSetDesign.getDataSourceDesign() != null) {
            DataSourceDesign dataSourceDesign = dataSetDesign.getDataSourceDesign();
            String value = dataSourceDesign.getPublicProperties().findProperty("SCHEMAFILELIST").getValue();
            if (value != null) {
                XMLInformationHolder.setPropertyValue("SCHEMAFILELIST", value == null ? "" : value);
            }
            XMLInformationHolder.setPropertyValue("FILELIST", (value = dataSourceDesign.getPublicProperties().findProperty("FILELIST").getValue()) == null ? "" : value);
        }
    }

    public static void destory() {
        prop = null;
    }
}

