/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.server.internal.ui.dialogs;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.virtual.IConnectionNode;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.services.IServicesManager;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.util.resources.ResourceLoader;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ConnectedServerDialog
extends Dialog {
    private static final ResourceLoader resourceLoader = ResourceLoader.INSTANCE;
    private static final String HEADER_TITLE = resourceLoader.queryString("DATATOOLS.SERVER.UI.DISCONNECT_SERVER_TITLE");
    private static final String SERVER_SELECTION = resourceLoader.queryString("DATATOOLS.SERVER.UI.DISCONNECT_SERVER_SELECTION");
    private static final String CONNECTED_SERVERS = resourceLoader.queryString("DATATOOLS.SERVER.UI.DISCONNECT_CONNECTED_SERVERS");
    private List selection = new LinkedList();
    private Tree tree;

    public ConnectedServerDialog() {
        super(Display.getCurrent().getActiveShell());
        this.setShellStyle(67680);
    }

    private void createTreeDialogArea(Composite composite) {
        Composite parentComposite = new Composite(composite, 0);
        parentComposite.setLayout((Layout)new GridLayout());
        parentComposite.setLayoutData((Object)new GridData(1808));
        parentComposite.setBackground(Display.getCurrent().getSystemColor(15));
        this.tree = new Tree(parentComposite, 772);
        this.tree.setLayoutData((Object)new GridData(1808));
        this.tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem item = (TreeItem)e.item;
                if (item.getData() != null && item.getData() instanceof IConnectionNode) {
                    ConnectedServerDialog.this.selection.add(item.getData());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                TreeItem item = (TreeItem)e.item;
                if (item.getData() != null && item.getData() instanceof IConnectionNode && ConnectedServerDialog.this.selection.contains(item.getData())) {
                    ConnectedServerDialog.this.selection.remove(item.getData());
                }
            }
        });
        IConnectionNode[] connectedServers = IServicesManager.INSTANCE.getServerExplorerContentService().getAllConnectedServers();
        TreeItem root = new TreeItem(this.tree, 0);
        root.setText(CONNECTED_SERVERS);
        root.setImage(resourceLoader.queryImageFromRegistry("connectionFolder.gif"));
        int n = connectedServers.length;
        for (int i = 0; i < n; ++i) {
            IConnectionNode server = connectedServers[i];
            TreeItem item = new TreeItem(root, 0);
            item.setData((Object)server);
            item.setText(server.getDisplayName());
            item.setImage(resourceLoader.queryImageFromRegistry("connection.gif"));
            this.tree.showItem(item);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(HEADER_TITLE);
        shell.setImage(resourceLoader.queryImageFromRegistry("server_explorer.gif"));
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        parentComposite.setLayout((Layout)gridLayout);
        GridData data = new GridData(1808);
        data.widthHint = 300;
        data.heightHint = 150;
        parentComposite.setLayoutData((Object)data);
        Label label = new Label(parentComposite, 0);
        label.setText(SERVER_SELECTION);
        label.setLayoutData((Object)new GridData(768));
        this.createTreeDialogArea(parentComposite);
        return parentComposite;
    }

    public IConnectionNode[] getSelectedServers() {
        return this.selection.toArray(new IConnectionNode[this.selection.size()]);
    }
}

