/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.actions.popup;

import java.util.Iterator;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.virtual.IConnectionNode;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.virtual.IKnownConnectionNode;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.ui.explorer.virtual.IVirtualNode;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.actions.popup.AbstractAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class RefreshAction
extends AbstractAction {
    private IStructuredSelection selection;

    private void refreshCatalogObject(Object[] catalogObjects) {
        int n = catalogObjects.length;
        for (int i = 0; i < n; ++i) {
            if (!(catalogObjects[i] instanceof ICatalogObject)) continue;
            ((ICatalogObject)catalogObjects[i]).refresh();
        }
    }

    private void refreshVirtualNode(IVirtualNode virtualNode) {
        if (virtualNode instanceof IConnectionNode) {
            this.refreshCatalogObject(virtualNode.getChildrenArray());
        } else if (!(virtualNode instanceof IKnownConnectionNode)) {
            Object object = virtualNode.getParent();
            virtualNode.removeAllChildren();
            if (object instanceof ICatalogObject) {
                this.refreshCatalogObject((ICatalogObject)object);
            } else if (object instanceof IVirtualNode) {
                this.refreshVirtualNode((IVirtualNode)object);
            }
        }
    }

    private void refreshCatalogObject(ICatalogObject catalogObject) {
        this.refreshCatalogObject(new ICatalogObject[]{catalogObject});
    }

    private boolean isConnected(Object current) {
        IConnectionNode connectionNode = (IConnectionNode)current;
        return connectionNode.isConnected() && !connectionNode.shouldDisconnect();
    }

    protected void setSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)selection;
        }
    }

    protected ISelection getSelection() {
        return this.selection;
    }

    public void selectionChanged(IAction action, ISelection sel) {
        if (sel instanceof IStructuredSelection && action != null) {
            if (((IStructuredSelection)sel).size() == 1) {
                Object current = ((IStructuredSelection)sel).getFirstElement();
                if (current instanceof IKnownConnectionNode || current instanceof IConnectionNode && !this.isConnected(current)) {
                    action.setEnabled(false);
                } else {
                    action.setEnabled(true);
                }
            } else {
                action.setEnabled(false);
            }
        }
        this.setSelection(sel);
    }

    public void run(IAction action) {
        Iterator iterator = ((IStructuredSelection)this.getSelection()).iterator();
        while (iterator.hasNext()) {
            Object selectedObject = iterator.next();
            if (selectedObject instanceof IVirtualNode) {
                this.refreshVirtualNode((IVirtualNode)selectedObject);
                continue;
            }
            if (!(selectedObject instanceof ICatalogObject)) continue;
            this.refreshCatalogObject((ICatalogObject)selectedObject);
        }
    }
}

