/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.providers.content.layout.vnode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinitionRegistry;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.virtual.IDependencyNode;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.virtual.ISchemaNode;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.ui.explorer.virtual.IVirtualNode;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.providers.content.layout.AbstractOnDemandContentProviderNav;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class ServerExplorerVNodeContentProviderNav
extends AbstractOnDemandContentProviderNav {
    private static DatabaseDefinitionRegistry registry = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry();
    private static final String TABLE = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.TABLE");
    private static final String ROUTINE = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.ROUTINE");
    private static final String SEQUENCE = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.SEQUENCE");
    private static final String UDT = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.UDT");
    private static final String VIEW = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.VIEW");
    private static final String TRIGGER = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.TRIGGER");
    private static final String INDEX = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.INDEX");
    private static final String CONSTRAINT = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.CONSTRAINT");
    private static final String COLUMN = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.COLUMN");
    private static final String DATABASE = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.DATABASE");
    private static final String SCHEMA = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.SCHEMA");
    private static final String DEPENDENCY = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.DEPENDENCY");
    private static final String STORED_PROCEDURE = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.STORED_PROCEDURE");
    private static final String UDF = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.UDF");
    private static final String CATALOG = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.CATALOG");

    private DatabaseDefinition getDatabaseDefinition(Object parent) {
        if (parent instanceof ICatalogObject) {
            return registry.getDefinition(((ICatalogObject)parent).getCatalogDatabase());
        }
        if (parent instanceof Schema) {
            return registry.getDefinition(((Schema)parent).getDatabase());
        }
        if (parent instanceof Table) {
            return registry.getDefinition(((Table)parent).getSchema().getDatabase());
        }
        return null;
    }

    private Collection getChildren(String groupID, List children) {
        ArrayList<EObject> list = new ArrayList<EObject>(children.size());
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            EObject child = (EObject)iterator.next();
            if (!groupID.equals(containmentService.getGroupId(child))) continue;
            list.add(child);
        }
        return list;
    }

    protected Object[] displayCatalogNodeChildren(Object parent) {
        Database database = (Database)((IVirtualNode)parent).getParent();
        return this.getArrays(parent, this.getChildren(((IVirtualNode)parent).getGroupID(), (List)database.getCatalogs()));
    }

    protected Object[] displayCatalogChildren(Object parent) {
        ArrayList<ISchemaNode> collection = new ArrayList<ISchemaNode>(1);
        collection.add(nodeFactory.makeSchemaNode(SCHEMA, SCHEMA, parent));
        return this.getArrays(parent, collection);
    }

    protected Object[] displaySchemaNodeChildren(Object parent) {
        Object modelParent = ((IVirtualNode)parent).getParent();
        if (modelParent instanceof Catalog) {
            return this.getArrays(parent, this.getChildren(((IVirtualNode)parent).getGroupID(), (List)((Catalog)modelParent).getSchemas()));
        }
        return this.getArrays(parent, this.getChildren(((IVirtualNode)parent).getGroupID(), (List)((Database)modelParent).getSchemas()));
    }

    protected Object[] displaySchemaChildren(Object parent) {
        DatabaseDefinition df = this.getDatabaseDefinition(parent);
        ArrayList<Object> collection = new ArrayList<Object>(7);
        collection.add(nodeFactory.makeTableNode(TABLE, TABLE, parent));
        collection.add(nodeFactory.makeViewNode(VIEW, VIEW, parent));
        collection.add(nodeFactory.makeStoredProcedureNode(STORED_PROCEDURE, STORED_PROCEDURE, parent));
        collection.add(nodeFactory.makeUDFNode(UDF, UDF, parent));
        if (df.supportsSequence()) {
            collection.add(nodeFactory.makeSequenceNode(SEQUENCE, SEQUENCE, parent));
        }
        if (df.supportsUserDefinedType()) {
            collection.add(nodeFactory.makeUDTNode(UDT, UDT, parent));
        }
        collection.add(nodeFactory.makeDependencyNode(DEPENDENCY, DEPENDENCY, parent));
        return this.getArrays(parent, collection);
    }

    protected Object[] displayServerChildren(Object parent) {
        return EMPTY_ELEMENT_ARRAY;
    }

    protected Object[] displayDatabaseNodeChildren(Object parent) {
        return EMPTY_ELEMENT_ARRAY;
    }

    protected Object[] displayTableNodeChildren(Object parent) {
        Schema schema = (Schema)((IVirtualNode)parent).getParent();
        return this.getArrays(parent, this.getChildren(((IVirtualNode)parent).getGroupID(), (List)schema.getTables()));
    }

    protected Object[] displayUDFNodeChildren(Object parent) {
        Schema schema = (Schema)((IVirtualNode)parent).getParent();
        return this.getArrays(parent, this.getChildren(((IVirtualNode)parent).getGroupID(), (List)schema.getUDFs()));
    }

    protected Object[] displayStoredProcedureNodeChildren(Object parent) {
        Schema schema = (Schema)((IVirtualNode)parent).getParent();
        return this.getArrays(parent, this.getChildren(((IVirtualNode)parent).getGroupID(), (List)schema.getProcedures()));
    }

    protected Object[] displaySequenceNodeChildren(Object parent) {
        Schema schema = (Schema)((IVirtualNode)parent).getParent();
        return this.getArrays(parent, this.getChildren(((IVirtualNode)parent).getGroupID(), (List)schema.getSequences()));
    }

    protected Object[] displayUDTNodeChildren(Object parent) {
        Schema schema = (Schema)((IVirtualNode)parent).getParent();
        return this.getArrays(parent, this.getChildren(((IVirtualNode)parent).getGroupID(), (List)schema.getUserDefinedTypes()));
    }

    protected Object[] displayTriggerNodeChildren(Object parent) {
        Table table = (Table)((IVirtualNode)parent).getParent();
        return this.getArrays(parent, this.getChildren(((IVirtualNode)parent).getGroupID(), (List)table.getTriggers()));
    }

    protected Object[] displayIndexNodeChildren(Object parent) {
        BaseTable table = (BaseTable)((IVirtualNode)parent).getParent();
        return this.getArrays(parent, this.getChildren(((IVirtualNode)parent).getGroupID(), (List)table.getIndex()));
    }

    protected Object[] displayConstraintNodeChildren(Object parent) {
        BaseTable table = (BaseTable)((IVirtualNode)parent).getParent();
        return this.getArrays(parent, this.getChildren(((IVirtualNode)parent).getGroupID(), (List)table.getConstraints()));
    }

    protected Object[] displayColumnNodeChildren(Object parent) {
        Table table = (Table)((IVirtualNode)parent).getParent();
        return this.getArrays(parent, this.getChildren(((IVirtualNode)parent).getGroupID(), (List)table.getColumns()));
    }

    protected Object[] displayViewsNodeChildren(Object parent) {
        Schema schema = (Schema)((IVirtualNode)parent).getParent();
        return this.getArrays(parent, this.getChildren(((IVirtualNode)parent).getGroupID(), (List)schema.getTables()));
    }

    protected Object[] displayTableChildren(Object parent) {
        DatabaseDefinition df = this.getDatabaseDefinition(parent);
        ArrayList<Object> collection = new ArrayList<Object>(5);
        collection.add(nodeFactory.makeColumnNode(COLUMN, COLUMN, parent));
        if (df.supportsTriggers()) {
            collection.add(nodeFactory.makeTriggerNode(TRIGGER, TRIGGER, parent));
        }
        collection.add(nodeFactory.makeIndexNode(INDEX, INDEX, parent));
        collection.add(nodeFactory.makeConstraintNode(CONSTRAINT, CONSTRAINT, parent));
        collection.add(nodeFactory.makeDependencyNode(DEPENDENCY, DEPENDENCY, parent));
        return this.getArrays(parent, collection);
    }

    protected Object[] displayViewChildren(Object parent) {
        DatabaseDefinition df = this.getDatabaseDefinition(parent);
        ArrayList<Object> collection = new ArrayList<Object>(3);
        collection.add(nodeFactory.makeColumnNode(COLUMN, COLUMN, parent));
        if (df.supportsViewTriggers()) {
            collection.add(nodeFactory.makeTriggerNode(TRIGGER, TRIGGER, parent));
        }
        collection.add(nodeFactory.makeDependencyNode(DEPENDENCY, DEPENDENCY, parent));
        return this.getArrays(parent, collection);
    }

    protected Object[] displayDatabaseChildren(Object parent) {
        ArrayList<Object> collection = new ArrayList<Object>(2);
        EList catalogs = ((Database)parent).getCatalogs();
        if (catalogs.size() == 0) {
            System.err.println("No catalogs found for database.  Update catalog loader to support catalogs.");
            collection.add(nodeFactory.makeSchemaNode(SCHEMA, SCHEMA, parent));
        } else {
            Iterator it = catalogs.iterator();
            while (it.hasNext()) {
                Catalog catalog = (Catalog)it.next();
                if (catalog.getName().length() != 0) continue;
                collection.add(nodeFactory.makeSchemaNode(SCHEMA, SCHEMA, (Object)catalog));
                break;
            }
        }
        if (collection.size() == 0 || catalogs.size() > 1) {
            collection.add(nodeFactory.makeCatalogNode(CATALOG, CATALOG, parent));
        }
        return this.getArrays(parent, collection);
    }

    protected Object[] displayDependencyNodeChildren(Object parent) {
        SQLObject object = (SQLObject)((IVirtualNode)parent).getParent();
        return this.getArrays(parent, this.getChildren(((IVirtualNode)parent).getGroupID(), (List)object.getDependencies()));
    }

    protected Object[] displayStoredProcedureChildren(Object parent) {
        ArrayList<IDependencyNode> collection = new ArrayList<IDependencyNode>(1);
        collection.add(nodeFactory.makeDependencyNode(DEPENDENCY, DEPENDENCY, parent));
        return this.getArrays(parent, collection);
    }

    protected Object[] displayTriggerChildren(Object parent) {
        ArrayList<IDependencyNode> collection = new ArrayList<IDependencyNode>(1);
        collection.add(nodeFactory.makeDependencyNode(DEPENDENCY, DEPENDENCY, parent));
        return this.getArrays(parent, collection);
    }

    protected Object[] displayUDFChildren(Object parent) {
        ArrayList<IDependencyNode> collection = new ArrayList<IDependencyNode>(1);
        collection.add(nodeFactory.makeDependencyNode(DEPENDENCY, DEPENDENCY, parent));
        return this.getArrays(parent, collection);
    }

    protected Object[] displayColumnChildren(Object parent) {
        ArrayList<IDependencyNode> collection = new ArrayList<IDependencyNode>(1);
        collection.add(nodeFactory.makeDependencyNode(DEPENDENCY, DEPENDENCY, parent));
        return this.getArrays(parent, collection);
    }

    protected Object[] displayIndexChildren(Object parent) {
        ArrayList<IDependencyNode> collection = new ArrayList<IDependencyNode>(1);
        collection.add(nodeFactory.makeDependencyNode(DEPENDENCY, DEPENDENCY, parent));
        return this.getArrays(parent, collection);
    }

    protected Object[] displayConstraintChildren(Object parent) {
        ArrayList<IDependencyNode> collection = new ArrayList<IDependencyNode>(1);
        collection.add(nodeFactory.makeDependencyNode(DEPENDENCY, DEPENDENCY, parent));
        return this.getArrays(parent, collection);
    }
}

