/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.internal.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.sqltools.core.DatabaseVendorDefinitionId;
import org.eclipse.datatools.sqltools.core.EditorCorePlugin;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.internal.core.IConfigurationRegistryListener;
import org.eclipse.datatools.sqltools.internal.core.SQLDevToolsConfigRegistry;

public final class SQLDevToolsConfigRegistryImpl
implements SQLDevToolsConfigRegistry {
    public static final SQLDevToolsConfigRegistry INSTANCE = new SQLDevToolsConfigRegistryImpl();
    private static SQLDevToolsConfiguration DEFAULT_CONFIG = SQLDevToolsConfiguration.getDefaultInstance();
    private static ArrayList _listeners = new ArrayList();
    private boolean _factoriesLoaded = false;
    private Map _products = new TreeMap();
    private Map _factoriesById = new TreeMap();
    private Map _factoriesByVendorIdentifier = new TreeMap();
    private Map _factoriesByName = new TreeMap();
    private ArrayList _debuggerFactories = new ArrayList();

    public Collection getProducts() {
        this.init();
        return this._products.keySet();
    }

    public Collection getVersions(String product) {
        this.init();
        Map versions = (Map)this._products.get(product);
        if (versions == null) {
            return new TreeMap().keySet();
        }
        return versions.keySet();
    }

    public Collection getConfigurations() {
        this.init();
        return this._factoriesById.values();
    }

    public Collection getDebuggerConfigurations() {
        this.init();
        return this._debuggerFactories;
    }

    public SQLDevToolsConfiguration getConfiguration(String product, String version) {
        this.init();
        Map versions = (Map)this._products.get(product);
        if (versions == null) {
            return null;
        }
        return (SQLDevToolsConfiguration)versions.get(version);
    }

    public SQLDevToolsConfiguration getConfigurationById(String id) {
        this.init();
        return (SQLDevToolsConfiguration)this._factoriesById.get(id);
    }

    public SQLDevToolsConfiguration getConfigurationByVendorIdentifier(DatabaseVendorDefinitionId id) {
        this.init();
        return (SQLDevToolsConfiguration)this._factoriesByVendorIdentifier.get(id);
    }

    public SQLDevToolsConfiguration getConfigurationByName(String name) {
        this.init();
        return (SQLDevToolsConfiguration)this._factoriesByName.get(name);
    }

    private SQLDevToolsConfigRegistryImpl() {
    }

    private synchronized void init() {
        if (this._factoriesLoaded) {
            return;
        }
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("org.eclipse.datatools.sqltools.editor.core", "dbConfigurations");
        IExtension[] extensions = extensionPoint.getExtensions();
        for (int i = 0; i < extensions.length; ++i) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            for (int j = 0; j < configElements.length; ++j) {
                if (!configElements[j].getName().equals("dbConfiguration")) continue;
                String product = configElements[j].getAttribute("product");
                String version = configElements[j].getAttribute("version");
                String name = product + "_" + version;
                String id = configElements[j].getAttribute("id");
                String supportsDebugging = configElements[j].getAttribute("supportsDebugging");
                String isDefault = configElements[j].getAttribute("default");
                if (id == null) {
                    id = name;
                }
                String className = configElements[j].getAttribute("configurationClass");
                try {
                    DatabaseVendorDefinitionId identifier;
                    SQLDevToolsConfiguration factory = (SQLDevToolsConfiguration)configElements[j].createExecutableExtension("configurationClass");
                    DatabaseVendorDefinitionId dbVendorId = new DatabaseVendorDefinitionId(product, version);
                    factory.setDatabaseVendorDefinitionId(dbVendorId);
                    if (this._products.containsKey(product)) {
                        ((Map)this._products.get(product)).put(version, factory);
                    } else {
                        TreeMap<String, SQLDevToolsConfiguration> versions = new TreeMap<String, SQLDevToolsConfiguration>();
                        versions.put(version, factory);
                        this._products.put(product, versions);
                    }
                    if (!this._factoriesById.containsKey(id)) {
                        this._factoriesById.put(id, factory);
                    }
                    if (!this._factoriesByVendorIdentifier.containsKey(identifier = new DatabaseVendorDefinitionId(product, version))) {
                        this._factoriesByVendorIdentifier.put(identifier, factory);
                    }
                    if (!this._factoriesByName.containsKey(name)) {
                        this._factoriesByName.put(name, factory);
                    }
                    if ("true".equals(supportsDebugging)) {
                        this._debuggerFactories.add(factory);
                    }
                    if (!"true".equals(isDefault)) continue;
                    DEFAULT_CONFIG = factory;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        Status status = new Status(4, "org.eclipse.datatools.sqltools.editor.core", 4, "The error was detected when creating the database recognizer " + className, (Throwable)e);
                        EditorCorePlugin.getDefault().log((IStatus)status);
                        continue;
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                }
            }
        }
        this._factoriesLoaded = true;
        Iterator iter = _listeners.iterator();
        while (iter.hasNext()) {
            final IConfigurationRegistryListener l = (IConfigurationRegistryListener)iter.next();
            new Thread(){

                public void run() {
                    l.configurationLoaded();
                }
            }.start();
        }
    }

    public static SQLDevToolsConfiguration getDefaultConfiguration() {
        return DEFAULT_CONFIG;
    }

    public void addConfigurationRegistryListener(final IConfigurationRegistryListener listener) {
        _listeners.add(listener);
        if (this._factoriesLoaded) {
            new Thread(){

                public void run() {
                    listener.configurationLoaded();
                }
            }.start();
        }
    }

    public static class DBFactoryVersionComparator
    implements Comparator {
        public int compare(Object left, Object right) {
            SQLDevToolsConfiguration f1 = (SQLDevToolsConfiguration)left;
            SQLDevToolsConfiguration f2 = (SQLDevToolsConfiguration)right;
            return new DatabaseVendorDefinitionId.VersionComparator().compare(f1.getDatabaseVendorDefinitionId().getVersion(), f2.getDatabaseVendorDefinitionId().getVersion());
        }
    }
}

