/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sql.util;

import java.util.Iterator;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfoImpl;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.DatabaseConnectionRegistry;
import org.eclipse.datatools.modelbase.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DistinctUserDefinedType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Event;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.datatools.sqltools.sql.reference.IDatatype;
import org.eclipse.datatools.sqltools.sql.reference.internal.Datatype;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ModelUtil {
    public static final String EVENT_FOLDER_CLASS = "DBEventsFolder";

    public static IDatatype map(DatabaseDefinition databaseDefinition, DataType type, String owner) {
        PredefinedDataTypeDefinition typeDefinition = databaseDefinition.getPredefinedDataTypeDefinition(type.getName());
        if (type instanceof PredefinedDataType) {
            return ModelUtil.createIDatatype(typeDefinition, (PredefinedDataType)type, owner);
        }
        if (type instanceof DistinctUserDefinedType) {
            PredefinedDataType pretype = ((DistinctUserDefinedType)type).getPredefinedRepresentation();
            IDatatype datatype = ModelUtil.createIDatatype(typeDefinition, (PredefinedDataType)type, owner);
            return new Datatype(owner, type.getName(), true, datatype, datatype.getLength(), datatype.getPrecision(), datatype.getScale(), datatype.allowNull());
        }
        return null;
    }

    private static IDatatype createIDatatype(PredefinedDataTypeDefinition typeDefinition, PredefinedDataType type, String owner) {
        Datatype datatype = null;
        int length = 0;
        int precision = 0;
        int scale = 0;
        boolean nullable = true;
        if (typeDefinition != null) {
            EStructuralFeature feature;
            if (typeDefinition.isLengthSupported()) {
                feature = type.eClass().getEStructuralFeature("length");
                length = (Integer)type.eGet(feature);
            } else if (typeDefinition.isPrecisionSupported()) {
                feature = type.eClass().getEStructuralFeature("precision");
                precision = (Integer)type.eGet(feature);
            }
            if (typeDefinition.isScaleSupported()) {
                feature = type.eClass().getEStructuralFeature("scale");
                scale = (Integer)type.eGet(feature);
            }
            if (typeDefinition.isNullableSupported() && (feature = type.eClass().getEStructuralFeature("nullable")) != null) {
                nullable = (Boolean)type.eGet(feature);
            }
            datatype = new Datatype(owner, type.getName(), false, null, length, precision, scale, nullable);
        }
        return datatype;
    }

    public static SQLObject findProceduralObject(ProcIdentifier proc) {
        return ModelUtil.findProceduralObject(proc, false);
    }

    public static SQLObject findProceduralObject(ProcIdentifier proc, boolean refresh) {
        block13: {
            Database db = ProfileUtil.getDatabase(proc.getDatabaseIdentifier());
            if (db == null) break block13;
            if (proc.getType() == 2) {
                if (refresh) {
                    ((ICatalogObject)db).refresh();
                }
                EList events = db.getEvents();
                Iterator iter = events.iterator();
                while (iter.hasNext()) {
                    Event routine = (Event)iter.next();
                    if (!routine.getName().equals(proc.getProcName())) continue;
                    return routine;
                }
            } else {
                EList catalogs;
                EList schemas = db.getSchemas();
                if ((schemas == null || schemas.size() == 0) && (catalogs = db.getCatalogs()) != null) {
                    Iterator iter = catalogs.iterator();
                    while (iter.hasNext()) {
                        Catalog catalog = (Catalog)iter.next();
                        if (!catalog.getName().equals(proc.getDatabaseName())) continue;
                        schemas = catalog.getSchemas();
                        break;
                    }
                }
                Iterator i = schemas.iterator();
                while (i.hasNext()) {
                    Iterator iter;
                    Schema schema = (Schema)i.next();
                    if (schema.getName() == null || !schema.getName().equals(proc.getOwnerName())) continue;
                    if (proc.getType() == 3) {
                        EList tables = schema.getTables();
                        iter = tables.iterator();
                        while (iter.hasNext()) {
                            Table table = (Table)iter.next();
                            if (!table.getName().equals(proc.getTableName())) continue;
                            if (refresh && table instanceof ICatalogObject) {
                                ((ICatalogObject)table).refresh();
                            }
                            EList triggers = table.getTriggers();
                            Iterator itera = triggers.iterator();
                            while (itera.hasNext()) {
                                Trigger trigger = (Trigger)itera.next();
                                if (!table.getName().equals(proc.getTableName()) || !trigger.getName().equals(proc.getProcName())) continue;
                                return trigger;
                            }
                        }
                        continue;
                    }
                    if (proc.getType() != 1 && proc.getType() != 0) continue;
                    if (refresh) {
                        ((ICatalogObject)schema).refresh();
                    }
                    EList routines = schema.getRoutines();
                    iter = routines.iterator();
                    while (iter.hasNext()) {
                        Routine routine = (Routine)iter.next();
                        if (!routine.getName().equals(proc.getProcName())) continue;
                        return routine;
                    }
                }
            }
        }
        return null;
    }

    public static Database getDatabase(Schema schema) {
        Catalog catalog = schema.getCatalog();
        if (catalog != null) {
            return catalog.getDatabase();
        }
        return schema.getDatabase();
    }

    public static String getDatabaseName(Schema schema) {
        String _dbName = null;
        Catalog catalog = schema.getCatalog();
        if (catalog != null) {
            _dbName = catalog.getName();
        } else {
            Database _database = schema.getDatabase();
            _dbName = _database.getName();
        }
        return _dbName;
    }

    public static IConnectionProfile getConnectionProfile(Database database) {
        ConnectionInfo connInfo;
        if (database != null && (connInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(database)) instanceof ConnectionInfoImpl) {
            return ((ConnectionInfoImpl)connInfo).getConnectionProfile();
        }
        return null;
    }

    public static EList getSchemas(Database database, String catalogName) {
        EList catalogs;
        EList schemas;
        if (catalogName == null) {
            catalogName = database.getName();
        }
        if (((schemas = database.getSchemas()) == null || schemas.size() == 0) && (catalogs = database.getCatalogs()) != null) {
            Iterator iter = catalogs.iterator();
            while (iter.hasNext()) {
                Catalog catalog = (Catalog)iter.next();
                if (!catalog.getName().equals(catalogName)) continue;
                schemas = catalog.getSchemas();
                break;
            }
        }
        return schemas;
    }
}

