/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util.date;

import com.ibm.icu.text.SimpleDateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.datatools.enablement.oda.xml.util.date.PatternKey;

public class DateFormatISO8601 {
    private static Map simpleDateFormatterMap = null;

    static {
        String[] dateFormatPattern = new String[]{"yyyy-MM-dd HH:mm:ss.S z", "yyyy-MM-dd HH:mm:ss.Sz", "yyyy-MM-dd HH:mm:ss.S", "yyyy-MM-dd HH:mm:ss z", "yyyy-MM-dd HH:mm:ssz", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm z", "yyyy-MM-dd HH:mmz", "yyyy-MM-dd HH:mm", "yyyy-MM-dd", "yyyy-MM", "yyyy", "HH:mm:ss.S z", "HH:mm:ss.Sz", "HH:mm:ss.S", "HH:mm:ss z", "HH:mm:ssz", "HH:mm:ss", "HH:mm z", "HH:mmz", "HH:mm"};
        SimpleDateFormat simpleDateFormatter = null;
        PatternKey patterKey = null;
        simpleDateFormatterMap = new HashMap(128);
        int i = 0;
        while (i < dateFormatPattern.length) {
            patterKey = DateFormatISO8601.getPatterKey(dateFormatPattern[i]);
            simpleDateFormatter = new SimpleDateFormat(dateFormatPattern[i]);
            simpleDateFormatter.setLenient(false);
            simpleDateFormatterMap.put(patterKey, simpleDateFormatter);
            ++i;
        }
    }

    public static Date parse(String source) throws ParseException {
        Date resultDate = null;
        Object simpleDateFormatter = simpleDateFormatterMap.get(DateFormatISO8601.getPatterKey(source = DateFormatISO8601.cleanDate(source)));
        if (simpleDateFormatter != null) {
            try {
                resultDate = ((SimpleDateFormat)simpleDateFormatter).parse(source);
                return resultDate;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (resultDate == null) {
            throw new ParseException("an not convert the value of " + source, 0);
        }
        return resultDate;
    }

    private static String cleanDate(String s) {
        int zoneIndex;
        if ((s = s.trim()).indexOf(84) < 12) {
            s = s.replaceFirst("T", " ");
        }
        if ((zoneIndex = s.indexOf(90)) == s.length() - 1) {
            return s.substring(0, zoneIndex);
        }
        return s;
    }

    private static PatternKey getPatterKey(String source) {
        int colonNumber = 0;
        int blankNumber = 0;
        int hyphenNumber = 0;
        int dotNumber = 0;
        int timeZomeNumber = 0;
        boolean beLastBlank = false;
        int i = 0;
        while (i < source.length()) {
            switch (source.charAt(i)) {
                case ':': {
                    beLastBlank = false;
                    ++colonNumber;
                    break;
                }
                case ' ': {
                    if (!beLastBlank) {
                        ++blankNumber;
                    }
                    beLastBlank = true;
                    break;
                }
                case '-': {
                    beLastBlank = false;
                    if (blankNumber == 0) {
                        ++hyphenNumber;
                        break;
                    }
                    ++timeZomeNumber;
                    break;
                }
                case '.': {
                    beLastBlank = false;
                    ++dotNumber;
                    break;
                }
                case '+': 
                case 'Z': 
                case 'z': {
                    beLastBlank = false;
                    ++timeZomeNumber;
                }
            }
            if (timeZomeNumber > 0) break;
            ++i;
        }
        if (hyphenNumber == 0 && colonNumber == 0 && source.length() > 4) {
            return null;
        }
        return new PatternKey(colonNumber, blankNumber, hyphenNumber, dotNumber, timeZomeNumber);
    }
}

