/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.datatools.enablement.oda.xml.util.SaxParserUtil;

public final class XPathPopulationUtil {
    private static final String XPATH_WILDCARD = "*";
    private static final String XPATH_ATTR_HEADER_WITH_SLASH = "/@";
    private static final String XPATH_ATTR_HEADER_WITH_SQUARE_PATTERN = "\\Q[@\\E";
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.datatools.enablement.oda.xml.util.ui.XPathPopulationUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public static List populateRootPath(String absolutePath) {
        if (!$assertionsDisabled && absolutePath == null) {
            throw new AssertionError();
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(absolutePath);
        if (absolutePath.startsWith("/")) {
            absolutePath = absolutePath.replaceFirst("/", "");
        }
        String[] xPathFrags = absolutePath.split("/");
        int i = 1;
        while (i < xPathFrags.length) {
            String temp = "//";
            temp = XPathPopulationUtil.addXPathFragsToAString(xPathFrags, i, temp);
            result.add(temp);
            ++i;
        }
        return result;
    }

    private static String addXPathFragsToAString(String[] xPathFrags, int i, String s) {
        int j = i;
        while (j < xPathFrags.length) {
            s = j < xPathFrags.length - 1 ? String.valueOf(s) + xPathFrags[j] + "/" : String.valueOf(s) + xPathFrags[j];
            ++j;
        }
        return s;
    }

    public static String populateColumnPath(String rootPath, String columnPath) {
        if (!$assertionsDisabled && rootPath == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && columnPath == null) {
            throw new AssertionError();
        }
        if ((rootPath = SaxParserUtil.processParentAxis(rootPath)).equals("//") || rootPath.equals("//*")) {
            String[] temp = columnPath.split("\\Q/\\E");
            if (temp.length <= 2) {
                return null;
            }
            String result = "";
            int i = 2;
            while (i < temp.length) {
                result = String.valueOf(result) + "/" + temp[i];
                ++i;
            }
            return result;
        }
        if (XPathPopulationUtil.isDescendantOrSelf(columnPath, rootPath)) {
            return columnPath.replaceFirst("\\Q" + rootPath + "\\E", "");
        }
        return XPathPopulationUtil.getXPathExpression(rootPath, columnPath);
    }

    private static boolean isDescendantOrSelf(String candidate, String target) {
        if (!candidate.startsWith(target)) {
            return false;
        }
        String[] candidateFgt = candidate.split("/");
        String[] targetFgt = target.split("/");
        int i = 0;
        while (i < targetFgt.length) {
            if (!targetFgt[i].equals(candidateFgt[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static String getXPathExpression(String rootPath, String columnPath) {
        String[] rootPathFrags = rootPath.replaceAll("\\Q[\\E\\d+\\Q]\\E", "").split("/");
        String[] columnPathFrags = columnPath.replaceAll("\\Q[\\E\\d+\\Q]\\E", "").split("/");
        if (rootPathFrags.length < 2 || columnPathFrags.length < 2) {
            return null;
        }
        int startingIndex = 0;
        int endingIndex = 0;
        if (!rootPath.startsWith("//")) {
            if (!XPathPopulationUtil.is2FragmentsEqual(columnPathFrags[1], rootPathFrags[1])) {
                return null;
            }
            rootPathFrags = ("/" + rootPath).split("/");
        }
        if (!$assertionsDisabled && rootPathFrags.length < 3) {
            throw new AssertionError();
        }
        String commonRoot = rootPathFrags[2];
        startingIndex = XPathPopulationUtil.getStartingIndex(columnPathFrags, commonRoot);
        if (columnPathFrags.length < startingIndex + 1 || startingIndex == 0) {
            return null;
        }
        endingIndex = XPathPopulationUtil.getEndingIndex(rootPathFrags, columnPathFrags, startingIndex);
        return XPathPopulationUtil.populateXpathExpression(columnPath, rootPathFrags, startingIndex, endingIndex);
    }

    private static int getStartingIndex(String[] columnPathFrags, String commonRoot) {
        int startingIndex = 0;
        int i = 1;
        while (i < columnPathFrags.length) {
            if (XPathPopulationUtil.is2FragmentsEqual(commonRoot, columnPathFrags[i])) {
                startingIndex = i;
                break;
            }
            ++i;
        }
        return startingIndex;
    }

    private static boolean is2FragmentsEqual(String frag1, String frag2) {
        if (frag1.equals(XPATH_WILDCARD) || frag2.equals(XPATH_WILDCARD)) {
            return true;
        }
        return frag1.equals(frag2);
    }

    private static int getEndingIndex(String[] rootPathFrags, String[] columnPathFrags, int startingIndex) {
        int start = startingIndex;
        int endingIndex = 0;
        int i = startingIndex + 1;
        while (i < columnPathFrags.length && i - startingIndex + 2 < rootPathFrags.length) {
            if (!XPathPopulationUtil.is2FragmentsEqual(columnPathFrags[i], rootPathFrags[i - startingIndex + 2])) {
                endingIndex = i - 1;
                break;
            }
            start = i++;
        }
        if (endingIndex == 0 && startingIndex != 0) {
            endingIndex = start;
        }
        return endingIndex;
    }

    private static String populateXpathExpression(String columnPath, String[] rootPathFrags, int startingIndex, int endingIndex) {
        String result = "";
        int fetchBackLevel = rootPathFrags.length - 3 - (endingIndex - startingIndex);
        int i = 0;
        while (i < fetchBackLevel) {
            result = String.valueOf(result) + "../";
            ++i;
        }
        return XPathPopulationUtil.addXPathFragsToAString(columnPath.replaceAll(XPATH_ATTR_HEADER_WITH_SQUARE_PATTERN, XPATH_ATTR_HEADER_WITH_SLASH).split("/"), endingIndex + 1, result);
    }
}

