/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.core.internal.ui.util.resources;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.util.ResourceBundle;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.RDBCoreUIPlugin;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.ViewTable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

public class ResourceLoader {
    private static final RDBCoreUIPlugin plugin = RDBCoreUIPlugin.getDefault();
    private static final String RESOURCE_PATH = "org/eclipse/datatools/connectivity/sqm/core/internal/ui/l10n/";
    private static final String ICONS_DIRECTORY = "icons/";
    private static final String UI_RESOURCES = "datatoolsCoreUI";
    private static final String NO_RESOURCE_FOUND = "NO_RESOURCE_FOUND";
    private static final ResourceLoader instance = new ResourceLoader();
    private ResourceBundle bundle = null;
    private static URL iconLocation;

    public static ResourceLoader getResourceLoader() {
        return instance;
    }

    private ResourceLoader() {
        Bundle bundle = RDBCoreUIPlugin.getDefault().getBundle();
        iconLocation = bundle.getEntry("/icons/");
        this.bundle = ResourceBundle.getBundle("org/eclipse/datatools/connectivity/sqm/core/internal/ui/l10n/datatoolsCoreUI");
    }

    private Image queryImage(String imagePath) {
        Image image = null;
        image = plugin.getImageRegistry().get(imagePath);
        if (image == null) {
            image = new Image((Device)Display.getDefault(), imagePath);
            plugin.getImageRegistry().put(imagePath, image);
        }
        return image;
    }

    private Image queryImage(URL imageLocation) {
        Image image = null;
        image = plugin.getImageRegistry().get(imageLocation.toString());
        if (image == null) {
            image = ImageDescriptor.createFromURL((URL)imageLocation).createImage();
            plugin.getImageRegistry().put(imageLocation.toString(), image);
        }
        return image;
    }

    public Image queryImageFromRegistry(String imagePath) {
        try {
            return this.queryImage(new URL(iconLocation, imagePath));
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public Image queryImageFromRegistry(URL imageLocation) {
        return this.queryImage(imageLocation);
    }

    public Image queryAbsolutePathImageFromRegistry(String imagePath) {
        return this.queryImage(imagePath);
    }

    public static byte[] getImageData(EObject eObject) {
        if (eObject instanceof BaseTable) {
            return ResourceLoader.getImageData("table.gif");
        }
        if (eObject instanceof ViewTable) {
            return ResourceLoader.getImageData("view.gif");
        }
        return new byte[100];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static byte[] getImageData(String name) {
        IOException e222;
        byte[] byArray;
        Channel wbc;
        Channel rbc;
        block17: {
            rbc = null;
            wbc = null;
            URL imageURL = new URL(iconLocation, name);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            rbc = Channels.newChannel(imageURL.openStream());
            wbc = Channels.newChannel(baos);
            ByteBuffer buf = ByteBuffer.allocate(128);
            while (rbc.read(buf) > 0) {
                wbc.write(buf);
            }
            byArray = baos.toByteArray();
            Object var8_8 = null;
            if (rbc == null) break block17;
            try {
                rbc.close();
            }
            catch (IOException e222) {
                // empty catch block
            }
        }
        if (wbc != null) {
            try {
                wbc.close();
            }
            catch (IOException e222) {
                // empty catch block
            }
        }
        return byArray;
        catch (Exception e3) {
            IOException e222;
            block19: {
                try {
                    e3.printStackTrace();
                    Object var8_9 = null;
                    if (rbc == null) break block19;
                }
                catch (Throwable throwable) {
                    IOException e222;
                    Object var8_10 = null;
                    if (rbc != null) {
                        try {
                            rbc.close();
                        }
                        catch (IOException e222) {
                            // empty catch block
                        }
                    }
                    if (wbc != null) {
                        try {
                            wbc.close();
                        }
                        catch (IOException e222) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                try {
                    rbc.close();
                }
                catch (IOException e222) {
                    // empty catch block
                }
            }
            if (wbc != null) {
                try {
                    wbc.close();
                }
                catch (IOException e222) {}
            }
        }
        return null;
    }

    public String queryString(String stringID) {
        try {
            String resource = null;
            resource = this.bundle.getString(stringID);
            return resource;
        }
        catch (Throwable e) {
            return stringID;
        }
    }
}

