/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.dse.actions;

import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.datatools.connectivity.ICategory;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.ui.dse.views.ConnectionProfileContentProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.extensions.SafeDelegateTreeContentProvider;
import org.eclipse.ui.navigator.CommonNavigator;

public class ShowCategoryAction
implements IViewActionDelegate {
    IViewPart view = null;
    Object currentInput = ResourcesPlugin.getWorkspace().getRoot();
    boolean currentState = true;

    public void init(IViewPart view) {
        this.view = view;
    }

    public void run(IAction action) {
        boolean check = action.isChecked();
        this.changeShowCategorySetting(check);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(true);
    }

    private void changeShowCategorySetting(boolean flag) {
        if (this.view instanceof CommonNavigator) {
            CommonNavigator commonNav = (CommonNavigator)this.view;
            if (this.currentInput != null && (this.currentInput instanceof ICategory || this.currentInput instanceof ProfileManager || this.currentInput instanceof IWorkspaceRoot || this.currentInput instanceof IConnectionProfile)) {
                NavigatorContentService ncs = (NavigatorContentService)commonNav.getNavigatorContentService();
                ITreeContentProvider[] providers = ncs.findRootContentProviders(this.currentInput);
                if (providers != null && providers.length > 0) {
                    for (int i = 0; i < providers.length; ++i) {
                        ITreeContentProvider ncp = null;
                        if (providers[i] instanceof SafeDelegateTreeContentProvider) {
                            SafeDelegateTreeContentProvider sdtcp = (SafeDelegateTreeContentProvider)providers[i];
                            ncp = sdtcp.getDelegateContentProvider();
                        } else {
                            ncp = providers[i];
                        }
                        if (!(ncp instanceof ConnectionProfileContentProvider)) continue;
                        ConnectionProfileContentProvider provider = (ConnectionProfileContentProvider)ncp;
                        provider.setShowCategories(flag);
                    }
                }
                commonNav.getCommonViewer().refresh();
                if (flag) {
                    commonNav.getCommonViewer().expandToLevel(2);
                }
            }
        }
    }
}

