/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.dse.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.datatools.connectivity.ICategory;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IProfileListener;
import org.eclipse.datatools.connectivity.IPropertySetChangeEvent;
import org.eclipse.datatools.connectivity.IPropertySetListener;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.ui.RefreshProfileJob;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.navigator.CommonViewer;

public class ConnectionProfileContentProvider
implements ITreeContentProvider {
    private boolean mShowCategories = true;
    private Viewer mViewer;
    private Object mInput;
    private IProfileListener mProfileListener = new IProfileListener(){

        public void profileAdded(IConnectionProfile profile) {
            profile.addPropertySetListener(ConnectionProfileContentProvider.this.mPropertyListener);
            ConnectionProfileContentProvider.this.refreshViewer(ConnectionProfileContentProvider.this.mShowCategories ? profile.getCategory() : null, true);
        }

        public void profileDeleted(IConnectionProfile profile) {
            profile.removePropertySetListener(ConnectionProfileContentProvider.this.mPropertyListener);
            ConnectionProfileContentProvider.this.refreshViewer(ConnectionProfileContentProvider.this.mShowCategories ? profile.getCategory() : null, true);
        }

        public void profileChanged(IConnectionProfile profile) {
            ConnectionProfileContentProvider.this.refreshViewer(profile, false);
        }
    };
    private IPropertySetListener mPropertyListener = new IPropertySetListener(){

        public void propertySetChanged(IPropertySetChangeEvent event) {
            ConnectionProfileContentProvider.this.handleProfilePropertyChanged(event);
        }
    };

    public ConnectionProfileContentProvider() {
        ProfileManager.getInstance().addProfileListener(this.mProfileListener);
    }

    public void setShowCategories(boolean showCategories) {
        if (showCategories != this.mShowCategories) {
            this.mShowCategories = showCategories;
            this.refreshViewer(null, false);
        }
    }

    public boolean isShowCategories() {
        return this.mShowCategories;
    }

    protected void refreshViewer(final Object object, boolean expand) {
        if (this.mViewer instanceof TreeViewer && object instanceof IConnectionProfile) {
            RefreshProfileJob.scheduleRefreshProfileJob((IConnectionProfile)((IConnectionProfile)object), (TreeViewer)((TreeViewer)this.mViewer));
        } else {
            Runnable runner = new Runnable(){

                public void run() {
                    ((CommonViewer)ConnectionProfileContentProvider.this.mViewer).refresh(object);
                }
            };
            this.mViewer.getControl().getDisplay().syncExec(runner);
        }
    }

    protected void handleProfilePropertyChanged(IPropertySetChangeEvent event) {
        if (IConnectionProfile.CONNECTION_PROFILE_PROPERTY_SET.equals(event.getPropertySetType()) && event.getChangedProperty("connected") != null) {
            this.refreshViewer(event.getConnectionProfile(), false);
        }
    }

    public Object[] getChildren(Object parentElement) {
        Object[] children = new Object[]{};
        if (parentElement instanceof IWorkspaceRoot) {
            return this.getChildren(ProfileManager.getInstance());
        }
        if (parentElement instanceof ProfileManager) {
            if (this.mShowCategories) {
                ProfileManager pm = (ProfileManager)parentElement;
                ArrayList<Object> kids = new ArrayList<Object>();
                kids.addAll(Arrays.asList(pm.getProfilesByCategory("org.eclipse.datatools.connectivity.connectionProfileRepositoryCategory")));
                kids.addAll(Arrays.asList(pm.getRootCategories()));
                kids.remove(pm.getCategory("org.eclipse.datatools.connectivity.connectionProfileRepositoryCategory"));
                children = kids.toArray();
            } else {
                children = ((ProfileManager)parentElement).getProfiles();
            }
        } else if (parentElement instanceof Object[]) {
            children = (Object[])parentElement;
        } else if (parentElement instanceof ICategory) {
            ICategory icat = (ICategory)parentElement;
            ArrayList arry = new ArrayList();
            if (this.mShowCategories) {
                arry.addAll(icat.getChildCategories());
                arry.addAll(icat.getAssociatedProfiles());
            } else {
                arry.addAll(icat.getAssociatedProfiles());
                this.recurseSubCategoryProfiles(icat, arry);
            }
            children = arry.toArray();
        } else if (parentElement instanceof IConnectionProfile) {
            children = new Object[]{};
        }
        return children;
    }

    private void recurseSubCategoryProfiles(ICategory parent, List arry) {
        Iterator it = parent.getChildCategories().iterator();
        while (it.hasNext()) {
            ICategory sub = (ICategory)it.next();
            arry.addAll(sub.getAssociatedProfiles());
            this.recurseSubCategoryProfiles(sub, arry);
        }
    }

    public Object getParent(Object element) {
        Object parent = null;
        if (element instanceof ICategory) {
            parent = ((ICategory)element).getParent();
            if (parent == null) {
                parent = this.mInput;
            }
            if (parent == null) {
                parent = ProfileManager.getInstance();
            }
        } else if (element instanceof IConnectionProfile) {
            if (this.mShowCategories) {
                parent = ((IConnectionProfile)element).getCategory();
                if (parent == null || "org.eclipse.datatools.connectivity.connectionProfileRepositoryCategory".equals(parent.getId())) {
                    parent = this.mInput;
                }
                if (parent == null) {
                    parent = ProfileManager.getInstance();
                }
            } else {
                parent = this.mInput;
            }
        }
        return parent;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        ProfileManager.getInstance().removeProfileListener(this.mProfileListener);
        Iterator<IConnectionProfile> it = Arrays.asList(ProfileManager.getInstance().getProfiles()).iterator();
        while (it.hasNext()) {
            it.next().removePropertySetListener(this.mPropertyListener);
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.mInput = newInput;
        this.mViewer = viewer;
        if (this.mViewer == null) {
            Iterator<IConnectionProfile> it = Arrays.asList(ProfileManager.getInstance().getProfiles()).iterator();
            while (it.hasNext()) {
                it.next().removePropertySetListener(this.mPropertyListener);
            }
        } else {
            Iterator<IConnectionProfile> it = Arrays.asList(ProfileManager.getInstance().getProfiles()).iterator();
            while (it.hasNext()) {
                it.next().addPropertySetListener(this.mPropertyListener);
            }
        }
    }
}

