/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.core.rte.jdbc;

import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.util.Collection;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionFilterListener;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.DatabaseConnectionRegistry;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCCatalogLoader;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.impl.DatabaseImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class JDBCDatabase
extends DatabaseImpl
implements ICatalogObject {
    private static final long serialVersionUID = 7464150486346999662L;
    private Connection connection;
    private Boolean catalogsLoaded = Boolean.FALSE;
    private transient ConnectionFilterListener filterListener;
    private SoftReference catalogLoaderRef;

    public JDBCDatabase(Connection connection) {
        if (connection == null) {
            System.err.println("null connection");
            throw new RuntimeException();
        }
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Boolean bl = this.catalogsLoaded;
        synchronized (bl) {
            if (this.catalogsLoaded.booleanValue()) {
                this.catalogsLoaded = Boolean.FALSE;
                this.getLoader().clearCatalogs((Collection)super.getCatalogs());
            }
        }
        RefreshManager.getInstance().referesh(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getCatalogs() {
        Boolean bl = this.catalogsLoaded;
        synchronized (bl) {
            if (!this.catalogsLoaded.booleanValue()) {
                this.loadCatalogs();
            }
        }
        return super.getCatalogs();
    }

    protected JDBCCatalogLoader createLoader() {
        return new JDBCCatalogLoader(this);
    }

    protected final JDBCCatalogLoader getLoader() {
        if (this.catalogLoaderRef == null || this.catalogLoaderRef.get() == null) {
            this.catalogLoaderRef = new SoftReference<JDBCCatalogLoader>(this.createLoader());
        }
        return (JDBCCatalogLoader)this.catalogLoaderRef.get();
    }

    private void loadCatalogs() {
        try {
            super.getCatalogs().addAll(this.getLoader().loadCatalogs());
            this.catalogsLoaded = Boolean.TRUE;
            if (this.filterListener == null) {
                ConnectionInfo connectionInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase((Database)this);
                this.filterListener = new FilterListener();
                connectionInfo.addFilterListener(this.filterListener);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Database getCatalogDatabase() {
        return this;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 10) {
            this.getCatalogs();
        }
        return super.eIsSet(eFeature);
    }

    private void handleFilterChanged(String filterKey) {
        if (!this.catalogsLoaded.booleanValue()) {
            return;
        }
        if ("DatatoolsCatalogFilterPredicate".equals(filterKey)) {
            this.refresh();
        }
    }

    private class FilterListener
    implements ConnectionFilterListener {
        private FilterListener() {
        }

        public void connectionFilterAdded(String filterKey) {
            JDBCDatabase.this.handleFilterChanged(filterKey);
        }

        public void connectionFilterRemoved(String filterKey) {
            JDBCDatabase.this.handleFilterChanged(filterKey);
        }
    }
}

