/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.core.rte.jdbc;

import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.util.Collection;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCTableColumnLoader;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCTableIndexLoader;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCTableSuperTableLoader;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.impl.ViewTableImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class JDBCView
extends ViewTableImpl
implements ICatalogObject {
    private Boolean columnsLoaded = Boolean.FALSE;
    private SoftReference columnLoaderRef;
    private Boolean indexesLoaded = Boolean.FALSE;
    private SoftReference indexLoaderRef;
    private Boolean supertableLoaded = Boolean.FALSE;
    private SoftReference supertableLoaderRef;

    public Database getCatalogDatabase() {
        return this.getSchema().getCatalog().getDatabase();
    }

    public Connection getConnection() {
        Database db = this.getCatalogDatabase();
        if (db instanceof ICatalogObject) {
            return ((ICatalogObject)db).getConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Boolean bl = this.columnsLoaded;
        synchronized (bl) {
            if (this.columnsLoaded.booleanValue()) {
                this.columnsLoaded = Boolean.FALSE;
                this.getColumnLoader().clearColumns((List)super.getColumns());
            }
        }
        bl = this.indexesLoaded;
        synchronized (bl) {
            if (this.indexesLoaded.booleanValue()) {
                this.indexesLoaded = Boolean.FALSE;
                this.getIndexLoader().clearIndexes((List)super.getIndex());
            }
        }
        bl = this.supertableLoaded;
        synchronized (bl) {
            if (this.supertableLoaded.booleanValue()) {
                this.supertableLoaded = Boolean.FALSE;
                this.setSupertable(null);
            }
        }
        RefreshManager.getInstance().referesh(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getColumns() {
        Boolean bl = this.columnsLoaded;
        synchronized (bl) {
            if (!this.columnsLoaded.booleanValue()) {
                this.loadColumns();
            }
        }
        return super.getColumns();
    }

    protected JDBCTableColumnLoader createColumnLoader() {
        return new JDBCTableColumnLoader(this);
    }

    protected final JDBCTableColumnLoader getColumnLoader() {
        if (this.columnLoaderRef == null || this.columnLoaderRef.get() == null) {
            this.columnLoaderRef = new SoftReference<JDBCTableColumnLoader>(this.createColumnLoader());
        }
        return (JDBCTableColumnLoader)this.columnLoaderRef.get();
    }

    private void loadColumns() {
        try {
            super.getColumns().addAll((Collection)this.getColumnLoader().loadColumns());
            this.columnsLoaded = Boolean.TRUE;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getIndex() {
        Boolean bl = this.indexesLoaded;
        synchronized (bl) {
            if (!this.indexesLoaded.booleanValue()) {
                this.loadIndexes();
            }
        }
        return super.getIndex();
    }

    protected JDBCTableIndexLoader createIndexLoader() {
        return new JDBCTableIndexLoader(this);
    }

    protected final JDBCTableIndexLoader getIndexLoader() {
        if (this.indexLoaderRef == null || this.indexLoaderRef.get() == null) {
            this.indexLoaderRef = new SoftReference<JDBCTableIndexLoader>(this.createIndexLoader());
        }
        return (JDBCTableIndexLoader)this.indexLoaderRef.get();
    }

    private void loadIndexes() {
        try {
            super.getIndex().addAll((Collection)this.getIndexLoader().loadIndexes());
            this.indexesLoaded = Boolean.TRUE;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table getSupertable() {
        Boolean bl = this.supertableLoaded;
        synchronized (bl) {
            if (!this.supertableLoaded.booleanValue()) {
                this.loadSupertable();
            }
        }
        return super.getSupertable();
    }

    protected JDBCTableSuperTableLoader createSupertableLoader() {
        return new JDBCTableSuperTableLoader(this);
    }

    protected final JDBCTableSuperTableLoader getSupertableLoader() {
        if (this.supertableLoaderRef == null || this.supertableLoaderRef.get() == null) {
            this.supertableLoaderRef = new SoftReference<JDBCTableSuperTableLoader>(this.createSupertableLoader());
        }
        return (JDBCTableSuperTableLoader)this.supertableLoaderRef.get();
    }

    private void loadSupertable() {
        try {
            this.setSupertable(this.getSupertableLoader().loadSuperTable());
            this.supertableLoaded = Boolean.TRUE;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 6: {
                this.getColumns();
                break;
            }
            case 12: {
                this.getIndex();
                break;
            }
            case 7: {
                this.getSupertable();
            }
        }
        return super.eIsSet(eFeature);
    }
}

