/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionFactory;
import org.eclipse.datatools.connectivity.IConnectionFactoryProvider;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IConnectionProfileProvider;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileManager;
import org.eclipse.datatools.connectivity.internal.ConnectivityPlugin;

public class ConnectionFactoryProvider
implements IConnectionFactoryProvider {
    public static final String ATTR_ID = "id";
    public static final String ATTR_PROFILE = "profile";
    public static final String ATTR_CLASS = "class";
    public static final String ATTR_NAME = "name";
    private String mId;
    private String mName;
    private String mProfile;
    private String mClassAttr;
    private IConnectionFactory mFactory;
    private IConfigurationElement mElement;

    public ConnectionFactoryProvider(IConfigurationElement element) {
        this.init(element);
    }

    public ConnectionFactoryProvider(IConfigurationElement element, String factoryID, String profileID, String classAttr) {
        this.mElement = element;
        this.mId = factoryID;
        this.mProfile = profileID;
        this.mClassAttr = classAttr;
    }

    public IConnection createConnection(IConnectionProfile profile) {
        return this.createConnection(profile, null, null);
    }

    public IConnection createConnection(IConnectionProfile profile, String uid, String pwd) {
        this.initFactory();
        if (this.mFactory != null) {
            if (uid != null) {
                return this.mFactory.createConnection(profile, uid, pwd);
            }
            return this.mFactory.createConnection(profile);
        }
        return null;
    }

    public IConnectionProfileProvider getConnectionProfileProvider() {
        return ConnectionProfileManager.getInstance().getProvider(this.mProfile);
    }

    public String getId() {
        return this.mId;
    }

    public String getName() {
        return this.mName;
    }

    private void init(IConfigurationElement element) {
        Assert.isTrue((boolean)"connectionFactory".equals(element.getName()));
        this.mElement = element;
        this.mId = element.getAttribute(ATTR_ID);
        this.mName = element.getAttribute(ATTR_NAME);
        this.mProfile = element.getAttribute(ATTR_PROFILE);
        this.mClassAttr = ATTR_CLASS;
    }

    public Class getConnectionFactoryClass() {
        this.initFactory();
        return this.mFactory.getClass();
    }

    private void initFactory() {
        if (this.mFactory != null) {
            return;
        }
        final IConnectionFactory[] result = new IConnectionFactory[1];
        ISafeRunnable code = new ISafeRunnable(){

            public void run() throws Exception {
                result[0] = (IConnectionFactory)ConnectionFactoryProvider.this.mElement.createExecutableExtension(ConnectionFactoryProvider.this.mClassAttr);
            }

            public void handleException(Throwable exception) {
                ConnectivityPlugin.getDefault().log(exception);
            }
        };
        SafeRunner.run((ISafeRunnable)code);
        this.mFactory = result[0];
    }
}

