/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.profile.ISQLToolsProfileListener;
import org.eclipse.datatools.sqltools.core.profile.SQLToolsProfileListenersManager;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLToolsConnectListener;
import org.eclipse.datatools.sqltools.editor.core.connection.SQLToolsConnectListenersManager;
import org.eclipse.datatools.sqltools.editor.template.GenericSQLContextType;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorContributorExtensionRegistry;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorResources;
import org.eclipse.datatools.sqltools.sqleditor.internal.profile.SQLEditorProfileListener;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.SQLCodeScanner;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.SQLPartitionScanner;
import org.eclipse.datatools.sqltools.sqleditor.internal.utils.SQLColorProvider;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class SQLEditorPlugin
extends AbstractUIPlugin {
    private static final int INTERNAL_ERROR = 0;
    public static final String PLUGIN_ID = "org.eclipse.datatools.sqltools.sqleditor";
    private static SQLEditorPlugin fgInstance;
    private SQLPartitionScanner fPartitionScanner;
    private SQLColorProvider fColorProvider;
    private SQLCodeScanner fCodeScanner;
    private TemplateStore _store;
    private ContributionContextTypeRegistry _registry;
    private Properties _properties;
    private URL _pluginBase;
    private static final String PROPERTIES = "default.properties";
    private static final String CUSTOM_TEMPLATES_KEY = "com.sybase.stf.dmp.ui.sqleditor.template.customtemplates";
    private SQLEditorProfileListener _sqlEditorProfileListener = null;

    public SQLEditorPlugin() {
        fgInstance = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.init();
        this._sqlEditorProfileListener = new SQLEditorProfileListener();
        SQLToolsProfileListenersManager pManager = SQLToolsProfileListenersManager.getInstance();
        pManager.addProfileListener((ISQLToolsProfileListener)this._sqlEditorProfileListener);
        SQLToolsConnectListenersManager cManager = SQLToolsConnectListenersManager.getInstance();
        cManager.addConnectListener((ISQLToolsConnectListener)this._sqlEditorProfileListener);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        SQLToolsProfileListenersManager pManager = SQLToolsProfileListenersManager.getInstance();
        pManager.removeProfileListener((ISQLToolsProfileListener)this._sqlEditorProfileListener);
        SQLToolsConnectListenersManager cManager = SQLToolsConnectListenersManager.getInstance();
        cManager.removeConnectListener((ISQLToolsConnectListener)this._sqlEditorProfileListener);
    }

    public static SQLEditorPlugin getDefault() {
        return fgInstance;
    }

    public SQLPartitionScanner getSQLPartitionScanner() {
        if (this.fPartitionScanner == null) {
            this.fPartitionScanner = new SQLPartitionScanner();
        }
        return this.fPartitionScanner;
    }

    public RuleBasedScanner getSQLCodeScanner() {
        if (this.fCodeScanner == null) {
            this.fCodeScanner = new SQLCodeScanner(this.getSQLColorProvider());
        }
        return this.fCodeScanner;
    }

    public SQLColorProvider getSQLColorProvider() {
        if (this.fColorProvider == null) {
            this.fColorProvider = new SQLColorProvider();
        }
        return this.fColorProvider;
    }

    public void log(IStatus status) {
        this.getLog().log(status);
    }

    public void log(String message) {
        this.log(this.createErrorStatus(message));
    }

    public void log(String message, Throwable e) {
        this.log(this.createErrorStatus(message, e));
    }

    public void log(Throwable e) {
        this.log(this.createErrorStatus(e));
    }

    public IStatus createErrorStatus(String message) {
        return new Status(4, this.getBundle().getSymbolicName(), 0, message, null);
    }

    public IStatus createErrorStatus(Throwable e) {
        return new Status(4, this.getBundle().getSymbolicName(), 0, SQLEditorResources.plugin_internal_error, e);
    }

    public IStatus createErrorStatus(String message, Throwable e) {
        return new Status(4, this.getBundle().getSymbolicName(), 0, message, e);
    }

    public TemplateStore getTemplateStore() {
        if (this._store == null) {
            this._store = new ContributionTemplateStore(this.getTemplateContextTypeRegistry(), SQLEditorPlugin.getDefault().getPreferenceStore(), CUSTOM_TEMPLATES_KEY);
            try {
                this._store.load();
            }
            catch (IOException e) {
                SQLEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.sybase.stf.dmp.debugger", 0, "", (Throwable)e));
            }
        }
        return this._store;
    }

    public ContextTypeRegistry getTemplateContextTypeRegistry() {
        if (this._registry == null) {
            this._registry = new ContributionContextTypeRegistry();
            this._registry.addContextType("org.eclipse.datatools.sqltools.editor.template.sql.generic");
            Collection c = SQLToolsFacade.getConfigurations();
            ArrayList<GenericSQLContextType> ctxTypes = new ArrayList<GenericSQLContextType>();
            Iterator iter = c.iterator();
            while (iter.hasNext()) {
                SQLDevToolsConfiguration config = (SQLDevToolsConfiguration)iter.next();
                ctxTypes.add(config.getSQLService().getSQLContextType());
            }
            Iterator i = ctxTypes.iterator();
            while (i.hasNext()) {
                this._registry.addContextType(((GenericSQLContextType)i.next()).getSQLContextId());
            }
        }
        return this._registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void init() {
        block13: {
            InputStream input;
            block12: {
                this._properties = new Properties();
                input = null;
                this._pluginBase = this.getBundle().getEntry("/");
                input = new URL(this._pluginBase, PROPERTIES).openStream();
                if (input != null) {
                    this._properties.load(input);
                    break block12;
                }
                this.log("Input is null");
            }
            Object var4_2 = null;
            try {
                if (input != null) {
                    input.close();
                }
                break block13;
            }
            catch (IOException ee2) {
                this.log(ee2);
            }
            break block13;
            {
                catch (IOException ee) {
                    this.log(ee);
                    Object var4_3 = null;
                    try {
                        if (input != null) {
                            input.close();
                        }
                        break block13;
                    }
                    catch (IOException ee2) {
                        this.log(ee2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException ee2) {
                    this.log(ee2);
                }
                throw throwable;
            }
        }
    }

    public Properties getProperties() {
        return this._properties;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static IWorkbenchPage getActiveWorkbenchPage() {
        IWorkbenchPage workbenchPage = SQLEditorPlugin.getActiveWorkbenchWindow().getActivePage();
        if (workbenchPage != null) {
            return workbenchPage;
        }
        IWorkbenchPage[] workbenchPages = SQLEditorPlugin.getActiveWorkbenchWindow().getPages();
        if (workbenchPages.length > 0) {
            return workbenchPages[0];
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbenchWindow window = SQLEditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            return window;
        }
        IWorkbenchWindow[] windows = SQLEditorPlugin.getDefault().getWorkbench().getWorkbenchWindows();
        if (windows.length > 0) {
            return windows[0];
        }
        return null;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = SQLEditorPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        IWorkbenchWindow[] windows = SQLEditorPlugin.getDefault().getWorkbench().getWorkbenchWindows();
        if (windows.length > 0) {
            return windows[0].getShell();
        }
        return null;
    }

    public static Display getDisplay() {
        Shell shell = SQLEditorPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            return shell.getDisplay();
        }
        return Display.getDefault();
    }

    public static IEditorPart getActiveEditor() {
        return SQLEditorPlugin.getActiveWorkbenchWindow().getActivePage().getActiveEditor();
    }

    public static Collection getSQLEditorActionContributorExtension() {
        return SQLEditorContributorExtensionRegistry.getInstance().getExtensions();
    }
}

