/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.sql;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.datatools.sqltools.sql.ISQLSyntax;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.ISQLPartitions;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.NestedMultiLineRule;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;

public class SQLPartitionScanner
extends RuleBasedPartitionScanner
implements ISQLPartitions {
    public static final String SQL_SELECT = "__sql_select_statement__";
    public static final String SQL_INSERT = "__sql_insert_statement__";
    public static final String SQL_UPDATE = "__sql_update_statement__";
    public static final String SQL_DELETE = "__sql_delete_statement__";
    public static final String SQL_MERGE = "__sql_merge_statement__";
    public static final String SQL_CREATE = "__sql_create_statement__";
    public static final String SQL_DROP = "__sql_drop_statement__";
    public static final String SQL_ALTER = "__sql_alter_statement__";
    public static final String SQL_GRANT = "__sql_grant_statement__";
    public static final String SQL_REVOKE = "__sql_revoke_statement__";
    public static final String SQL_COMMIT = "__sql_commit_statement__";
    public static final String SQL_ROLLBACK = "__sql_rollback_statement__";
    public static final String SQL_SET = "__sql_set_statement__";
    public static final String SQL_CONNECT = "__sql_connect_statement__";
    public static final String SQL_DISCONNECT = "__sql_disconnect_statement__";
    public static final String SQL_COMMENT_ON = "__sql_comment_on_statement__";
    public static final String SQL_TERMINATE = "__sql_terminate_statement__";
    public static final String SQL_CATALOG = "__sql_catalog_statement__";
    public static final String SQL_UNCATALOG = "__sql_uncatalog_statement__";
    public static final String SQL_SIGNAL = "__sql_signal_statement__";
    public static final String SQL_UNKNOWNSQL = "__sql__unknownsql_statement__";
    public static final String[] SQL_PARTITION_TYPES = new String[]{"__dftl_partition_content_type", "sql_code", "sql_comment", "sql_multiline_comment", "sql_character", "sql_double_quotes_identifier"};
    List _rules = new ArrayList();
    IToken _sqlCode = new Token((Object)"sql_code");
    IToken _comment = new Token((Object)"sql_comment");
    IToken _multilineComment = new Token((Object)"sql_multiline_comment");
    IToken _sqlDoubleQuotesIdentifier = new Token((Object)"sql_double_quotes_identifier");
    IToken _sqlString = new Token((Object)"sql_character");

    public SQLPartitionScanner() {
        this.initRules();
        this.setupRules();
    }

    private void setupRules() {
        IPredicateRule[] result = new IPredicateRule[this._rules.size()];
        this._rules.toArray(result);
        this.setPredicateRules(result);
    }

    private void initRules() {
        this._rules.add(new SingleLineRule("\"", "\"", this._sqlDoubleQuotesIdentifier, '\\'));
        this._rules.add(new MultiLineRule("'", "'", this._sqlString, '\\', true));
        this._rules.add(new EndOfLineRule("--", this._comment));
        EmptyCommentRule wordRule = new EmptyCommentRule(this._multilineComment);
        this._rules.add(wordRule);
        this._rules.add(new NestedMultiLineRule("/*", "*/", this._multilineComment, '\u0000', true));
    }

    public SQLPartitionScanner(ISQLSyntax sqlSyntax) {
        this.initRules();
        this.setCommentsScanner(sqlSyntax);
        this.setupRules();
    }

    private void setCommentsScanner(ISQLSyntax sqlSyntax) {
        String[] singleLineComments = sqlSyntax.getSingleLineComments();
        for (int i = 0; i < singleLineComments.length; ++i) {
            this._rules.add(new EndOfLineRule(singleLineComments[i], this._comment));
        }
    }

    public String getScannedPartitionString() {
        try {
            String scanned = this.fDocument.get(this.fPartitionOffset, this.fOffset - this.fPartitionOffset);
            return scanned;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static ITypedRegion[] getDocumentRegions(IDocument doc) {
        ITypedRegion[] regions = null;
        try {
            regions = TextUtilities.computePartitioning((IDocument)doc, (String)"___sql_partitioning", (int)0, (int)doc.getLength(), (boolean)false);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return regions;
    }

    static class EmptyCommentRule
    extends WordRule
    implements IPredicateRule {
        private IToken _fSuccessToken;

        public EmptyCommentRule(IToken successToken) {
            super((IWordDetector)new EmptyCommentDetector());
            this._fSuccessToken = successToken;
            this.addWord("/**/", this._fSuccessToken);
        }

        public IToken evaluate(ICharacterScanner scanner, boolean resume) {
            return this.evaluate(scanner);
        }

        public IToken getSuccessToken() {
            return this._fSuccessToken;
        }
    }

    static class EmptyCommentDetector
    implements IWordDetector {
        EmptyCommentDetector() {
        }

        public boolean isWordStart(char c) {
            return c == '/';
        }

        public boolean isWordPart(char c) {
            return c == '*' || c == '/';
        }
    }
}

