/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.IProfileListener;
import org.eclipse.datatools.connectivity.IPropertySetChangeEvent;
import org.eclipse.datatools.connectivity.IPropertySetListener;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.repository.IConnectionProfileRepository;
import org.eclipse.datatools.connectivity.ui.RefreshProfileJob;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.navigator.CommonViewer;

public class CPRepositoryContentProvider
implements ITreeContentProvider {
    private Viewer mViewer;
    private Set mRepositories = new HashSet();
    private IProfileListener mProfileListener = new IProfileListener(){

        public void profileAdded(IConnectionProfile profile) {
            if (this.isChildProfile(profile)) {
                profile.addPropertySetListener(CPRepositoryContentProvider.this.mPropertyListener);
                CPRepositoryContentProvider.this.refreshViewer(profile.getCategory(), true);
            }
        }

        public void profileDeleted(IConnectionProfile profile) {
            if (this.isChildProfile(profile)) {
                profile.removePropertySetListener(CPRepositoryContentProvider.this.mPropertyListener);
                CPRepositoryContentProvider.this.refreshViewer(profile.getCategory(), true);
            }
        }

        public void profileChanged(IConnectionProfile profile) {
            if (this.isChildProfile(profile)) {
                CPRepositoryContentProvider.this.refreshViewer(profile, false);
            }
        }

        private boolean isChildProfile(IConnectionProfile profile) {
            if (profile.getParentProfile() == null || !profile.isConnected()) {
                return false;
            }
            IManagedConnection imc = profile.getManagedConnection((class$org$eclipse$datatools$connectivity$internal$repository$IConnectionProfileRepository == null ? (class$org$eclipse$datatools$connectivity$internal$repository$IConnectionProfileRepository = CPRepositoryContentProvider.class$("org.eclipse.datatools.connectivity.internal.repository.IConnectionProfileRepository")) : class$org$eclipse$datatools$connectivity$internal$repository$IConnectionProfileRepository).getName());
            return imc != null && CPRepositoryContentProvider.this.mRepositories.contains(imc.getConnection());
        }
    };
    private IPropertySetListener mPropertyListener = new IPropertySetListener(){

        public void propertySetChanged(IPropertySetChangeEvent event) {
            CPRepositoryContentProvider.this.handleProfilePropertyChanged(event);
        }
    };
    static /* synthetic */ Class class$org$eclipse$datatools$connectivity$internal$repository$IConnectionProfileRepository;

    public CPRepositoryContentProvider() {
        ProfileManager.getInstance().addProfileListener(this.mProfileListener);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IConnectionProfileRepository) {
            if (!this.mRepositories.contains(parentElement)) {
                Iterator<IConnectionProfile> it = Arrays.asList(((IConnectionProfileRepository)parentElement).getProfiles()).iterator();
                while (it.hasNext()) {
                    it.next().addPropertySetListener(this.mPropertyListener);
                }
                this.mRepositories.add(parentElement);
            }
            return ((IConnectionProfileRepository)parentElement).getProfiles();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof IConnectionProfileRepository) {
            return ((IConnectionProfileRepository)element).getRepositoryProfile();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        ProfileManager.getInstance().removeProfileListener(this.mProfileListener);
        Iterator repIt = this.mRepositories.iterator();
        while (repIt.hasNext()) {
            Iterator<IConnectionProfile> it = Arrays.asList(((IConnectionProfileRepository)repIt.next()).getProfiles()).iterator();
            while (it.hasNext()) {
                it.next().removePropertySetListener(this.mPropertyListener);
            }
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.mViewer = viewer;
    }

    protected void refreshViewer(Object object, boolean expand) {
        if (this.mViewer instanceof TreeViewer && object instanceof IConnectionProfile) {
            RefreshProfileJob.scheduleRefreshProfileJob((IConnectionProfile)object, (TreeViewer)this.mViewer);
        } else {
            Runnable runner = new Runnable(){

                public void run() {
                    ((CommonViewer)CPRepositoryContentProvider.this.mViewer).refresh();
                }
            };
            this.mViewer.getControl().getDisplay().syncExec(runner);
        }
    }

    protected void handleProfilePropertyChanged(IPropertySetChangeEvent event) {
        if (IConnectionProfile.CONNECTION_PROFILE_PROPERTY_SET.equals(event.getPropertySetType()) && event.getChangedProperty("connected") != null) {
            this.refreshViewer(event.getConnectionProfile(), false);
        }
    }
}

