/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.connectivity.internal.ui.ConnectionProfileManagerUI;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.IHelpConstants;
import org.eclipse.datatools.connectivity.internal.ui.wizards.CPCategoryWizardNode;
import org.eclipse.datatools.connectivity.internal.ui.wizards.CPWizardNode;
import org.eclipse.datatools.connectivity.internal.ui.wizards.NewCPWizard;
import org.eclipse.datatools.connectivity.internal.ui.wizards.NewCategoryWizard;
import org.eclipse.datatools.connectivity.internal.ui.wizards.ProfileWizardProvider;
import org.eclipse.datatools.connectivity.internal.ui.wizards.WizardSelectionPage;
import org.eclipse.datatools.connectivity.ui.wizards.ICPWizard;
import org.eclipse.datatools.connectivity.ui.wizards.IProfileWizardProvider;
import org.eclipse.datatools.connectivity.ui.wizards.IWizardCategoryProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;

public class CPWizardSelectionPage
extends WizardSelectionPage {
    private String category = "";
    private TableViewer tableViewer;
    private ViewerFilter viewerFilter = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return true;
        }
    };

    public List getCatagoryItems(String wizardCategory) {
        IProfileWizardProvider wizardProvider;
        Iterator itr;
        ConnectionProfileManagerUI manager = ConnectionProfileManagerUI.getInstance();
        Collection wizards = manager.getNewWizards().values();
        Collection wizardCats = manager.getWizardCategories().values();
        ArrayList<CPWizardNode> wizardNodes = new ArrayList<CPWizardNode>();
        if (wizards != null) {
            itr = wizards.iterator();
            while (itr.hasNext()) {
                wizardProvider = (IProfileWizardProvider)itr.next();
                if (!wizardProvider.getCategory().equals(wizardCategory)) continue;
                wizardNodes.add(new CPWizardNode(wizardProvider));
            }
        }
        if (wizardCats != null) {
            itr = wizardCats.iterator();
            while (itr.hasNext()) {
                wizardProvider = (IProfileWizardProvider)itr.next();
                if (!wizardProvider.getCategory().equals(wizardCategory)) continue;
                wizardNodes.add(new CPCategoryWizardNode(wizardProvider));
            }
        }
        return wizardNodes;
    }

    protected CPWizardSelectionPage(String id) {
        super(id);
        this.setTitle(ConnectivityUIPlugin.getDefault().getResourceString("CPWizardSelectionPage.title"));
        this.setDescription(ConnectivityUIPlugin.getDefault().getResourceString("CPWizardSelectionPage.desc"));
    }

    protected CPWizardSelectionPage(String id, ViewerFilter filter) {
        this(id);
        if (filter != null) {
            this.viewerFilter = filter;
        }
    }

    protected CPWizardSelectionPage(String id, ViewerFilter filter, String cat) {
        this(id, filter);
        this.category = cat;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        this.setControl((Control)container);
        Group group = new Group(container, 0);
        group.setLayout((Layout)new GridLayout());
        group.setText(ConnectivityUIPlugin.getDefault().getResourceString("CPWizardSelectionPage.group"));
        group.setLayoutData((Object)new GridData(1808));
        this.tableViewer = new TableViewer((Composite)group, 67584);
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                IStructuredSelection iss = (IStructuredSelection)CPWizardSelectionPage.this.tableViewer.getSelection();
                if (iss != null && !iss.isEmpty()) {
                    CPWizardNode node = (CPWizardNode)iss.getFirstElement();
                    CPWizardSelectionPage.this.setSelectedNode(node);
                    CPWizardSelectionPage.this.getWizard().getContainer().showPage(CPWizardSelectionPage.this.getNextPage());
                }
            }
        });
        this.tableViewer.setSorter((ViewerSorter)new Sorter());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        Table table = this.tableViewer.getTable();
        table.setLayoutData((Object)new GridData(1808));
        TableLayout tl = new TableLayout();
        tl.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setWidth(400);
        this.tableViewer.setInput((Object)this.category);
        this.tableViewer.addFilter(this.viewerFilter);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection iss = (IStructuredSelection)event.getSelection();
                if (iss != null && !iss.isEmpty()) {
                    CPWizardNode node = (CPWizardNode)iss.getFirstElement();
                    CPWizardSelectionPage.this.setDescription(node.getProvider().getDescription());
                    CPWizardSelectionPage.this.setSelectedNode(node);
                }
            }
        });
        this.setPageComplete(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, IHelpConstants.CONTEXT_ID_CP_WIZARD_PAGE);
    }

    public void onSetActive() {
        if (this.tableViewer == null) {
            return;
        }
        Object obj = this.tableViewer.getElementAt(0);
        if (obj != null) {
            this.tableViewer.setSelection((ISelection)new StructuredSelection(obj));
        }
    }

    protected void initWizard(IWizard wizard) {
        IProfileWizardProvider wizardProvider = ((CPWizardNode)this.getSelectedNode()).getProvider();
        this.initWizard(wizard, wizardProvider);
    }

    private void initWizard(IWizard wizard, IProfileWizardProvider wizardProvider) {
        if (wizard instanceof ICPWizard) {
            ((ICPWizard)wizard).initProviderID(((ProfileWizardProvider)wizardProvider).getProfile());
            ((ICPWizard)wizard).setParentProfile(((NewCPWizard)this.getWizard()).getParentProfile());
        } else if (wizard instanceof NewCategoryWizard) {
            NewCategoryWizard catWizard = (NewCategoryWizard)wizard;
            catWizard.initWizardCategory((IWizardCategoryProvider)wizardProvider);
            catWizard.setWindowTitle(this.getWizard().getWindowTitle());
        }
    }

    public IWizardPage getNextPage() {
        List categoryItems;
        IWizardNode selectedNode = this.getSelectedNode();
        if (selectedNode == null) {
            return null;
        }
        IProfileWizardProvider wizardProvider = ((CPWizardNode)this.getSelectedNode()).getProvider();
        boolean isCreated = selectedNode.isContentCreated();
        IWizard wizard = selectedNode.getWizard();
        if (wizard == null) {
            this.setSelectedNode(null);
            return null;
        }
        if (wizard instanceof NewCategoryWizard && (categoryItems = this.getCatagoryItems(wizardProvider.getId())).size() == 1) {
            IWizardNode wizardNode = (IWizardNode)categoryItems.get(0);
            isCreated = wizardNode.isContentCreated();
            wizard = wizardNode.getWizard();
            wizardProvider = ((CPWizardNode)wizardNode).getProvider();
        }
        if (!isCreated) {
            this.initWizard(wizard, wizardProvider);
            wizard.addPages();
        }
        return wizard.getStartingPage();
    }

    class TableContentProvider
    implements IStructuredContentProvider {
        private String wizardCategory;

        TableContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.wizardCategory = (String)newInput;
        }

        public Object[] getElements(Object inputElement) {
            List wizardNodes = CPWizardSelectionPage.this.getCatagoryItems(this.wizardCategory);
            return wizardNodes.toArray(new CPWizardNode[wizardNodes.size()]);
        }
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            return ((CPWizardNode)element).getProvider().getName();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return ((CPWizardNode)element).getProvider().getCachedIcon();
        }
    }

    class Sorter
    extends ViewerSorter {
        Sorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            CPWizardNode item1 = (CPWizardNode)e1;
            CPWizardNode item2 = (CPWizardNode)e2;
            return item1.getProvider().getName().compareTo(item2.getProvider().getName());
        }
    }
}

