/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.actions;

import org.eclipse.datatools.connectivity.ICategory;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IProfileListener;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileManager;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.wizards.CPWizardNode;
import org.eclipse.datatools.connectivity.internal.ui.wizards.NewCPWizard;
import org.eclipse.datatools.connectivity.internal.ui.wizards.ProfileWizardProvider;
import org.eclipse.datatools.connectivity.ui.wizards.IWizardCategoryProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class AddProfileViewAction
extends Action
implements IViewActionDelegate {
    private ICategory category;
    private IConnectionProfile parentProfile;
    private int returnCode;
    private IConnectionProfile addedProfile;

    public AddProfileViewAction() {
        this.setText(ConnectivityUIPlugin.getDefault().getResourceString("ServersView.action.newCP"));
    }

    public AddProfileViewAction(ICategory category) {
        this();
        this.category = category;
    }

    public AddProfileViewAction(String categoryID) {
        this();
        this.category = ConnectionProfileManager.getInstance().getCategory(categoryID);
    }

    public void init(IViewPart viewpart) {
    }

    public void run() {
        ViewerFilter viewerFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (AddProfileViewAction.this.category == null) {
                    return true;
                }
                CPWizardNode wizardNode = (CPWizardNode)element;
                if (!(wizardNode.getProvider() instanceof IWizardCategoryProvider)) {
                    for (ICategory cat = ConnectionProfileManager.getInstance().getProvider(((ProfileWizardProvider)wizardNode.getProvider()).getProfile()).getCategory(); cat != null; cat = cat.getParent()) {
                        if (!cat.getId().equals(AddProfileViewAction.this.category.getId())) continue;
                        return true;
                    }
                } else if (((IWizardCategoryProvider)wizardNode.getProvider()).getId().equals(AddProfileViewAction.this.category.getId())) {
                    return true;
                }
                return false;
            }
        };
        NewCPWizard wizard = new NewCPWizard(viewerFilter, this.parentProfile);
        WizardDialog wizardDialog = new WizardDialog(ConnectivityUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        wizardDialog.setBlockOnOpen(true);
        InternalProfileListener listener = new InternalProfileListener();
        ProfileManager.getInstance().addProfileListener((IProfileListener)listener);
        this.returnCode = wizardDialog.open();
        this.addedProfile = listener.cachedProfile;
        ProfileManager.getInstance().removeProfileListener((IProfileListener)listener);
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void setCategory(ICategory category) {
        this.category = category;
    }

    public void setCategory(String categoryID) {
        this.category = ConnectionProfileManager.getInstance().getCategory(categoryID);
    }

    public ICategory getCategory() {
        return this.category;
    }

    public void setParentProfile(IConnectionProfile profile) {
        this.parentProfile = profile;
    }

    public IConnectionProfile getParentProfile() {
        return this.parentProfile;
    }

    public int getWizardReturnCode() {
        return this.returnCode;
    }

    public IConnectionProfile getAddedProfile() {
        return this.addedProfile;
    }

    private class InternalProfileListener
    implements IProfileListener {
        protected IConnectionProfile cachedProfile;

        private InternalProfileListener() {
        }

        public void profileAdded(IConnectionProfile profile) {
            this.cachedProfile = profile;
        }

        public void profileChanged(IConnectionProfile profile) {
        }

        public void profileDeleted(IConnectionProfile profile) {
        }
    }
}

