/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.actions;

import java.util.Iterator;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.ExceptionHandler;
import org.eclipse.datatools.connectivity.internal.ui.refactoring.ConnectionProfileDeleteProcessor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.core.refactoring.PerformRefactoringOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.DeleteProcessor;
import org.eclipse.ltk.core.refactoring.participants.DeleteRefactoring;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;

public class DeleteAction
extends Action
implements IActionDelegate {
    private Shell mParentShell = null;
    private Iterator mIterator = null;

    public DeleteAction() {
        Display display = Display.getCurrent();
        this.mParentShell = display.getActiveShell();
    }

    public void run() {
        while (this.mIterator != null && this.mIterator.hasNext()) {
            Object object = this.mIterator.next();
            if (!(object instanceof IConnectionProfile)) continue;
            IConnectionProfile profile = (IConnectionProfile)object;
            boolean ret = MessageDialog.openQuestion((Shell)this.mParentShell, (String)ConnectivityUIPlugin.getDefault().getResourceString("actions.delete.title"), (String)ConnectivityUIPlugin.getDefault().getResourceString("actions.delete.confirm", new String[]{profile.getName()}));
            if (!ret) {
                return;
            }
            try {
                this.refactor(profile);
            }
            catch (CoreException e) {
                ExceptionHandler.showException(this.mParentShell, ConnectivityUIPlugin.getDefault().getResourceString("dialog.title.error"), e.getMessage(), e);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.mIterator = null;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            action.setEnabled(structuredSelection.size() > 0);
            if (structuredSelection.size() > 0) {
                this.mIterator = structuredSelection.iterator();
            }
        }
    }

    public void run(IAction action) {
        this.run();
    }

    private void refactor(IConnectionProfile profile) throws CoreException {
        PerformRefactoringOperation refOperation = new PerformRefactoringOperation((Refactoring)new DeleteRefactoring((DeleteProcessor)new ConnectionProfileDeleteProcessor(profile)), 6);
        try {
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)refOperation, null);
        }
        catch (OperationCanceledException oce) {
            throw new OperationCanceledException();
        }
        catch (CoreException ce) {
            throw ce;
        }
    }
}

