/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.actions;

import org.eclipse.datatools.connectivity.ConnectionProfileException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.ExceptionHandler;
import org.eclipse.datatools.connectivity.internal.ui.wizards.ImportProfilesDialog;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.navigator.CommonNavigator;

public class ImportProfileViewAction
extends Action
implements IViewActionDelegate {
    private Shell shell;
    private CommonNavigator commonNav;

    public ImportProfileViewAction() {
        this.setText(ConnectivityUIPlugin.getDefault().getResourceString("ServersView.action.importCPs"));
    }

    public void init(IViewPart view) {
        if (view instanceof CommonNavigator) {
            this.commonNav = (CommonNavigator)view;
        }
        this.shell = view.getSite().getShell();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        ImportProfilesDialog dlg = new ImportProfilesDialog(this.shell);
        int ret = dlg.open();
        if (ret != 0) {
            return;
        }
        IConnectionProfile[] profiles = dlg.getProfiles();
        if (profiles == null) {
            ExceptionHandler.showException(this.shell, ConnectivityUIPlugin.getDefault().getResourceString("dialog.title.error"), dlg.getException().getMessage(), dlg.getException());
            return;
        }
        ProfileManager manager = ProfileManager.getInstance();
        Cursor cursor = new Cursor((Device)Display.getDefault(), 1);
        this.shell.setCursor(cursor);
        try {
            try {
                for (int i = 0; i < profiles.length; ++i) {
                    if (manager.getProfileByName(profiles[i].getName()) == null) {
                        manager.addProfile(profiles[i]);
                    } else if (dlg.isOverwritten()) {
                        manager.modifyProfile(profiles[i]);
                    }
                    if (this.commonNav == null) continue;
                    this.commonNav.getCommonViewer().refresh((Object)profiles[i]);
                }
                Object var8_8 = null;
            }
            catch (ConnectionProfileException e) {
                ExceptionHandler.showException(this.shell, ConnectivityUIPlugin.getDefault().getResourceString("dialog.title.error"), e.getMessage(), e);
                Object var8_9 = null;
                this.shell.setCursor(null);
                cursor.dispose();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.shell.setCursor(null);
            cursor.dispose();
            cursor = null;
            throw throwable;
        }
        this.shell.setCursor(null);
        cursor.dispose();
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

