/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.concurrent;

import java.util.concurrent.Executor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;

public class CountingRequestMonitor
extends RequestMonitor {
    private boolean fInitialCountSet = false;
    private int fDoneCounter;

    public CountingRequestMonitor(Executor executor, RequestMonitor parentRequestMonitor) {
        super(executor, parentRequestMonitor);
        this.setStatus((IStatus)new MultiStatus("org.eclipse.dd.dsf", 0, "Collective status for set of sub-operations.", null));
    }

    public void setCount(int count) {
        this.fInitialCountSet = true;
        this.fDoneCounter += count;
        if (this.fDoneCounter <= 0) {
            assert (this.fDoneCounter == 0);
            super.done();
        }
    }

    public synchronized void done() {
        --this.fDoneCounter;
        if (this.fInitialCountSet && this.fDoneCounter <= 0) {
            assert (this.fDoneCounter == 0);
            super.done();
        }
    }

    public String toString() {
        return "Multi-RequestMonitor: " + this.getStatus().toString();
    }
}

