/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.ui.viewmodel;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMEvent;
import org.eclipse.dd.dsf.debug.service.INativeProcesses;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.mi.service.MIRunControl;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMLayoutNode;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.IVMContext;
import org.eclipse.dd.dsf.ui.viewmodel.VMDelta;
import org.eclipse.dd.dsf.ui.viewmodel.dm.AbstractDMVMLayoutNode;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.ui.DebugUITools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadLayoutNode
extends AbstractDMVMLayoutNode<IRunControl.IExecutionDMData> {
    public ThreadLayoutNode(AbstractVMProvider provider, DsfSession session) {
        super(provider, session, IRunControl.IExecutionDMContext.class);
    }

    protected void updateElementsInSessionThread(final IChildrenUpdate update) {
        if (!this.checkService(MIRunControl.class, null, (IViewerUpdate)update)) {
            return;
        }
        IRunControl.IContainerDMContext contDmc = (IRunControl.IContainerDMContext)this.findDmcInPath(update.getElementPath(), IRunControl.IContainerDMContext.class);
        if (contDmc == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        ((IRunControl)this.getServicesTracker().getService(IRunControl.class)).getExecutionContexts(contDmc, (DataRequestMonitor)new DataRequestMonitor<IRunControl.IExecutionDMContext[]>((Executor)this.getSession().getExecutor(), null){

            public void handleCompleted() {
                if (!this.getStatus().isOK()) {
                    ThreadLayoutNode.this.handleFailedUpdate((IViewerUpdate)update);
                    return;
                }
                ThreadLayoutNode.this.fillUpdateWithVMCs(update, (IDMContext[])this.getData());
                update.done();
            }
        });
    }

    protected void updateLabelInSessionThread(ILabelUpdate[] updates) {
        for (final ILabelUpdate update : updates) {
            if (!this.checkService(IRunControl.class, null, (IViewerUpdate)update) || !this.checkService(INativeProcesses.class, null, (IViewerUpdate)update)) continue;
            final IRunControl.IExecutionDMContext dmc = (IRunControl.IExecutionDMContext)this.findDmcInPath(update.getElementPath(), IRunControl.IExecutionDMContext.class);
            INativeProcesses processes = (INativeProcesses)this.getServicesTracker().getService(INativeProcesses.class);
            String imageKey = null;
            imageKey = ((IRunControl)this.getServicesTracker().getService(IRunControl.class)).isSuspended((IDMContext)dmc) ? "IMG_OBJS_THREAD_SUSPENDED" : "IMG_OBJS_THREAD_RUNNING";
            update.setImageDescriptor(DebugUITools.getImageDescriptor((String)imageKey), 0);
            final StringBuilder reason = new StringBuilder();
            ((MIRunControl)this.getServicesTracker().getService(MIRunControl.class)).getModelData((IDMContext)dmc, (DataRequestMonitor)new DataRequestMonitor<IRunControl.IExecutionDMData>((Executor)this.getSession().getExecutor(), null){

                public void handleCompleted() {
                    if (!this.getStatus().isOK() || !((IRunControl.IExecutionDMData)this.getData()).isValid()) {
                        update.done();
                        return;
                    }
                    if (((IRunControl.IExecutionDMData)this.getData()).getStateChangeReason() != null) {
                        reason.append(": " + ((IRunControl.IExecutionDMData)this.getData()).getStateChangeReason());
                    }
                }
            });
            ((INativeProcesses)this.getServicesTracker().getService(INativeProcesses.class)).getModelData((IDMContext)processes.getThreadForDebugContext((IDMContext)dmc), (DataRequestMonitor)new DataRequestMonitor<INativeProcesses.IThreadDMData>((Executor)this.getSession().getExecutor(), null){

                public void handleCompleted() {
                    if (!this.getStatus().isOK() || !((INativeProcesses.IThreadDMData)this.getData()).isValid()) {
                        update.done();
                        return;
                    }
                    StringBuilder builder = new StringBuilder("Thread[");
                    builder.append(((MIRunControl.MIExecutionDMC)dmc).getThreadId());
                    builder.append("] ");
                    builder.append(((INativeProcesses.IThreadDMData)this.getData()).getId());
                    builder.append(((INativeProcesses.IThreadDMData)this.getData()).getName());
                    if (((IRunControl)ThreadLayoutNode.this.getServicesTracker().getService(IRunControl.class)).isSuspended((IDMContext)dmc)) {
                        builder.append(" (Suspended");
                    } else {
                        builder.append(" (Running");
                    }
                    if (reason.length() > 0) {
                        builder.append(reason);
                    }
                    builder.append(")");
                    update.setLabel(builder.toString(), 0);
                    update.done();
                }
            });
        }
    }

    protected int getNodeDeltaFlagsForDMEvent(IDMEvent<?> e) {
        if (e instanceof IRunControl.IContainerResumedDMEvent || e instanceof IRunControl.IContainerSuspendedDMEvent || e instanceof IRunControl.IStartedDMEvent || e instanceof IRunControl.IExitedDMEvent) {
            return 1024;
        }
        if (e instanceof IRunControl.IResumedDMEvent || e instanceof IRunControl.ISuspendedDMEvent) {
            return 2048;
        }
        return 0;
    }

    protected void buildDeltaForDMEvent(final IDMEvent<?> e, final VMDelta parentDelta, final int nodeOffset, final RequestMonitor requestMonitor) {
        if (e instanceof IRunControl.IContainerResumedDMEvent || e instanceof IRunControl.IContainerSuspendedDMEvent) {
            final Map childNodeDeltas = this.getChildNodesWithDeltaFlags(e);
            if (childNodeDeltas.size() == 0) {
                requestMonitor.done();
                return;
            }
            this.updateElements((IChildrenUpdate)new AbstractVMLayoutNode.ElementsUpdate((AbstractVMLayoutNode)this, (DataRequestMonitor)new DataRequestMonitor<List<Object>>((Executor)this.getExecutor(), null){

                protected void handleCompleted() {
                    if (ThreadLayoutNode.this.isDisposed()) {
                        return;
                    }
                    if (!this.getStatus().isOK() || ((List)this.getData()).isEmpty()) {
                        requestMonitor.done();
                        return;
                    }
                    for (int i = 0; i < ((List)this.getData()).size(); ++i) {
                        IVMContext vmc = (IVMContext)((List)this.getData()).get(i);
                        VMDelta delta = parentDelta.addNode((Object)vmc, nodeOffset + i, 2048);
                        ThreadLayoutNode.this.callChildNodesToBuildDelta(childNodeDeltas, delta, e, requestMonitor);
                        if (vmc.equals(((List)this.getData()).get(i))) break;
                    }
                }
            }, (IModelDelta)parentDelta));
            return;
        }
        if (e instanceof IRunControl.IResumedDMEvent || e instanceof IRunControl.ISuspendedDMEvent) {
            parentDelta.addNode((Object)new AbstractDMVMLayoutNode.DMVMContext((AbstractDMVMLayoutNode)this, e.getDMContext()), 2048);
            super.buildDeltaForDMEvent(e, parentDelta, nodeOffset, requestMonitor);
        } else {
            super.buildDeltaForDMEvent(e, parentDelta, nodeOffset, requestMonitor);
        }
    }
}

