/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.ui.viewmodel.detailpanesupport;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dd.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMService;
import org.eclipse.dd.dsf.debug.service.IExpressions;
import org.eclipse.dd.dsf.debug.service.IFormattedValues;
import org.eclipse.dd.dsf.debug.service.IRegisters;
import org.eclipse.dd.dsf.debug.ui.DsfDebugUIPlugin;
import org.eclipse.dd.dsf.debug.ui.viewmodel.detailpanesupport.DetailPaneFactory;
import org.eclipse.dd.dsf.debug.ui.viewmodel.detailpanesupport.TextViewerAction;
import org.eclipse.dd.dsf.service.DsfServicesTracker;
import org.eclipse.dd.dsf.ui.viewmodel.dm.AbstractDMVMLayoutNode;
import org.eclipse.dd.dsf.ui.viewmodel.update.VMCacheManager;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.LazyModelPresentation;
import org.eclipse.debug.internal.ui.VariablesViewModelPresentation;
import org.eclipse.debug.internal.ui.actions.variables.details.DetailPaneMaxLengthAction;
import org.eclipse.debug.internal.ui.actions.variables.details.DetailPaneWordWrapAction;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.views.variables.IndexedValuePartition;
import org.eclipse.debug.internal.ui.views.variables.StatusLineContributionItem;
import org.eclipse.debug.internal.ui.views.variables.details.DetailMessages;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.debug.ui.IDetailPane;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.IUndoManagerExtension;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.operations.OperationHistoryActionHandler;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;

public class DetailPane
implements IDetailPane,
IAdaptable,
IPropertyChangeListener {
    private IWorkbenchPartSite fWorkbenchPartSite;
    private Map<String, IAction> fActionMap = new HashMap<String, IAction>();
    private List<String> fSelectionActions = new ArrayList<String>();
    protected static final String DETAIL_COPY_ACTION = ActionFactory.COPY.getId() + ".SourceDetailPane";
    protected static final String DETAIL_SELECT_ALL_ACTION = IDebugView.SELECT_ALL_ACTION + ".SourceDetailPane";
    protected static final String DETAIL_WORD_WRAP_ACTION = "org.eclipse.debug.ui.detail_pane_word_wrap";
    protected static final String DETAIL_MAX_LENGTH_ACTION = "MaxLength";
    public static final String ID = DetailMessages.DefaultDetailPane_0;
    public static final String NAME = DetailMessages.DefaultDetailPane_1;
    public static final String DESCRIPTION = DetailMessages.DefaultDetailPane_57;
    private VariablesViewModelPresentation fModelPresentation;
    private String fDebugModelIdentifier;
    private StatusLineContributionItem fStatusLineItem;
    private SourceViewer fSourceViewer;
    private IStructuredSelection fLastDisplayed = null;
    private IDocument fDetailDocument;
    private DetailJob fDetailJob = null;
    private final String fPositionLabelPattern = DetailMessages.DefaultDetailPane_56;
    private final PositionLabelValue fLineLabel = new PositionLabelValue();
    private final PositionLabelValue fColumnLabel = new PositionLabelValue();
    private final Object[] fPositionLabelPatternArguments = new Object[]{this.fLineLabel, this.fColumnLabel};
    private ICursorListener fCursorListener;

    public void init(IWorkbenchPartSite workbench) {
        this.fWorkbenchPartSite = workbench;
    }

    protected void setAction(String actionID, IAction action) {
        if (action == null) {
            this.fActionMap.remove(actionID);
        } else {
            this.fActionMap.put(actionID, action);
        }
    }

    protected void setGlobalAction(String actionID, IAction action) {
        this.getViewSite().getActionBars().setGlobalActionHandler(actionID, action);
    }

    protected void setSelectionDependantAction(String actionID) {
        if (actionID != null) {
            this.fSelectionActions.add(actionID);
        }
    }

    protected IAction getAction(String actionID) {
        return this.fActionMap.get(actionID);
    }

    protected void updateAction(String actionId) {
        IAction action = this.getAction(actionId);
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    protected void updateSelectionDependentActions() {
        Iterator<String> iterator = this.fSelectionActions.iterator();
        while (iterator.hasNext()) {
            this.updateAction(iterator.next());
        }
    }

    protected IViewSite getViewSite() {
        if (this.fWorkbenchPartSite == null) {
            return null;
        }
        return (IViewSite)this.fWorkbenchPartSite.getPart().getSite();
    }

    protected IWorkbenchPartSite getWorkbenchPartSite() {
        return this.fWorkbenchPartSite;
    }

    protected boolean isInView() {
        return this.fWorkbenchPartSite != null;
    }

    public Control createControl(Composite parent) {
        this.fModelPresentation = new VariablesViewModelPresentation();
        this.createSourceViewer(parent);
        if (this.isInView()) {
            this.createViewSpecificComponents();
            this.createActions();
            DebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
            JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        }
        return this.fSourceViewer.getControl();
    }

    private void createSourceViewer(Composite parent) {
        this.fSourceViewer = new SourceViewer(parent, null, 768);
        this.fSourceViewer.setDocument(this.getDetailDocument());
        this.fSourceViewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.debug.ui.DetailPaneFont"));
        this.fSourceViewer.getTextWidget().setWordWrap(DebugUIPlugin.getDefault().getPreferenceStore().getBoolean(DETAIL_WORD_WRAP_ACTION));
        this.fSourceViewer.setEditable(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fSourceViewer.getTextWidget(), "org.eclipse.debug.ui.detail_pane_context");
        Control control = this.fSourceViewer.getControl();
        GridData gd = new GridData(1808);
        control.setLayoutData((Object)gd);
    }

    private void createViewSpecificComponents() {
        this.getDetailDocument().addDocumentListener(new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                DetailPane.this.updateSelectionDependentActions();
            }
        });
        this.fSourceViewer.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DetailPane.this.updateSelectionDependentActions();
            }
        });
        this.fSourceViewer.getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DetailPane.this.getViewSite().setSelectionProvider(DetailPane.this.fSourceViewer.getSelectionProvider());
                DetailPane.this.setGlobalAction(IDebugView.SELECT_ALL_ACTION, DetailPane.this.getAction(DETAIL_SELECT_ALL_ACTION));
                DetailPane.this.setGlobalAction(IDebugView.COPY_ACTION, DetailPane.this.getAction(DETAIL_COPY_ACTION));
                DetailPane.this.getViewSite().getActionBars().updateActionBars();
            }

            public void focusLost(FocusEvent e) {
                DetailPane.this.getViewSite().setSelectionProvider(null);
                DetailPane.this.setGlobalAction(IDebugView.SELECT_ALL_ACTION, null);
                DetailPane.this.setGlobalAction(IDebugView.COPY_ACTION, null);
                DetailPane.this.getViewSite().getActionBars().updateActionBars();
            }
        });
        this.fStatusLineItem = new StatusLineContributionItem("ModeContributionItem");
        IStatusLineManager manager = this.getViewSite().getActionBars().getStatusLineManager();
        manager.add((IContributionItem)this.fStatusLineItem);
        this.fSourceViewer.getTextWidget().addMouseListener((MouseListener)this.getCursorListener());
        this.fSourceViewer.getTextWidget().addKeyListener((KeyListener)this.getCursorListener());
        this.createDetailContextMenu((Control)this.fSourceViewer.getTextWidget());
    }

    private void createActions() {
        TextViewerAction textAction = new TextViewerAction((ITextViewer)this.fSourceViewer, 7);
        textAction.configureAction(DetailMessages.DefaultDetailPane_Select__All_5, "", "");
        textAction.setActionDefinitionId("org.eclipse.ui.edit.selectAll");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)textAction, "org.eclipse.debug.ui.detail_pane_select_all_action_context");
        this.setAction(DETAIL_SELECT_ALL_ACTION, (IAction)textAction);
        textAction = new TextViewerAction((ITextViewer)this.fSourceViewer, 4);
        textAction.configureAction(DetailMessages.DefaultDetailPane__Copy_8, "", "");
        textAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)textAction, "org.eclipse.debug.ui.detail_pane_copy_action_context");
        this.setAction(DETAIL_COPY_ACTION, (IAction)textAction);
        this.setSelectionDependantAction(DETAIL_COPY_ACTION);
        this.updateSelectionDependentActions();
        DetailPaneWordWrapAction action = new DetailPaneWordWrapAction((ITextViewer)this.fSourceViewer);
        this.setAction(DETAIL_WORD_WRAP_ACTION, (IAction)action);
        action = new DetailPaneMaxLengthAction(this.fSourceViewer.getControl().getShell());
        this.setAction(DETAIL_MAX_LENGTH_ACTION, (IAction)action);
    }

    protected void createDetailContextMenu(Control menuControl) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                DetailPane.this.fillDetailContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(menuControl);
        menuControl.setMenu(menu);
        this.getViewSite().registerContextMenu("org.eclipse.debug.ui.VariableView.detail", menuMgr, this.fSourceViewer.getSelectionProvider());
    }

    protected void fillDetailContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("variableGroup"));
        menu.add((IContributionItem)new Separator());
        menu.add(this.getAction(DETAIL_COPY_ACTION));
        menu.add(this.getAction(DETAIL_SELECT_ALL_ACTION));
        menu.add((IContributionItem)new Separator());
        menu.add(this.getAction(DETAIL_WORD_WRAP_ACTION));
        menu.add(this.getAction(DETAIL_MAX_LENGTH_ACTION));
        menu.add((IContributionItem)new Separator("additions"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void display(IStructuredSelection selection) {
        if (selection == null) {
            this.clearSourceViewer();
            return;
        }
        this.fLastDisplayed = selection;
        if (selection.isEmpty()) {
            this.clearSourceViewer();
            return;
        }
        Object firstElement = selection.getFirstElement();
        if (firstElement != null && firstElement instanceof IDebugElement) {
            String modelID = ((IDebugElement)firstElement).getModelIdentifier();
            this.setDebugModel(modelID);
        }
        DetailPane detailPane = this;
        synchronized (detailPane) {
            if (this.fDetailJob != null) {
                this.fDetailJob.cancel();
            }
            this.fDetailJob = new DetailJob(selection, (IDebugModelPresentation)this.fModelPresentation);
            this.fDetailJob.schedule();
        }
    }

    public boolean setFocus() {
        if (this.fSourceViewer != null) {
            this.fSourceViewer.getTextWidget().setFocus();
            return true;
        }
        return false;
    }

    public void dispose() {
        this.fActionMap.clear();
        this.fSelectionActions.clear();
        if (this.fDetailJob != null) {
            this.fDetailJob.cancel();
        }
        if (this.fModelPresentation != null) {
            this.fModelPresentation.dispose();
        }
        this.fDebugModelIdentifier = null;
        if (this.fSourceViewer != null && this.fSourceViewer.getControl() != null) {
            this.fSourceViewer.getControl().dispose();
        }
        if (this.isInView()) {
            this.disposeUndoRedoAction(ITextEditorActionConstants.UNDO);
            this.disposeUndoRedoAction(ITextEditorActionConstants.REDO);
            this.getViewSite().getActionBars().getStatusLineManager().remove((IContributionItem)this.fStatusLineItem);
            DebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
            JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
        }
    }

    public String getDescription() {
        return DetailPaneFactory.DSF_DETAIL_PANE_DESC;
    }

    public String getID() {
        return DetailPaneFactory.DSF_DETAIL_PANE_ID;
    }

    public String getName() {
        return DetailPaneFactory.DSF_DETAIL_PANE_NAME;
    }

    public Object getAdapter(Class required) {
        if (IFindReplaceTarget.class.equals((Object)required)) {
            return this.fSourceViewer.getFindReplaceTarget();
        }
        if (ITextViewer.class.equals((Object)required)) {
            return this.fSourceViewer;
        }
        return null;
    }

    protected IDocument getDetailDocument() {
        if (this.fDetailDocument == null) {
            this.fDetailDocument = new Document();
        }
        return this.fDetailDocument;
    }

    protected void clearSourceViewer() {
        if (this.fDetailJob != null) {
            this.fDetailJob.cancel();
        }
        this.fLastDisplayed = null;
        this.fDetailDocument.set("");
        this.fSourceViewer.setEditable(false);
    }

    protected void configureDetailsViewer() {
        LazyModelPresentation mp = (LazyModelPresentation)this.fModelPresentation.getPresentation(this.getDebugModel());
        SourceViewerConfiguration svc = null;
        if (mp != null) {
            try {
                svc = mp.newDetailsViewerConfiguration();
            }
            catch (CoreException e) {
                DebugUIPlugin.errorDialog((Shell)this.fSourceViewer.getControl().getShell(), (String)DetailMessages.DefaultDetailPane_Error_1, (String)DetailMessages.DefaultDetailPane_2, (Throwable)e);
            }
        }
        if (svc == null) {
            svc = new SourceViewerConfiguration();
            this.fSourceViewer.setEditable(false);
        }
        this.fSourceViewer.unconfigure();
        this.fSourceViewer.configure(svc);
        if (this.isInView()) {
            this.createUndoRedoActions();
        }
    }

    protected String getCursorPosition() {
        if (this.fSourceViewer == null) {
            return "";
        }
        StyledText styledText = this.fSourceViewer.getTextWidget();
        int caret = styledText.getCaretOffset();
        IDocument document = this.fSourceViewer.getDocument();
        if (document == null) {
            return "";
        }
        try {
            int line = document.getLineOfOffset(caret);
            int lineOffset = document.getLineOffset(line);
            int tabWidth = styledText.getTabs();
            int column = 0;
            for (int i = lineOffset; i < caret; ++i) {
                if ('\t' == document.getChar(i)) {
                    column += tabWidth - (tabWidth == 0 ? 0 : column % tabWidth);
                    continue;
                }
                ++column;
            }
            this.fLineLabel.fValue = line + 1;
            this.fColumnLabel.fValue = column + 1;
            return MessageFormat.format(this.fPositionLabelPattern, this.fPositionLabelPatternArguments);
        }
        catch (BadLocationException x) {
            return "";
        }
    }

    private ICursorListener getCursorListener() {
        if (this.fCursorListener == null) {
            this.fCursorListener = new ICursorListener(){

                public void keyPressed(KeyEvent e) {
                    DetailPane.this.fStatusLineItem.setText(DetailPane.this.getCursorPosition());
                }

                public void keyReleased(KeyEvent e) {
                }

                public void mouseDoubleClick(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseUp(MouseEvent e) {
                    DetailPane.this.fStatusLineItem.setText(DetailPane.this.getCursorPosition());
                }
            };
        }
        return this.fCursorListener;
    }

    protected String getDebugModel() {
        return this.fDebugModelIdentifier;
    }

    protected void setDebugModel(String id) {
        if (id != this.fDebugModelIdentifier) {
            this.fDebugModelIdentifier = id;
            this.configureDetailsViewer();
        }
    }

    protected void createUndoRedoActions() {
        this.disposeUndoRedoAction(ITextEditorActionConstants.UNDO);
        this.disposeUndoRedoAction(ITextEditorActionConstants.REDO);
        IUndoContext undoContext = this.getUndoContext();
        if (undoContext != null) {
            UndoActionHandler undoAction = new UndoActionHandler((IWorkbenchPartSite)this.getViewSite(), undoContext);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)undoAction, IAbstractTextEditorHelpContextIds.UNDO_ACTION);
            undoAction.setActionDefinitionId("org.eclipse.ui.edit.undo");
            this.setAction(ITextEditorActionConstants.UNDO, (IAction)undoAction);
            this.setGlobalAction(ITextEditorActionConstants.UNDO, (IAction)undoAction);
            RedoActionHandler redoAction = new RedoActionHandler((IWorkbenchPartSite)this.getViewSite(), undoContext);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)redoAction, IAbstractTextEditorHelpContextIds.REDO_ACTION);
            redoAction.setActionDefinitionId("org.eclipse.ui.edit.redo");
            this.setAction(ITextEditorActionConstants.REDO, (IAction)redoAction);
            this.setGlobalAction(ITextEditorActionConstants.REDO, (IAction)redoAction);
            this.getViewSite().getActionBars().updateActionBars();
        }
    }

    protected void disposeUndoRedoAction(String actionId) {
        OperationHistoryActionHandler action = (OperationHistoryActionHandler)this.getAction(actionId);
        if (action != null) {
            action.dispose();
            this.setAction(actionId, null);
        }
    }

    private IUndoContext getUndoContext() {
        IUndoManager undoManager = this.fSourceViewer.getUndoManager();
        if (undoManager instanceof IUndoManagerExtension) {
            return ((IUndoManagerExtension)undoManager).getUndoContext();
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getProperty();
        if (propertyName.equals("org.eclipse.debug.ui.DetailPaneFont")) {
            this.fSourceViewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.debug.ui.DetailPaneFont"));
        } else if (propertyName.equals("org.eclipse.debug.ui.max_detail_length")) {
            this.display(this.fLastDisplayed);
        } else if (propertyName.equals(DETAIL_WORD_WRAP_ACTION)) {
            this.fSourceViewer.getTextWidget().setWordWrap(DebugUIPlugin.getDefault().getPreferenceStore().getBoolean(DETAIL_WORD_WRAP_ACTION));
            this.getAction(DETAIL_WORD_WRAP_ACTION).setChecked(DebugUIPlugin.getDefault().getPreferenceStore().getBoolean(DETAIL_WORD_WRAP_ACTION));
        }
    }

    class DetailJob
    extends Job
    implements IValueDetailListener {
        private IStructuredSelection fElements;
        private IDebugModelPresentation fModel;
        private boolean fFirst;
        private IProgressMonitor fMonitor;
        private boolean fComputed;

        public DetailJob(IStructuredSelection elements, IDebugModelPresentation model) {
            super("compute variable details");
            this.fFirst = true;
            this.fComputed = false;
            this.setSystem(true);
            this.fElements = elements;
            this.fModel = model;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(final IProgressMonitor monitor) {
            String message = null;
            if (this.fMonitor != null && !this.fMonitor.isCanceled()) {
                this.fMonitor.setCanceled(true);
            }
            this.fMonitor = monitor;
            Iterator iterator = this.fElements.iterator();
            while (iterator.hasNext() && !monitor.isCanceled()) {
                Object element = iterator.next();
                if (element instanceof AbstractDMVMLayoutNode.DMVMContext) {
                    IPresentationContext context = ((AbstractDMVMLayoutNode.DMVMContext)element).getLayoutNode().getVMProvider().getPresentationContext();
                    IFormattedValues service = null;
                    IRegisters.IBitFieldDMContext dmc = null;
                    DsfServicesTracker tracker = new DsfServicesTracker(DsfDebugUIPlugin.getBundleContext(), ((AbstractDMVMLayoutNode.DMVMContext)element).getDMC().getSessionId());
                    IRegisters.IBitFieldDMContext bitfieldDmc = (IRegisters.IBitFieldDMContext)DMContexts.getAncestorOfType((IDMContext)((AbstractDMVMLayoutNode.DMVMContext)element).getDMC(), IRegisters.IBitFieldDMContext.class);
                    if (bitfieldDmc != null) {
                        dmc = bitfieldDmc;
                        service = (IFormattedValues)tracker.getService(IRegisters.class);
                    } else {
                        IRegisters.IRegisterDMContext regDmc = (IRegisters.IRegisterDMContext)DMContexts.getAncestorOfType((IDMContext)((AbstractDMVMLayoutNode.DMVMContext)element).getDMC(), IRegisters.IRegisterDMContext.class);
                        if (regDmc != null) {
                            dmc = regDmc;
                            service = (IFormattedValues)tracker.getService(IRegisters.class);
                        } else {
                            IExpressions.IExpressionDMContext exprDmc = (IExpressions.IExpressionDMContext)DMContexts.getAncestorOfType((IDMContext)((AbstractDMVMLayoutNode.DMVMContext)element).getDMC(), IExpressions.IExpressionDMContext.class);
                            if (exprDmc != null) {
                                dmc = exprDmc;
                                service = (IFormattedValues)tracker.getService(IExpressions.class);
                            }
                        }
                    }
                    if (dmc == null) {
                        return Status.OK_STATUS;
                    }
                    IRegisters.IBitFieldDMContext finalDmc = dmc;
                    final IFormattedValues finalService = service;
                    DataRequestMonitor<String[]> getAvailableFormatsDone = new DataRequestMonitor<String[]>((Executor)finalService.getSession().getExecutor(), null, (IFormattedValues.IFormattedDataDMContext)finalDmc, context){
                        final /* synthetic */ IFormattedValues.IFormattedDataDMContext val$finalDmc;
                        final /* synthetic */ IPresentationContext val$context;
                        {
                            this.val$finalDmc = iFormattedDataDMContext;
                            this.val$context = iPresentationContext;
                            super(x0, x1);
                        }

                        protected void handleOK() {
                            if (monitor.isCanceled()) {
                                return;
                            }
                            String[] formats = (String[])this.getData();
                            final ArrayList completedFormatStrings = new ArrayList();
                            final CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)finalService.getSession().getExecutor(), null){

                                protected void handleCompleted() {
                                    if (monitor.isCanceled()) {
                                        return;
                                    }
                                    String finalResult = "";
                                    for (String str : completedFormatStrings) {
                                        finalResult = finalResult + str + "\n";
                                    }
                                    DetailJob.this.replaceDetailContent(finalResult);
                                }
                            };
                            countingRm.setCount(formats.length);
                            for (final String str : formats) {
                                IFormattedValues.FormattedValueDMContext valueDmc = finalService.getFormattedValue(this.val$finalDmc, str);
                                VMCacheManager.getVMCacheManager().getCache(this.val$context).getModelData((IDMService)finalService, (IDMContext)valueDmc, (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)finalService.getSession().getExecutor(), null){

                                    public void handleCompleted() {
                                        if (this.getStatus().isOK()) {
                                            if (str == "HEX.Format") {
                                                completedFormatStrings.add("Hex.... : " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue());
                                            } else if (str == "OCTAL.Format") {
                                                completedFormatStrings.add("Octal.. : " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue());
                                            } else if (str == "NATURAL.Format") {
                                                completedFormatStrings.add("Natural : " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue());
                                            } else if (str == "BINARY.Format") {
                                                completedFormatStrings.add("Binary. : " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue());
                                            } else if (str == "DECIMAL.Format") {
                                                completedFormatStrings.add("Decimal : " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue());
                                            } else {
                                                completedFormatStrings.add("Other.. : " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue());
                                            }
                                        }
                                        countingRm.done();
                                    }
                                }, finalService.getSession().getExecutor());
                            }
                        }
                    };
                    finalService.getExecutor().submit(new Runnable((IFormattedValues.IFormattedDataDMContext)finalDmc, (DataRequestMonitor)getAvailableFormatsDone){
                        final /* synthetic */ IFormattedValues.IFormattedDataDMContext val$finalDmc;
                        final /* synthetic */ DataRequestMonitor val$getAvailableFormatsDone;
                        {
                            this.val$finalDmc = iFormattedDataDMContext;
                            this.val$getAvailableFormatsDone = dataRequestMonitor;
                        }

                        public void run() {
                            finalService.getAvailableFormattedValues(this.val$finalDmc, this.val$getAvailableFormatsDone);
                        }
                    });
                } else {
                    IValue val = null;
                    if (element instanceof IVariable) {
                        try {
                            val = ((IVariable)element).getValue();
                        }
                        catch (DebugException e) {
                            this.detailComputed(null, e.getStatus().getMessage());
                        }
                    } else if (element instanceof IExpression) {
                        val = ((IExpression)element).getValue();
                    }
                    if (val instanceof IndexedValuePartition) {
                        this.detailComputed(null, "");
                        val = null;
                    }
                    if (element instanceof String) {
                        message = (String)element;
                    }
                    if (val != null && !monitor.isCanceled()) {
                        this.fModel.computeDetail(val, (IValueDetailListener)this);
                        DetailJob detailJob = this;
                        synchronized (detailJob) {
                            block24: {
                                try {
                                    ((Object)((Object)this)).wait(30000L);
                                    if (this.fComputed) break block24;
                                    this.fMonitor.setCanceled(true);
                                }
                                catch (InterruptedException e) {
                                    break;
                                }
                            }
                        }
                    }
                }
                if (this.fComputed) continue;
                if (message == null) {
                    this.detailComputed(null, "");
                    continue;
                }
                this.detailComputed(null, message);
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void canceling() {
            super.canceling();
            DetailJob detailJob = this;
            synchronized (detailJob) {
                ((Object)((Object)this)).notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void replaceDetailContent(final String result) {
            if (!this.fMonitor.isCanceled()) {
                WorkbenchJob append = new WorkbenchJob("append details"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (!DetailJob.this.fMonitor.isCanceled()) {
                            String insert = result;
                            int max = DebugUIPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.debug.ui.max_detail_length");
                            if (max > 0 && insert.length() > max) {
                                insert = insert.substring(0, max) + "...";
                            }
                            DetailPane.this.getDetailDocument().set(insert);
                        }
                        return Status.OK_STATUS;
                    }
                };
                append.setSystem(true);
                append.schedule();
            }
            DetailJob detailJob = this;
            synchronized (detailJob) {
                ((Object)((Object)this)).notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void detailComputed(IValue value, final String result) {
            if (!this.fMonitor.isCanceled()) {
                WorkbenchJob append = new WorkbenchJob("append details"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (!DetailJob.this.fMonitor.isCanceled()) {
                            String insert = result;
                            int length = 0;
                            if (!DetailJob.this.fFirst) {
                                length = DetailPane.this.getDetailDocument().getLength();
                            }
                            if (length > 0) {
                                insert = "\n" + result;
                            }
                            try {
                                int max = DebugUIPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.debug.ui.max_detail_length");
                                if (max > 0 && insert.length() > max) {
                                    insert = insert.substring(0, max) + "...";
                                }
                                if (DetailJob.this.fFirst) {
                                    DetailPane.this.getDetailDocument().set(insert);
                                    DetailJob.this.fFirst = false;
                                } else {
                                    DetailPane.this.getDetailDocument().replace(length, 0, insert);
                                }
                            }
                            catch (BadLocationException e) {
                                DebugUIPlugin.log((Throwable)e);
                            }
                        }
                        return Status.OK_STATUS;
                    }
                };
                append.setSystem(true);
                append.schedule();
            }
            DetailJob detailJob = this;
            synchronized (detailJob) {
                ((Object)((Object)this)).notifyAll();
            }
        }
    }

    static interface ICursorListener
    extends MouseListener,
    KeyListener {
    }

    private static class PositionLabelValue {
        public int fValue;

        private PositionLabelValue() {
        }

        public String toString() {
            return String.valueOf(this.fValue);
        }
    }
}

