/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.ui.viewmodel.expression;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.dd.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.MultiRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMData;
import org.eclipse.dd.dsf.debug.ui.viewmodel.expression.IExpressionLayoutNode;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMLayoutNode;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.VMDelta;
import org.eclipse.dd.dsf.ui.viewmodel.VMElementsUpdate;
import org.eclipse.dd.dsf.ui.viewmodel.dm.AbstractDMVMLayoutNode;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.jface.viewers.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExpressionLayoutNode<V extends IDMData>
extends AbstractDMVMLayoutNode<V>
implements IExpressionLayoutNode {
    public AbstractExpressionLayoutNode(AbstractVMProvider provider, DsfSession session, Class<? extends IDMContext<V>> dmcClassType) {
        super(provider, session, dmcClassType);
    }

    @Override
    public void getElementForExpression(final IChildrenUpdate update, final String expressionText, final IExpression expression) {
        final int exprLength = this.getExpressionLength(expressionText);
        if (exprLength < 0) {
            update.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10005, "Invalid expression", null));
            update.done();
            return;
        }
        String nodeExpressionText = exprLength > 0 ? expressionText.substring(0, exprLength) : expressionText;
        this.getElementForExpressionPart(update, nodeExpressionText, new DataRequestMonitor<Object>((Executor)this.getExecutor(), null){

            protected void handleOK() {
                if (exprLength == expressionText.length()) {
                    Object element = this.getData();
                    AbstractExpressionLayoutNode.this.associateExpression(element, expression);
                    update.setChild(element, 0);
                    update.done();
                } else {
                    AbstractExpressionLayoutNode.this.getVMContextForExpressionFromChildNodes(update, this.getData(), expressionText.substring(exprLength), expression);
                }
            }

            protected void handleErrorOrCancel() {
                update.setStatus(this.getStatus());
                update.done();
            }
        });
    }

    protected void getElementForExpressionPart(final IChildrenUpdate update, final String expressionPartText, final DataRequestMonitor<Object> rm) {
        this.updateElements((IChildrenUpdate)new VMElementsUpdate(update, -1, -1, (DataRequestMonitor)new DataRequestMonitor<List<Object>>((Executor)this.getExecutor(), rm){

            protected void handleOK() {
                if (((List)this.getData()).size() == 0) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10005, "No contexts", null));
                    rm.done();
                } else {
                    final List elements = (List)this.getData();
                    MultiRequestMonitor<DataRequestMonitor<Boolean>> multiRm = new MultiRequestMonitor<DataRequestMonitor<Boolean>>((Executor)AbstractExpressionLayoutNode.this.getExecutor(), (RequestMonitor)rm){

                        protected void handleOK() {
                            boolean foundMatchingContext = false;
                            for (int i = 0; i < this.getRequestMonitors().size(); ++i) {
                                if (!((Boolean)((DataRequestMonitor)this.getRequestMonitors().get(i)).getData()).booleanValue()) continue;
                                rm.setData(elements.get(i));
                                foundMatchingContext = true;
                                break;
                            }
                            if (!foundMatchingContext) {
                                rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10005, "Context not found", null));
                            }
                            rm.done();
                        }
                    };
                    for (Object element : elements) {
                        AbstractExpressionLayoutNode.this.testContextForExpression(element, expressionPartText, (DataRequestMonitor<Boolean>)((DataRequestMonitor)multiRm.add((RequestMonitor)new DataRequestMonitor<Boolean>((Executor)AbstractExpressionLayoutNode.this.getExecutor(), null, (MultiRequestMonitor)multiRm){
                            final /* synthetic */ MultiRequestMonitor val$multiRm;
                            {
                                this.val$multiRm = multiRequestMonitor;
                                super(x0, x1);
                            }

                            protected void handleCompleted() {
                                this.val$multiRm.requestMonitorDone((RequestMonitor)this);
                            }
                        })));
                    }
                }
            }

            protected void handleErrorOrCancel() {
                update.setStatus(this.getStatus());
                update.done();
            }
        }));
    }

    @ConfinedToDsfExecutor(value="#getSession#getExecutor")
    protected abstract void testContextForExpression(Object var1, String var2, DataRequestMonitor<Boolean> var3);

    protected abstract void associateExpression(Object var1, IExpression var2);

    protected void getVMContextForExpressionFromChildNodes(final IChildrenUpdate update, Object parentElement, String childExpression, IExpression expression) {
        ChildExpressionElementUpdate childUpdate = new ChildExpressionElementUpdate(update, update.getElementPath().createChildPath(parentElement), new DataRequestMonitor<List<Object>>((Executor)this.getExecutor(), null){

            protected void handleOK() {
                update.setChild(((List)this.getData()).get(0), 0);
                update.done();
            }

            protected void handleErrorOrCancel() {
                update.setStatus(this.getStatus());
                update.done();
            }
        });
        for (int i = 0; i < this.getChildLayoutNodes().length; ++i) {
            IExpressionLayoutNode childNode;
            if (!(this.getChildLayoutNodes()[i] instanceof IExpressionLayoutNode) || (childNode = (IExpressionLayoutNode)this.getChildLayoutNodes()[i]).getExpressionLength(childExpression) <= 0) continue;
            childNode.getElementForExpression((IChildrenUpdate)childUpdate, childExpression, expression);
            return;
        }
        update.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10005, "Invalid expression", null));
        update.done();
    }

    @Override
    public int getDeltaFlagsForExpression(String expressionText, Object event) {
        int exprLength = this.getExpressionLength(expressionText);
        if (exprLength >= 0) {
            if (exprLength == expressionText.length()) {
                return this.getDeltaFlags(event);
            }
            int retVal = this.getDeltaFlagsForExpressionPart(event);
            String childExpression = expressionText.substring(exprLength);
            for (int i = 0; i < this.getChildLayoutNodes().length; ++i) {
                IExpressionLayoutNode exprNode;
                if (!(this.getChildLayoutNodes()[i] instanceof IExpressionLayoutNode) || (exprNode = (IExpressionLayoutNode)this.getChildLayoutNodes()[i]).getExpressionLength(childExpression) <= 0) continue;
                retVal |= exprNode.getDeltaFlagsForExpression(childExpression, event);
            }
            return retVal;
        }
        return 0;
    }

    protected abstract int getDeltaFlagsForExpressionPart(Object var1);

    @Override
    public void buildDeltaForExpression(final IExpression expression, final int elementIdx, final String expressionText, final Object event, final VMDelta parentDelta, final TreePath path, final RequestMonitor rm) {
        final int exprLength = this.getExpressionLength(expressionText);
        if (exprLength < 0) {
            rm.done();
            return;
        }
        String nodeExpressionText = exprLength > 0 ? expressionText.substring(0, exprLength) : expressionText;
        this.getElementForExpressionPart((IChildrenUpdate)new AbstractVMLayoutNode.ElementsUpdate((AbstractVMLayoutNode)this, new DataRequestMonitor((Executor)this.getExecutor(), null), path), nodeExpressionText, new DataRequestMonitor<Object>((Executor)this.getExecutor(), null){

            protected void handleOK() {
                if (exprLength == expressionText.length()) {
                    AbstractExpressionLayoutNode.this.associateExpression(this.getData(), expression);
                    AbstractExpressionLayoutNode.this.buildDeltaForExpressionElement(this.getData(), elementIdx, event, parentDelta, rm);
                } else {
                    TreePath newPath = path.createChildPath(this.getData());
                    AbstractExpressionLayoutNode.this.callChildExpressionNodesToBuildDelta(expression, elementIdx, expressionText.substring(exprLength), event, parentDelta, newPath, rm);
                }
            }

            protected void handleErrorOrCancel() {
                rm.done();
            }
        });
    }

    protected void buildDeltaForExpressionElement(Object element, int elementIdx, Object event, VMDelta parentDelta, RequestMonitor rm) {
        Map childNodesWithDeltaFlags = this.getChildNodesWithDeltaFlags(event);
        if (childNodesWithDeltaFlags.size() == 0) {
            rm.done();
            return;
        }
        this.callChildNodesToBuildDelta(childNodesWithDeltaFlags, parentDelta.addNode(element, elementIdx, 0), event, rm);
    }

    protected void callChildExpressionNodesToBuildDelta(IExpression expression, int elementIdx, String expressionRemainder, Object event, VMDelta parentDelta, TreePath path, final RequestMonitor rm) {
        CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)this.getExecutor(), null){

            protected void handleCompleted() {
                rm.done();
            }
        };
        int childRmCount = 0;
        for (int i = 0; i < this.getChildLayoutNodes().length; ++i) {
            IExpressionLayoutNode childNode;
            if (!(this.getChildLayoutNodes()[i] instanceof IExpressionLayoutNode) || (childNode = (IExpressionLayoutNode)this.getChildLayoutNodes()[i]).getExpressionLength(expressionRemainder) <= 0 || childNode.getDeltaFlagsForExpression(expressionRemainder, event) == 0) continue;
            childNode.buildDeltaForExpression(expression, elementIdx, expressionRemainder, event, parentDelta, path, (RequestMonitor)countingRm);
            ++childRmCount;
        }
        countingRm.setCount(childRmCount);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ChildExpressionElementUpdate
    extends VMElementsUpdate {
        private final TreePath fPath;

        ChildExpressionElementUpdate(IChildrenUpdate clientUpdate, TreePath path, DataRequestMonitor<List<Object>> rm) {
            super(clientUpdate, 0, 1, rm);
            this.fPath = path;
        }

        public Object getElement() {
            return this.fPath.getLastSegment();
        }

        public TreePath getElementPath() {
            return this.fPath;
        }
    }
}

