/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.ui.viewmodel.expression;

import org.eclipse.dd.dsf.debug.ui.viewmodel.dm.AbstractDebugDMVMProviderWithCache;
import org.eclipse.dd.dsf.debug.ui.viewmodel.expression.ExpressionColumnPresentation;
import org.eclipse.dd.dsf.debug.ui.viewmodel.expression.ExpressionManagerLayoutNode;
import org.eclipse.dd.dsf.debug.ui.viewmodel.expression.IExpressionLayoutNode;
import org.eclipse.dd.dsf.debug.ui.viewmodel.formatsupport.FormattedValuePreferenceStore;
import org.eclipse.dd.dsf.debug.ui.viewmodel.register.RegisterGroupLayoutNode;
import org.eclipse.dd.dsf.debug.ui.viewmodel.register.RegisterLayoutNode;
import org.eclipse.dd.dsf.debug.ui.viewmodel.register.SyncRegisterDataAccess;
import org.eclipse.dd.dsf.debug.ui.viewmodel.variable.SyncVariableDataAccess;
import org.eclipse.dd.dsf.debug.ui.viewmodel.variable.VariableLayoutNode;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMAdapter;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.IVMContext;
import org.eclipse.dd.dsf.ui.viewmodel.IVMLayoutNode;
import org.eclipse.dd.dsf.ui.viewmodel.IVMRootLayoutNode;
import org.eclipse.dd.dsf.ui.viewmodel.dm.DMVMRootLayoutNode;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IExpressionsListener;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentation;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;

public class ExpressionVMProvider
extends AbstractDebugDMVMProviderWithCache
implements IExpressionsListener {
    public ExpressionVMProvider(AbstractVMAdapter adapter, IPresentationContext context, DsfSession session) {
        super(adapter, context, session);
        DebugPlugin.getDefault().getExpressionManager().addExpressionListener((IExpressionsListener)this);
        this.configureLayout();
    }

    protected void configureLayout() {
        SyncRegisterDataAccess syncRegDataAccess = new SyncRegisterDataAccess();
        SyncVariableDataAccess syncvarDataAccess = new SyncVariableDataAccess();
        DMVMRootLayoutNode debugViewSelectionNode = new DMVMRootLayoutNode((AbstractVMProvider)this);
        ExpressionManagerLayoutNode expressionManagerNode = new ExpressionManagerLayoutNode((AbstractVMProvider)this);
        debugViewSelectionNode.setChildNodes(new IVMLayoutNode[]{expressionManagerNode});
        RegisterGroupLayoutNode registerGroupNode = new RegisterGroupLayoutNode((AbstractVMProvider)this, this.getSession(), syncRegDataAccess);
        RegisterLayoutNode registerNode = new RegisterLayoutNode(FormattedValuePreferenceStore.getDefault(), (AbstractVMProvider)this, this.getSession(), syncRegDataAccess);
        registerGroupNode.setChildNodes(new IVMLayoutNode[]{registerNode});
        VariableLayoutNode subExpressioNode = new VariableLayoutNode(FormattedValuePreferenceStore.getDefault(), (AbstractVMProvider)this, this.getSession(), syncvarDataAccess);
        expressionManagerNode.setExpressionLayoutNodes(new IExpressionLayoutNode[]{registerGroupNode, subExpressioNode});
        this.setRootLayoutNode((IVMRootLayoutNode)debugViewSelectionNode);
    }

    public void dispose() {
        DebugPlugin.getDefault().getExpressionManager().removeExpressionListener((IExpressionsListener)this);
        super.dispose();
    }

    public IColumnPresentation createColumnPresentation(IPresentationContext context, Object element) {
        return new ExpressionColumnPresentation();
    }

    public String getColumnPresentationId(IPresentationContext context, Object element) {
        return "org.eclipse.dd.dsf.debug.ui.EXPRESSION_COLUMN_PRESENTATION_ID";
    }

    protected IVMLayoutNode getLayoutNodeForElement(Object element) {
        IVMRootLayoutNode rootLayoutNode = this.getRootLayoutNode();
        if (rootLayoutNode == null) {
            return null;
        }
        if (element.equals(this.getRootElement())) {
            return rootLayoutNode;
        }
        if (element instanceof IVMContext) {
            return ((IVMContext)element).getLayoutNode();
        }
        return null;
    }

    public void expressionsAdded(IExpression[] expressions) {
        this.handleEvent(new ExpressionsChangedEvent(ExpressionsChangedEvent.Type.ADDED, expressions));
    }

    public void expressionsChanged(IExpression[] expressions) {
        this.handleEvent(new ExpressionsChangedEvent(ExpressionsChangedEvent.Type.CHANGED, expressions));
    }

    public void expressionsRemoved(IExpression[] expressions) {
        this.handleEvent(new ExpressionsChangedEvent(ExpressionsChangedEvent.Type.REMOVED, expressions));
    }

    public static class ExpressionsChangedEvent {
        public final Type fType;
        public final IExpression[] fExpressions;

        public ExpressionsChangedEvent(Type type, IExpression[] expressions) {
            this.fType = type;
            this.fExpressions = expressions;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum Type {
            ADDED,
            CHANGED,
            REMOVED;

        }
    }
}

