/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.ui.viewmodel.launch;

import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMLayoutNode;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.IVMContext;
import org.eclipse.dd.dsf.ui.viewmodel.IVMLayoutNode;
import org.eclipse.dd.dsf.ui.viewmodel.VMDelta;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.provisional.ILabelRequestMonitor;
import org.eclipse.jface.viewers.TreePath;

public class StandardProcessLayoutNode
extends AbstractVMLayoutNode {
    public StandardProcessLayoutNode(AbstractVMProvider provider) {
        super(provider);
    }

    public void updateElements(IChildrenUpdate update) {
        ILaunch launch = this.findLaunch(update.getElementPath());
        if (launch == null) {
            assert (false);
            update.done();
            return;
        }
        IProcess[] processes = launch.getProcesses();
        for (int i = 0; i < processes.length; ++i) {
            update.setChild((Object)new VMC(processes[i]), i);
        }
        update.done();
    }

    public void updateElementCount(IChildrenCountUpdate update) {
        ILaunch launch = this.findLaunch(update.getElementPath());
        if (launch == null) {
            assert (false);
            update.setChildCount(0);
            update.done();
            return;
        }
        update.setChildCount(launch.getProcesses().length);
        update.done();
    }

    public void updateHasElements(IHasChildrenUpdate[] updates) {
        for (IHasChildrenUpdate update : updates) {
            ILaunch launch = this.findLaunch(update.getElementPath());
            if (launch == null) {
                assert (false);
                update.setHasChilren(false);
                update.done();
                return;
            }
            update.setHasChilren(launch.getProcesses().length != 0);
            update.done();
        }
    }

    public void updateLabel(IVMContext vmc, ILabelRequestMonitor result, String[] columns) {
        assert (false);
        result.done();
    }

    private ILaunch findLaunch(TreePath path) {
        for (int i = path.getSegmentCount() - 1; i >= 0; --i) {
            if (!(path.getSegment(i) instanceof ILaunch)) continue;
            return (ILaunch)path.getSegment(i);
        }
        return null;
    }

    public int getDeltaFlags(Object e) {
        DebugEvent de;
        int myFlags = 0;
        if (e instanceof DebugEvent && (de = (DebugEvent)e).getSource() instanceof IProcess && (de.getKind() == 16 || de.getKind() == 4 || de.getKind() == 8)) {
            myFlags = 2048;
        }
        return myFlags | super.getDeltaFlags(e);
    }

    public void buildDelta(Object e, VMDelta parent, int nodeOffset, RequestMonitor requestMonitor) {
        if (e instanceof DebugEvent && ((DebugEvent)e).getSource() instanceof IProcess) {
            DebugEvent de = (DebugEvent)e;
            if (de.getKind() == 16) {
                this.handleChange(de, parent);
            } else if (de.getKind() == 4) {
                this.handleCreate(de, parent);
            } else if (de.getKind() == 8) {
                this.handleTerminate(de, parent);
            }
            requestMonitor.done();
        } else {
            super.buildDelta(e, parent, nodeOffset, requestMonitor);
        }
    }

    protected void handleChange(DebugEvent event, VMDelta parent) {
        parent.addNode((Object)new VMC((IProcess)event.getSource()), 2048);
    }

    protected void handleCreate(DebugEvent event, VMDelta parent) {
    }

    protected void handleTerminate(DebugEvent event, VMDelta parent) {
        this.handleChange(event, parent);
    }

    private class VMC
    extends AbstractVMLayoutNode.AbstractVMContext
    implements IProcess {
        private final IProcess fProcess;

        VMC(IProcess process) {
            super(StandardProcessLayoutNode.this.getVMProvider().getVMAdapter(), (IVMLayoutNode)StandardProcessLayoutNode.this);
            this.fProcess = process;
        }

        public IVMLayoutNode getLayoutNode() {
            return StandardProcessLayoutNode.this;
        }

        public Object getAdapter(Class adapter) {
            Object vmcAdapter = super.getAdapter(adapter);
            if (vmcAdapter != null) {
                return vmcAdapter;
            }
            return this.fProcess.getAdapter(adapter);
        }

        public String toString() {
            return "IProcess " + this.fProcess.toString();
        }

        public String getAttribute(String key) {
            return this.fProcess.getAttribute(key);
        }

        public int getExitValue() throws DebugException {
            return this.fProcess.getExitValue();
        }

        public String getLabel() {
            return this.fProcess.getLabel();
        }

        public ILaunch getLaunch() {
            return this.fProcess.getLaunch();
        }

        public IStreamsProxy getStreamsProxy() {
            return this.fProcess.getStreamsProxy();
        }

        public void setAttribute(String key, String value) {
            this.fProcess.setAttribute(key, value);
        }

        public boolean canTerminate() {
            return this.fProcess.canTerminate();
        }

        public boolean isTerminated() {
            return this.fProcess.isTerminated();
        }

        public void terminate() throws DebugException {
            this.fProcess.terminate();
        }

        public boolean equals(Object other) {
            return other instanceof VMC && this.fProcess.equals(((VMC)((Object)other)).fProcess);
        }

        public int hashCode() {
            return this.fProcess.hashCode();
        }
    }
}

