/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.ui.viewmodel.register;

import java.util.concurrent.Executor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMEvent;
import org.eclipse.dd.dsf.datamodel.IDMService;
import org.eclipse.dd.dsf.debug.service.IFormattedValues;
import org.eclipse.dd.dsf.debug.service.IMemory;
import org.eclipse.dd.dsf.debug.service.IRegisters;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.ui.viewmodel.expression.AbstractExpressionLayoutNode;
import org.eclipse.dd.dsf.debug.ui.viewmodel.formatsupport.IFormattedValuePreferenceStore;
import org.eclipse.dd.dsf.debug.ui.viewmodel.formatsupport.IFormattedValueVMContext;
import org.eclipse.dd.dsf.debug.ui.viewmodel.register.RegisterLayoutValueCellModifier;
import org.eclipse.dd.dsf.debug.ui.viewmodel.register.SyncRegisterDataAccess;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.DataRMWithViewerUpdateParent;
import org.eclipse.dd.dsf.ui.viewmodel.IVMContext;
import org.eclipse.dd.dsf.ui.viewmodel.VMDelta;
import org.eclipse.dd.dsf.ui.viewmodel.dm.AbstractDMVMLayoutNode;
import org.eclipse.dd.dsf.ui.viewmodel.update.VMCacheManager;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementEditor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.ui.actions.IWatchExpressionFactoryAdapterExtension;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegisterLayoutNode
extends AbstractExpressionLayoutNode<IRegisters.IRegisterDMData>
implements IElementEditor {
    protected final RegisterExpressionFactory fRegisterExpressionFactory = new RegisterExpressionFactory();
    private final SyncRegisterDataAccess fSyncRegisterDataAccess;
    private final IFormattedValuePreferenceStore fFormattedPrefStore;

    public RegisterLayoutNode(IFormattedValuePreferenceStore prefStore, AbstractVMProvider provider, DsfSession session, SyncRegisterDataAccess syncDataAccess) {
        super(provider, session, IRegisters.IRegisterDMContext.class);
        this.fSyncRegisterDataAccess = syncDataAccess;
        this.fFormattedPrefStore = prefStore;
    }

    protected SyncRegisterDataAccess getSyncRegisterDataAccess() {
        return this.fSyncRegisterDataAccess;
    }

    public IFormattedValuePreferenceStore getPreferenceStore() {
        return this.fFormattedPrefStore;
    }

    private void getFinalFormattedValueForView(final ILabelUpdate update, final IPresentationContext context, final int idx, String prefFormat, String[] formatIds, IRegisters.IRegisterDMContext dmc, IRegisters regService) {
        String finalFormatId = "NATURAL.Format";
        boolean requestedFormatIsSupported = false;
        for (String fId : formatIds) {
            if (!prefFormat.equals(fId)) continue;
            finalFormatId = prefFormat;
            requestedFormatIsSupported = true;
            break;
        }
        if (!requestedFormatIsSupported) {
            if (formatIds.length != 0) {
                finalFormatId = formatIds[0];
            } else {
                this.handleFailedUpdate((IViewerUpdate)update);
                return;
            }
        }
        final IFormattedValues.FormattedValueDMContext valueDmc = regService.getFormattedValue((IFormattedValues.IFormattedDataDMContext)dmc, finalFormatId);
        VMCacheManager.getVMCacheManager().getCache(context).getModelData((IDMService)regService, (IDMContext)valueDmc, (DataRequestMonitor)new DataRMWithViewerUpdateParent<IFormattedValues.FormattedValueDMData>((Executor)this.getSession().getExecutor(), (IViewerUpdate)update){

            public void handleCompleted() {
                if (!this.getStatus().isOK()) {
                    if (this.getStatus().getCode() == 10001) {
                        update.setLabel("...", idx);
                    } else {
                        update.setLabel("Error: " + this.getStatus().getMessage(), idx);
                    }
                    update.setFontData(JFaceResources.getFontDescriptor((String)"org.eclipse.debug.ui.VariableTextFont").getFontData()[0], idx);
                    update.done();
                    return;
                }
                update.setLabel(((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue(), idx);
                IFormattedValues.FormattedValueDMData oldData = (IFormattedValues.FormattedValueDMData)VMCacheManager.getVMCacheManager().getCache(context).getArchivedModelData((IDMContext)valueDmc);
                if (oldData != null && !oldData.getFormattedValue().equals(((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue())) {
                    update.setBackground(DebugUIPlugin.getPreferenceColor((String)"org.eclipse.debug.ui.PREF_CHANGED_VALUE_BACKGROUND").getRGB(), idx);
                }
                update.setFontData(JFaceResources.getFontDescriptor((String)"org.eclipse.debug.ui.VariableTextFont").getFontData()[0], idx);
                update.done();
            }
        }, this.getSession().getExecutor());
    }

    private void updateFormattedRegisterValue(final ILabelUpdate update, final int labelIndex, final IRegisters.IRegisterDMContext dmc) {
        final IRegisters regService = (IRegisters)this.getServicesTracker().getService(IRegisters.class);
        final IPresentationContext context = update.getPresentationContext();
        final String preferencePageFormatId = this.fFormattedPrefStore.getCurrentNumericFormat(context);
        regService.getAvailableFormattedValues((IFormattedValues.IFormattedDataDMContext)dmc, (DataRequestMonitor)new DataRequestMonitor<String[]>((Executor)this.getSession().getExecutor(), null){

            public void handleCompleted() {
                if (!this.getStatus().isOK()) {
                    RegisterLayoutNode.this.handleFailedUpdate((IViewerUpdate)update);
                    return;
                }
                String[] formatIds = (String[])this.getData();
                RegisterLayoutNode.this.getFinalFormattedValueForView(update, context, labelIndex, preferencePageFormatId, formatIds, dmc, regService);
                for (String fId : formatIds) {
                    IFormattedValues.FormattedValueDMContext valueDmc = regService.getFormattedValue((IFormattedValues.IFormattedDataDMContext)dmc, fId);
                    VMCacheManager.getVMCacheManager().getCache(context).getModelData((IDMService)regService, (IDMContext)valueDmc, (DataRequestMonitor)new DataRMWithViewerUpdateParent<IFormattedValues.FormattedValueDMData>((Executor)RegisterLayoutNode.this.getSession().getExecutor(), (IViewerUpdate)update){

                        public void handleCompleted() {
                        }
                    }, RegisterLayoutNode.this.getSession().getExecutor());
                }
            }
        });
    }

    protected void updateLabelInSessionThread(ILabelUpdate[] updates) {
        for (final ILabelUpdate update : updates) {
            final IRegisters.IRegisterDMContext dmc = (IRegisters.IRegisterDMContext)this.findDmcInPath(update.getElementPath(), IRegisters.IRegisterDMContext.class);
            if (!this.checkDmc((IDMContext)dmc, (IViewerUpdate)update) || !this.checkService(null, dmc.getServiceFilter(), (IViewerUpdate)update)) continue;
            VMCacheManager.getVMCacheManager().getCache(update.getPresentationContext()).getModelData((IDMService)this.getServicesTracker().getService(null, dmc.getServiceFilter()), (IDMContext)dmc, (DataRequestMonitor)new DataRequestMonitor<IRegisters.IRegisterDMData>((Executor)this.getSession().getExecutor(), null){

                protected void handleCompleted() {
                    int idx;
                    if (!this.getStatus().isOK()) {
                        assert (this.getStatus().isOK() || this.getStatus().getCode() != 10005 || this.getStatus().getCode() != 10003);
                        String[] localColumns = update.getPresentationContext().getColumns();
                        if (localColumns == null) {
                            localColumns = new String[]{"org.eclipse.dd.dsf.debug.ui.COLUMN_ID__NAME"};
                        }
                        for (int idx2 = 0; idx2 < localColumns.length; ++idx2) {
                            if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__NAME".equals(localColumns[idx2])) {
                                update.setLabel(dmc.getName(), idx2);
                                update.setImageDescriptor(DebugPluginImages.getImageDescriptor((String)"IMG_OBJS_REGISTER"), idx2);
                            } else if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__TYPE".equals(localColumns[idx2])) {
                                update.setLabel("", idx2);
                            } else if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__VALUE".equals(localColumns[idx2])) {
                                if (this.getStatus().getCode() == 10001) {
                                    update.setLabel("...", idx2);
                                } else {
                                    update.setLabel("Error: " + this.getStatus().getMessage(), idx2);
                                }
                            } else if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__DESCRIPTION".equals(localColumns[idx2])) {
                                update.setLabel("...", idx2);
                            } else if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__EXPRESSION".equals(localColumns[idx2])) {
                                update.setLabel("", idx2);
                            }
                            update.setFontData(JFaceResources.getFontDescriptor((String)"org.eclipse.debug.ui.VariableTextFont").getFontData()[0], idx2);
                        }
                        update.done();
                        return;
                    }
                    String[] localColumns = update.getPresentationContext().getColumns();
                    if (localColumns == null) {
                        localColumns = new String[]{"org.eclipse.dd.dsf.debug.ui.COLUMN_ID__NAME"};
                    }
                    boolean weAreExtractingFormattedData = false;
                    for (idx = 0; idx < localColumns.length; ++idx) {
                        update.setFontData(JFaceResources.getFontDescriptor((String)"org.eclipse.debug.ui.VariableTextFont").getFontData()[0], idx);
                        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__NAME".equals(localColumns[idx])) {
                            update.setLabel(((IRegisters.IRegisterDMData)this.getData()).getName(), idx);
                            update.setImageDescriptor(DebugPluginImages.getImageDescriptor((String)"IMG_OBJS_REGISTER"), idx);
                            continue;
                        }
                        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__VALUE".equals(localColumns[idx])) {
                            weAreExtractingFormattedData = true;
                            continue;
                        }
                        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__TYPE".equals(localColumns[idx])) {
                            IRegisters.IRegisterDMData data = (IRegisters.IRegisterDMData)this.getData();
                            String typeStr = "Unsigned";
                            String ReadAttrStr = "ReadNone";
                            String WriteAddrStr = "WriteNone";
                            if (data.isFloat()) {
                                typeStr = "Floating Point";
                            }
                            if (data.isReadOnce()) {
                                ReadAttrStr = "ReadOnce";
                            } else if (data.isReadable()) {
                                ReadAttrStr = "Readable";
                            }
                            if (data.isReadOnce()) {
                                WriteAddrStr = "WriteOnce";
                            } else if (data.isReadable()) {
                                WriteAddrStr = "Writeable";
                            }
                            typeStr = typeStr + " - " + ReadAttrStr + "/" + WriteAddrStr;
                            update.setLabel(typeStr, idx);
                            continue;
                        }
                        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__DESCRIPTION".equals(localColumns[idx])) {
                            update.setLabel(((IRegisters.IRegisterDMData)this.getData()).getDescription(), idx);
                            continue;
                        }
                        if (!"org.eclipse.dd.dsf.debug.ui.COLUMN_ID__EXPRESSION".equals(localColumns[idx])) continue;
                        IVMContext vmc = (IVMContext)update.getElement();
                        IExpression expression = (IExpression)vmc.getAdapter(IExpression.class);
                        if (expression != null) {
                            update.setLabel(expression.getExpressionText(), idx);
                            continue;
                        }
                        update.setLabel(((IRegisters.IRegisterDMData)this.getData()).getName(), idx);
                    }
                    if (!weAreExtractingFormattedData) {
                        update.done();
                    } else {
                        for (idx = 0; idx < localColumns.length; ++idx) {
                            if (!"org.eclipse.dd.dsf.debug.ui.COLUMN_ID__VALUE".equals(localColumns[idx])) continue;
                            RegisterLayoutNode.this.updateFormattedRegisterValue(update, idx, dmc);
                        }
                    }
                }
            }, this.getSession().getExecutor());
        }
    }

    protected void updateElementsInSessionThread(final IChildrenUpdate update) {
        IRegisters.IRegisterGroupDMContext execDmc = (IRegisters.IRegisterGroupDMContext)this.findDmcInPath(update.getElementPath(), IRegisters.IRegisterGroupDMContext.class);
        if (execDmc == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        ((IRegisters)this.getServicesTracker().getService(IRegisters.class)).getRegisters((IDMContext)execDmc, (DataRequestMonitor)new DataRMWithViewerUpdateParent<IRegisters.IRegisterDMContext[]>((Executor)this.getSession().getExecutor(), (IViewerUpdate)update){

            public void handleCompleted() {
                if (!this.getStatus().isOK()) {
                    RegisterLayoutNode.this.handleFailedUpdate((IViewerUpdate)update);
                    return;
                }
                RegisterLayoutNode.this.fillUpdateWithVMCs(update, (IDMContext[])this.getData());
                update.done();
            }
        });
    }

    protected IVMContext createVMContext(IDMContext<IRegisters.IRegisterDMData> dmc) {
        return new RegisterVMC(dmc);
    }

    protected int getNodeDeltaFlagsForDMEvent(IDMEvent<?> e) {
        if (e instanceof IRegisters.IRegistersChangedDMEvent) {
            VMCacheManager.getVMCacheManager().flush(super.getVMProvider().getPresentationContext(), e.getDMContext(), false);
            return 1024;
        }
        if (e instanceof IRegisters.IRegisterChangedDMEvent) {
            VMCacheManager.getVMCacheManager().flush(super.getVMProvider().getPresentationContext(), e.getDMContext(), false);
            return 3072;
        }
        if (e instanceof IMemory.IMemoryChangedDMEvent) {
            VMCacheManager.getVMCacheManager().flush(super.getVMProvider().getPresentationContext(), e.getDMContext(), false);
            return 1024;
        }
        return 0;
    }

    protected void buildDeltaForDMEvent(IDMEvent<?> e, VMDelta parent, int nodeOffset, RequestMonitor rm) {
        if (e instanceof IRegisters.IRegistersChangedDMEvent) {
            parent.addFlags(1024);
        }
        if (e instanceof IRegisters.IRegisterChangedDMEvent) {
            parent.addNode((Object)this.createVMContext((IDMContext<IRegisters.IRegisterDMData>)((IRegisters.IRegisterChangedDMEvent)e).getDMContext()), 3072);
        }
        if (e instanceof IMemory.IMemoryChangedDMEvent) {
            parent.addFlags(1024);
        }
        super.buildDeltaForDMEvent(e, parent, nodeOffset, rm);
    }

    private boolean testValidCharInName(char chr) {
        if (Character.isLetterOrDigit(chr)) {
            return true;
        }
        return chr == '_';
    }

    @Override
    public int getExpressionLength(String expression) {
        int length;
        if (!expression.startsWith(".Register(")) {
            return -1;
        }
        int startIdx = ".Register(".length();
        int endIdx = expression.indexOf(41, startIdx);
        String regname = expression.substring(startIdx, endIdx);
        int surround_length = ".Register(".length() + ")".length();
        boolean ok = true;
        for (length = 0; length < regname.length(); ++length) {
            if (this.testValidCharInName(regname.charAt(length))) continue;
            ok = false;
            break;
        }
        if (!ok) {
            return -1;
        }
        return surround_length + length;
    }

    @Override
    protected void testContextForExpression(Object element, String expression, DataRequestMonitor<Boolean> rm) {
        int endIdx;
        if (!(element instanceof AbstractDMVMLayoutNode.DMVMContext)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10002, "Invalid context", null));
            rm.done();
            return;
        }
        IRegisters.IRegisterDMContext dmc = (IRegisters.IRegisterDMContext)DMContexts.getAncestorOfType((IDMContext)((AbstractDMVMLayoutNode.DMVMContext)element).getDMC(), IRegisters.IRegisterDMContext.class);
        if (dmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10002, "Invalid context", null));
            rm.done();
            return;
        }
        int startIdx = ".Register(".length();
        String regName = expression.substring(startIdx, endIdx = expression.indexOf(41, startIdx));
        if (regName.equals(dmc.getName())) {
            rm.setData((Object)Boolean.TRUE);
        } else {
            rm.setData((Object)Boolean.FALSE);
        }
        rm.done();
    }

    @Override
    protected void associateExpression(Object element, IExpression expression) {
        if (element instanceof RegisterVMC) {
            ((RegisterVMC)element).setExpression(expression);
        }
    }

    @Override
    protected int getDeltaFlagsForExpressionPart(Object event) {
        if (event instanceof IRunControl.ISuspendedDMEvent) {
            return 1024;
        }
        if (event instanceof IMemory.IMemoryChangedDMEvent) {
            return 1024;
        }
        return 0;
    }

    @Override
    public void buildDeltaForExpression(IExpression expression, int elementIdx, String expressionText, Object event, VMDelta parentDelta, TreePath path, RequestMonitor rm) {
        if (event instanceof IRunControl.ISuspendedDMEvent) {
            parentDelta.addFlags(1024);
        }
        if (event instanceof IMemory.IMemoryChangedDMEvent) {
            parentDelta.addFlags(1024);
        }
        super.buildDeltaForExpression(expression, elementIdx, expressionText, event, parentDelta, path, rm);
    }

    @Override
    protected void buildDeltaForExpressionElement(Object element, int elementIdx, Object event, VMDelta parentDelta, RequestMonitor rm) {
        if (event instanceof IRegisters.IRegisterChangedDMEvent) {
            parentDelta.addNode(element, 2048);
        }
        if (event instanceof IRegisters.IRegistersChangedDMEvent) {
            parentDelta.addNode(element, 2048);
        }
        if (event instanceof IMemory.IMemoryChangedDMEvent) {
            parentDelta.addNode(element, 1024);
        }
        super.buildDeltaForExpressionElement(element, elementIdx, event, parentDelta, rm);
    }

    public CellEditor getCellEditor(IPresentationContext context, String columnId, Object element, Composite parent) {
        IRegisters.IRegisterDMData regData;
        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__EXPRESSION".equals(columnId)) {
            return new TextCellEditor(parent);
        }
        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__VALUE".equals(columnId) && (regData = this.fSyncRegisterDataAccess.readRegister(element)) != null && regData.isWriteable()) {
            return new TextCellEditor(parent);
        }
        return null;
    }

    public ICellModifier getCellModifier(IPresentationContext context, Object element) {
        return new RegisterLayoutValueCellModifier(this.fFormattedPrefStore, this.fSyncRegisterDataAccess);
    }

    protected class RegisterExpressionFactory
    implements IWatchExpressionFactoryAdapterExtension {
        protected RegisterExpressionFactory() {
        }

        public boolean canCreateWatchExpression(IVariable variable) {
            return variable instanceof RegisterVMC;
        }

        public String createWatchExpression(IVariable variable) throws CoreException {
            IRegisters.IRegisterDMContext registerDmc;
            RegisterVMC registerVmc = (RegisterVMC)variable;
            StringBuffer exprBuf = new StringBuffer();
            IRegisters.IRegisterGroupDMContext groupDmc = (IRegisters.IRegisterGroupDMContext)DMContexts.getAncestorOfType((IDMContext)registerVmc.getDMC(), IRegisters.IRegisterGroupDMContext.class);
            if (groupDmc != null) {
                exprBuf.append("Group(");
                exprBuf.append(groupDmc.getName());
                exprBuf.append(')');
            }
            if ((registerDmc = (IRegisters.IRegisterDMContext)DMContexts.getAncestorOfType((IDMContext)registerVmc.getDMC(), IRegisters.IRegisterDMContext.class)) != null) {
                exprBuf.append(".Register(");
                exprBuf.append(registerDmc.getName());
                exprBuf.append(')');
                return exprBuf.toString();
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RegisterVMC
    extends AbstractDMVMLayoutNode.DMVMContext
    implements IVariable,
    IFormattedValueVMContext {
        private IExpression fExpression;

        public RegisterVMC(IDMContext<?> dmc) {
            super((AbstractDMVMLayoutNode)RegisterLayoutNode.this, dmc);
        }

        public void setExpression(IExpression expression) {
            this.fExpression = expression;
        }

        public Object getAdapter(Class adapter) {
            if (this.fExpression != null && adapter.isAssignableFrom(this.fExpression.getClass())) {
                return this.fExpression;
            }
            if (adapter.isAssignableFrom(IWatchExpressionFactoryAdapterExtension.class)) {
                return RegisterLayoutNode.this.fRegisterExpressionFactory;
            }
            return super.getAdapter(adapter);
        }

        public boolean equals(Object other) {
            if (other instanceof RegisterVMC && super.equals(other)) {
                RegisterVMC otherReg = (RegisterVMC)other;
                return otherReg.fExpression == null && this.fExpression == null || otherReg.fExpression != null && otherReg.fExpression.equals(this.fExpression);
            }
            return false;
        }

        public int hashCode() {
            return super.hashCode() + (this.fExpression != null ? this.fExpression.hashCode() : 0);
        }

        @Override
        public IFormattedValuePreferenceStore getPreferenceStore() {
            return RegisterLayoutNode.this.fFormattedPrefStore;
        }

        public String getName() throws DebugException {
            return this.toString();
        }

        public String getReferenceTypeName() throws DebugException {
            return "";
        }

        public IValue getValue() throws DebugException {
            return null;
        }

        public boolean hasValueChanged() throws DebugException {
            return false;
        }

        public void setValue(IValue value) throws DebugException {
        }

        public void setValue(String expression) throws DebugException {
        }

        public boolean supportsValueModification() {
            return false;
        }

        public boolean verifyValue(IValue value) throws DebugException {
            return false;
        }

        public boolean verifyValue(String expression) throws DebugException {
            return false;
        }

        public IDebugTarget getDebugTarget() {
            return null;
        }

        public ILaunch getLaunch() {
            return null;
        }

        public String getModelIdentifier() {
            return "org.eclipse.dd.dsf.debug.ui";
        }
    }
}

