/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.ui.viewmodel;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DefaultDsfExecutor;
import org.eclipse.dd.dsf.concurrent.DsfExecutor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.ThreadSafe;
import org.eclipse.dd.dsf.ui.viewmodel.IVMAdapter;
import org.eclipse.dd.dsf.ui.viewmodel.IVMProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentation;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;

@ThreadSafe
public abstract class AbstractVMAdapter
implements IVMAdapter {
    private final DsfExecutor fExecutor;
    private boolean fDisposed;
    private final Map<IPresentationContext, IVMProvider> fViewModelProviders = Collections.synchronizedMap(new HashMap());

    public AbstractVMAdapter() {
        this.fExecutor = new DefaultDsfExecutor();
    }

    public DsfExecutor getExecutor() {
        return this.fExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ThreadSafe
    public IVMProvider getVMProvider(IPresentationContext context) {
        Map<IPresentationContext, IVMProvider> map = this.fViewModelProviders;
        synchronized (map) {
            if (this.fDisposed) {
                return null;
            }
            IVMProvider provider = this.fViewModelProviders.get(context);
            if (provider == null && (provider = this.createViewModelProvider(context)) != null) {
                this.fViewModelProviders.put(context, provider);
            }
            return provider;
        }
    }

    public void dispose() {
        this.getExecutor().execute((Runnable)new DsfRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Map map = AbstractVMAdapter.this.fViewModelProviders;
                synchronized (map) {
                    AbstractVMAdapter.this.fDisposed = true;
                    for (IVMProvider provider : AbstractVMAdapter.this.fViewModelProviders.values()) {
                        provider.dispose();
                    }
                    AbstractVMAdapter.this.fViewModelProviders.clear();
                }
                AbstractVMAdapter.this.fExecutor.shutdown();
            }
        });
    }

    public void update(IHasChildrenUpdate[] updates) {
        this.handleUpdates((IViewerUpdate[])updates);
    }

    public void update(IChildrenCountUpdate[] updates) {
        this.handleUpdates((IViewerUpdate[])updates);
    }

    public void update(IChildrenUpdate[] updates) {
        this.handleUpdates((IViewerUpdate[])updates);
    }

    private void handleUpdates(final IViewerUpdate[] updates) {
        try {
            this.getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    IPresentationContext context = null;
                    int firstIdx = 0;
                    int curIdx = 0;
                    for (curIdx = 0; curIdx < updates.length; ++curIdx) {
                        if (updates[curIdx].getPresentationContext().equals(context)) continue;
                        if (context != null) {
                            AbstractVMAdapter.this.callProviderWithUpdate(updates, firstIdx, curIdx);
                        }
                        context = updates[curIdx].getPresentationContext();
                        firstIdx = curIdx;
                    }
                    AbstractVMAdapter.this.callProviderWithUpdate(updates, firstIdx, curIdx);
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    private void callProviderWithUpdate(IViewerUpdate[] updates, int startIdx, int endIdx) {
        IVMProvider provider = this.getVMProvider(updates[0].getPresentationContext());
        if (provider == null) {
            for (IViewerUpdate update : updates) {
                update.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.ui", 10005, "No model provider for update " + update, null));
                update.done();
            }
            return;
        }
        if (startIdx == 0 && endIdx == updates.length) {
            if (updates instanceof IHasChildrenUpdate[]) {
                provider.update((IHasChildrenUpdate[])updates);
            } else if (updates instanceof IChildrenCountUpdate[]) {
                provider.update((IChildrenCountUpdate[])updates);
            } else if (updates instanceof IChildrenUpdate[]) {
                provider.update((IChildrenUpdate[])updates);
            }
        } else if (updates instanceof IHasChildrenUpdate[]) {
            IHasChildrenUpdate[] providerUpdates = new IHasChildrenUpdate[endIdx - startIdx];
            System.arraycopy(updates, startIdx, providerUpdates, 0, endIdx - startIdx);
            provider.update(providerUpdates);
        } else if (updates instanceof IChildrenCountUpdate[]) {
            IChildrenCountUpdate[] providerUpdates = new IChildrenCountUpdate[endIdx - startIdx];
            System.arraycopy(updates, startIdx, providerUpdates, 0, endIdx - startIdx);
            provider.update(providerUpdates);
        } else if (updates instanceof IChildrenUpdate[]) {
            IChildrenUpdate[] providerUpdates = new IChildrenUpdate[endIdx - startIdx];
            System.arraycopy(updates, startIdx, providerUpdates, 0, endIdx - startIdx);
            provider.update(providerUpdates);
        }
    }

    public IModelProxy createModelProxy(Object element, IPresentationContext context) {
        IVMProvider provider = this.getVMProvider(context);
        if (provider != null) {
            return provider.createModelProxy(element, context);
        }
        return null;
    }

    public IColumnPresentation createColumnPresentation(IPresentationContext context, Object element) {
        IVMProvider provider = this.getVMProvider(context);
        if (provider != null) {
            return provider.createColumnPresentation(context, element);
        }
        return null;
    }

    public String getColumnPresentationId(IPresentationContext context, Object element) {
        IVMProvider provider = this.getVMProvider(context);
        if (provider != null) {
            return provider.getColumnPresentationId(context, element);
        }
        return null;
    }

    @ThreadSafe
    protected abstract IVMProvider createViewModelProvider(IPresentationContext var1);
}

