/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.ui.viewmodel.update;

import java.util.HashMap;
import java.util.Vector;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMEvent;
import org.eclipse.dd.dsf.ui.viewmodel.update.VMCache;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VMCacheManager {
    private static VMCacheManager fInstance = null;
    private HashMap<IPresentationContext, VMCache> fAssociations = new HashMap();
    private HashMap<IPresentationContext, Class<?>> fAssociationHistory = new HashMap();
    private HashMap<Object, Vector<CacheListener>> fListeners = new HashMap();

    public static VMCacheManager getVMCacheManager() {
        if (fInstance == null) {
            fInstance = new VMCacheManager();
        }
        return fInstance;
    }

    public VMCache getCache(IPresentationContext context) {
        if (!this.fAssociations.containsKey(context)) {
            this.fAssociations.put(context, new VMCache(){

                public void handleEvent(IDMEvent event) {
                }

                protected boolean isCacheEnabled() {
                    return false;
                }
            });
        }
        return this.fAssociations.get(context);
    }

    public Class<?> getAssociatedCacheClass(Object context) {
        return this.fAssociationHistory.get(context);
    }

    public void registerCache(IPresentationContext context, VMCache cache) {
        VMCache oldCache = this.fAssociations.get(context);
        if (oldCache != null) {
            oldCache.dispose();
        }
        this.fAssociations.put(context, cache);
        this.fAssociationHistory.put(context, cache.getClass());
    }

    public VMCache createCache(Class<?> cacheClass) {
        try {
            return (VMCache)cacheClass.newInstance();
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException iae) {
            return null;
        }
    }

    public void addCacheListener(IPresentationContext context, CacheListener listener) {
        if (!this.fListeners.containsKey(context)) {
            this.fListeners.put(context, new Vector());
        }
        this.fListeners.get(context).addElement(listener);
    }

    public void removeCacheListener(IPresentationContext context, CacheListener listener) {
        if (this.fListeners.containsKey(context)) {
            this.fListeners.get(context).removeElement(listener);
            if (this.fListeners.get(context).isEmpty()) {
                this.fListeners.remove(context);
            }
        }
    }

    private void fireCacheFlushed(IPresentationContext context, IDMContext<?> dmc) {
        if (this.fListeners.containsKey(context)) {
            for (CacheListener listener : this.fListeners.get(context)) {
                listener.cacheFlushed(context);
            }
        }
    }

    public void flush(IPresentationContext context, IDMContext<?> dmc, boolean archive) {
        this.getCache(context).flush(dmc, archive);
        this.fireCacheFlushed(context, dmc);
    }

    public static interface CacheListener {
        public void cacheFlushed(Object var1);
    }
}

