/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.core.output;

import org.eclipse.dd.dsf.mi.core.output.DsfMIConst;
import org.eclipse.dd.dsf.mi.core.output.DsfMIInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfMIList;
import org.eclipse.dd.dsf.mi.core.output.DsfMIOutput;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResult;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResultRecord;
import org.eclipse.dd.dsf.mi.core.output.DsfMITuple;
import org.eclipse.dd.dsf.mi.core.output.DsfMIValue;
import org.eclipse.debug.core.model.MemoryByte;

public class DsfMIDataReadMemoryInfo
extends DsfMIInfo {
    String fAddress;
    long fBytesRequested;
    long fBytesRead;
    MemoryByte[] fMemoryBlock = null;

    public DsfMIDataReadMemoryInfo(DsfMIOutput output) {
        super(output);
        if (this.isDone()) {
            this.fMemoryBlock = this.parseResult();
        }
        if (this.fMemoryBlock == null) {
            this.fMemoryBlock = new MemoryByte[0];
        }
    }

    private MemoryByte[] parseResult() {
        MemoryByte[] block = null;
        DsfMIOutput output = this.getMIOutput();
        DsfMIResultRecord record = output.getMIResultRecord();
        if (record != null) {
            DsfMIResult[] results = record.getMIResults();
            for (int i = 0; i < results.length; ++i) {
                DsfMIValue value;
                String var = results[i].getVariable();
                if (!var.equals("memory") || !((value = results[i].getMIValue()) instanceof DsfMIList)) continue;
                block = this.parseMemoryLine((DsfMIList)value);
            }
        }
        if (block == null) {
            block = new MemoryByte[]{};
        }
        return block;
    }

    private MemoryByte[] parseMemoryLine(DsfMIList lines) {
        MemoryByte[] block = null;
        DsfMIValue[] values = lines.getMIValues();
        for (int i = 0; i < values.length; ++i) {
            int j;
            DsfMITuple tuple;
            DsfMIResult[] results;
            DsfMIValue value;
            if (!(values[i] instanceof DsfMITuple) || !((value = (results = (tuple = (DsfMITuple)values[i]).getMIResults())[1].getMIValue()) instanceof DsfMIList)) continue;
            DsfMIList list = (DsfMIList)value;
            DsfMIValue[] bytes = list.getMIValues();
            MemoryByte[] line = new MemoryByte[bytes.length];
            for (int j2 = 0; j2 < bytes.length; ++j2) {
                if (!(bytes[j2] instanceof DsfMIConst)) continue;
                String str = ((DsfMIConst)bytes[j2]).getCString();
                try {
                    line[j2] = new MemoryByte((byte)(Long.decode(str.trim()) % 256L));
                    continue;
                }
                catch (NumberFormatException e) {
                    line[j2] = new MemoryByte(-1);
                }
            }
            if (block == null) {
                block = line;
                continue;
            }
            int length1 = block.length;
            int length2 = line.length;
            MemoryByte[] temp = new MemoryByte[length1 + length2];
            for (j = 0; j < length1; ++j) {
                temp[j] = block[j];
            }
            for (j = 0; j < length2; ++j) {
                temp[length1 + j] = line[j];
            }
            block = temp;
        }
        if (block == null) {
            block = new MemoryByte[]{};
        }
        return block;
    }

    public MemoryByte[] getMIMemoryBlock() {
        return this.fMemoryBlock;
    }
}

