/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.event;

import org.eclipse.dd.dsf.mi.core.output.DsfMIConst;
import org.eclipse.dd.dsf.mi.core.output.DsfMILogStreamOutput;
import org.eclipse.dd.dsf.mi.core.output.DsfMIOOBRecord;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResult;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResultRecord;
import org.eclipse.dd.dsf.mi.core.output.DsfMIStreamRecord;
import org.eclipse.dd.dsf.mi.core.output.DsfMIValue;
import org.eclipse.dd.dsf.mi.event.DsfMIStoppedEvent;

public class DsfMIErrorEvent
extends DsfMIStoppedEvent {
    private static final long serialVersionUID = -5025665750946415281L;
    String msg = "";
    String log = "";
    DsfMIOOBRecord[] oobs;

    public DsfMIErrorEvent(DsfMIResultRecord rr, DsfMIOOBRecord[] o) {
        super(rr);
        this.oobs = o;
        this.parse();
    }

    public String getMessage() {
        return this.msg;
    }

    public String getLogMessage() {
        return this.log;
    }

    void parse() {
        DsfMIResultRecord rr = this.getMIResultRecord();
        if (rr != null) {
            DsfMIResult[] results = rr.getMIResults();
            if (results != null) {
                for (int i = 0; i < results.length; ++i) {
                    String var = results[i].getVariable();
                    DsfMIValue value = results[i].getMIValue();
                    String str = "";
                    if (value instanceof DsfMIConst) {
                        str = ((DsfMIConst)value).getString();
                    }
                    if (!var.equals("msg")) continue;
                    this.msg = str;
                }
            }
            if (this.oobs != null) {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < this.oobs.length; ++i) {
                    if (!(this.oobs[i] instanceof DsfMILogStreamOutput)) continue;
                    DsfMIStreamRecord o = (DsfMIStreamRecord)this.oobs[i];
                    sb.append(o.getString());
                }
                this.log = sb.toString();
            }
        }
    }
}

