/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.event;

import org.eclipse.dd.dsf.mi.core.output.DsfMIConst;
import org.eclipse.dd.dsf.mi.core.output.DsfMIExecAsyncOutput;
import org.eclipse.dd.dsf.mi.core.output.DsfMIFrame;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResult;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResultRecord;
import org.eclipse.dd.dsf.mi.core.output.DsfMITuple;
import org.eclipse.dd.dsf.mi.core.output.DsfMIValue;
import org.eclipse.dd.dsf.mi.event.DsfMIEvent;

public class DsfMIStoppedEvent
extends DsfMIEvent {
    private static final long serialVersionUID = -2004951520025480922L;
    private int threadId;
    private DsfMIFrame frame;
    private DsfMIExecAsyncOutput exec;
    private DsfMIResultRecord rr;

    public DsfMIStoppedEvent(DsfMIExecAsyncOutput record) {
        super(record.getToken());
        this.exec = record;
        this.parse();
    }

    public DsfMIStoppedEvent(DsfMIResultRecord record) {
        super(record.getToken());
        this.rr = record;
        this.parse();
    }

    public int getThreadId() {
        return this.threadId;
    }

    public void setThreadId(int id) {
        this.threadId = id;
    }

    public DsfMIFrame getFrame() {
        return this.frame;
    }

    public void setFrame(DsfMIFrame f) {
        this.frame = f;
    }

    public DsfMIExecAsyncOutput getMIExecAsyncOutput() {
        return this.exec;
    }

    public DsfMIResultRecord getMIResultRecord() {
        return this.rr;
    }

    void parse() {
        DsfMIResult[] results = null;
        if (this.exec != null) {
            results = this.exec.getMIResults();
        } else if (this.rr != null) {
            results = this.rr.getMIResults();
        }
        if (results != null) {
            for (int i = 0; i < results.length; ++i) {
                String var = results[i].getVariable();
                DsfMIValue value = results[i].getMIValue();
                if (var.equals("thread-id")) {
                    if (!(value instanceof DsfMIConst)) continue;
                    String str = ((DsfMIConst)value).getString();
                    try {
                        this.threadId = Integer.parseInt(str.trim());
                    }
                    catch (NumberFormatException e) {}
                    continue;
                }
                if (!var.equals("frame") || !(value instanceof DsfMITuple)) continue;
                this.frame = new DsfMIFrame((DsfMITuple)value);
            }
        }
    }
}

