/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.service;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.AbstractDMContext;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMData;
import org.eclipse.dd.dsf.datamodel.IDMService;
import org.eclipse.dd.dsf.datamodel.ServiceDMContext;
import org.eclipse.dd.dsf.debug.service.IExpressions;
import org.eclipse.dd.dsf.debug.service.IFormattedValues;
import org.eclipse.dd.dsf.debug.service.IRegisters;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.IStack;
import org.eclipse.dd.dsf.debug.service.command.ICommandControl;
import org.eclipse.dd.dsf.mi.DsfMIPlugin;
import org.eclipse.dd.dsf.mi.core.command.DsfMIVarEvaluateExpression;
import org.eclipse.dd.dsf.mi.core.command.DsfMIVarListChildren;
import org.eclipse.dd.dsf.mi.core.command.DsfMIVarUpdate;
import org.eclipse.dd.dsf.mi.core.output.DsfMIVar;
import org.eclipse.dd.dsf.mi.core.output.DsfMIVarEvaluateExpressionInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfMIVarListChildrenInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfMIVarUpdateInfo;
import org.eclipse.dd.dsf.mi.service.MIRunControl;
import org.eclipse.dd.dsf.mi.service.MIStack;
import org.eclipse.dd.dsf.mi.service.MIVariableManager;
import org.eclipse.dd.dsf.mi.service.control.MICommandCache;
import org.eclipse.dd.dsf.service.AbstractDsfService;
import org.eclipse.dd.dsf.service.DsfServiceEventHandler;
import org.eclipse.dd.dsf.service.DsfSession;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionService
extends AbstractDsfService
implements IExpressions {
    private IDMContext<ExpressionService> fServiceDMC;
    private MIRunControl fRunControl;
    private MICommandCache fExpressionCache;
    private MIVariableManager varManager;

    private void doInitialize(RequestMonitor requestMonitor) {
        this.fServiceDMC = new ServiceDMContext((IDMService)this, "#expression");
        this.fRunControl = (MIRunControl)this.getServicesTracker().getService(MIRunControl.class);
        this.getSession().addServiceEventListener((Object)this, null);
        this.fExpressionCache = new MICommandCache((ICommandControl)this.getServicesTracker().getService(ICommandControl.class));
        this.varManager = new MIVariableManager(this.getExecutor(), (ICommandControl)this.getServicesTracker().getService(ICommandControl.class));
        this.register(new String[]{IExpressions.class.getName(), ExpressionService.class.getName()}, new Hashtable());
        requestMonitor.done();
    }

    private void getExpressionValue(final ExpressionDMC dmc, final DataRequestMonitor<IExpressions.IExpressionDMData> rm) {
        DataRequestMonitor<MIVariableManager.MIVariableObject> createCallback = new DataRequestMonitor<MIVariableManager.MIVariableObject>((Executor)this.getExecutor(), rm){

            protected void handleOK() {
                rm.setData((Object)new ExpressionDMData(dmc.getExpression(), ((MIVariableManager.MIVariableObject)this.getData()).getType()));
                rm.done();
            }
        };
        this.varManager.createVariable((IDMContext<?>)dmc, createCallback);
    }

    private void createFormattedExpressionValue(IFormattedValues.FormattedValueDMContext dmc, final DataRequestMonitor<IFormattedValues.FormattedValueDMData> rm) {
        final MIStack.MIFrameDMC frameDmc = (MIStack.MIFrameDMC)DMContexts.getAncestorOfType((IDMContext)dmc, MIStack.MIFrameDMC.class);
        if (frameDmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "MIFrameContext not found", null));
            rm.done();
            return;
        }
        this.varManager.createVariable((IDMContext<?>)dmc, new DataRequestMonitor<MIVariableManager.MIVariableObject>((Executor)this.getExecutor(), rm){

            protected void handleOK() {
                final String varName = ((MIVariableManager.MIVariableObject)this.getData()).getName();
                ExpressionService.this.fExpressionCache.execute(new DsfMIVarUpdate(frameDmc, varName), new DataRequestMonitor<DsfMIVarUpdateInfo>((Executor)ExpressionService.this.getExecutor(), (RequestMonitor)rm){

                    protected void handleOK() {
                        ExpressionService.this.fExpressionCache.execute(new DsfMIVarEvaluateExpression(frameDmc, varName), new DataRequestMonitor<DsfMIVarEvaluateExpressionInfo>((Executor)ExpressionService.this.getExecutor(), (RequestMonitor)rm){

                            protected void handleOK() {
                                rm.setData((Object)new IFormattedValues.FormattedValueDMData(((DsfMIVarEvaluateExpressionInfo)this.getData()).getValue()));
                                rm.done();
                            }
                        });
                    }
                });
            }
        });
    }

    public ExpressionService(DsfSession session) {
        super(session);
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

            protected void handleOK() {
                ExpressionService.this.doInitialize(requestMonitor);
            }
        });
    }

    public void shutdown(RequestMonitor requestMonitor) {
        this.unregister();
        this.getSession().removeServiceEventListener((Object)this);
        super.shutdown(requestMonitor);
    }

    public <V extends IDMData> void getModelData(IDMContext<V> dmc, DataRequestMonitor<V> rm) {
        if (dmc instanceof ExpressionDMC) {
            this.getExpressionValue((ExpressionDMC)dmc, rm);
        } else if (dmc == this.fServiceDMC) {
            rm.setData((Object)this);
            rm.done();
        } else if (dmc instanceof IFormattedValues.FormattedValueDMContext) {
            this.createFormattedExpressionValue((IFormattedValues.FormattedValueDMContext)dmc, rm);
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Unknown DMC type", null));
            rm.done();
        }
    }

    protected BundleContext getBundleContext() {
        return DsfMIPlugin.getBundleContext();
    }

    public IDMContext<?> getServiceContext() {
        return this.fServiceDMC;
    }

    public boolean isValid() {
        return true;
    }

    public IExpressions.IExpressionDMContext createExpression(IDMContext<?> ctx, String expression) {
        IStack.IFrameDMContext frameDmc = (IStack.IFrameDMContext)DMContexts.getAncestorOfType(ctx, IStack.IFrameDMContext.class);
        return new ExpressionDMC(this, expression, expression, frameDmc);
    }

    public void getBaseExpressions(IExpressions.IExpressionDMContext exprContext, DataRequestMonitor<IExpressions.IExpressionDMContext[]> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10003, "Not supported", null));
        rm.done();
    }

    public String createQualifiedExpression(MIVariableManager.MIVariableObject varObj, String innerExpression) {
        String typeName = varObj.getType();
        if (typeName.endsWith("]")) {
            return varObj.getExpression() + "[" + innerExpression + "]";
        }
        if (typeName.startsWith("class") || typeName.startsWith("struct") || typeName.startsWith("union")) {
            return varObj.getExpression() + "." + innerExpression;
        }
        return innerExpression;
    }

    public void getSubExpressions(IExpressions.IExpressionDMContext exprCtx, final DataRequestMonitor<Iterable<IExpressions.IExpressionDMContext>> rm) {
        final MIStack.MIFrameDMC frameDmc = (MIStack.MIFrameDMC)DMContexts.getAncestorOfType((IDMContext)exprCtx, MIStack.MIFrameDMC.class);
        if (frameDmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "MIFrameContext not found", null));
            rm.done();
            return;
        }
        DataRequestMonitor<MIVariableManager.MIVariableObject> createCallback = new DataRequestMonitor<MIVariableManager.MIVariableObject>((Executor)this.getExecutor(), rm){

            protected void handleOK() {
                final MIVariableManager.MIVariableObject varObj = (MIVariableManager.MIVariableObject)this.getData();
                DataRequestMonitor<DsfMIVarListChildrenInfo> varEvalExpressionCallback = new DataRequestMonitor<DsfMIVarListChildrenInfo>((Executor)ExpressionService.this.getExecutor(), (RequestMonitor)rm){

                    protected void handleOK() {
                        DsfMIVar[] dsfVars;
                        ArrayList<ExpressionDMC> varList = new ArrayList<ExpressionDMC>();
                        for (DsfMIVar var : dsfVars = ((DsfMIVarListChildrenInfo)this.getData()).getMIVars()) {
                            varList.add(new ExpressionDMC(ExpressionService.this, var.getExp(), ExpressionService.this.createQualifiedExpression(varObj, var.getExp()), frameDmc));
                        }
                        rm.setData(varList);
                        rm.done();
                    }
                };
                DsfMIVarListChildren varEval = new DsfMIVarListChildren(frameDmc, ((MIVariableManager.MIVariableObject)this.getData()).getName());
                ExpressionService.this.fExpressionCache.execute(varEval, varEvalExpressionCallback);
            }

            public synchronized void done() {
                this.handleCompleted();
            }
        };
        this.varManager.createVariable((IDMContext<?>)exprCtx, createCallback);
    }

    public void getAvailableFormattedValues(IFormattedValues.IFormattedDataDMContext<?> dmc, DataRequestMonitor<String[]> rm) {
        rm.setData((Object)new String[]{"BINARY.Format", "NATURAL.Format", "HEX.Format", "OCTAL.Format", "DECIMAL.Format"});
        rm.done();
    }

    public IFormattedValues.FormattedValueDMContext getFormattedValue(IFormattedValues.IFormattedDataDMContext<?> dmc, String formatId) {
        return new IFormattedValues.FormattedValueDMContext((IDMService)this, dmc, formatId);
    }

    public void writeExpression(IDMContext<?> expressionContext, String exressionValue, String formatId, RequestMonitor rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10003, "Not supported", null));
        rm.done();
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IResumedDMEvent e) {
        this.fExpressionCache.setTargetAvailable(false);
        if (e.getReason() != IRunControl.StateChangeReason.STEP) {
            this.fExpressionCache.reset();
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.ISuspendedDMEvent e) {
        this.fExpressionCache.setTargetAvailable(true);
        this.fExpressionCache.reset();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExpressionDMC
    extends AbstractDMContext<IExpressions.IExpressionDMData>
    implements IExpressions.IExpressionDMContext {
        private final String expression;
        private final String qualifiedExpression;
        private final IDMContext<?> parentCtx;

        public ExpressionDMC(ExpressionService service, String expression, String qualifiedExpression, IStack.IFrameDMContext frameDmc) {
            super(service.getSession().getId(), service.getServiceFilter(), new IDMContext[]{frameDmc, service.getServiceContext()});
            this.expression = expression;
            this.qualifiedExpression = qualifiedExpression;
            this.parentCtx = frameDmc;
        }

        public boolean equals(Object other) {
            if (super.baseEquals(other)) {
                return this.expression.equals(((ExpressionDMC)((Object)other)).getExpression()) && this.qualifiedExpression.equals(((ExpressionDMC)((Object)other)).getQualifiedExpression()) && this.parentCtx.equals(((ExpressionDMC)((Object)other)).parentCtx);
            }
            return false;
        }

        public int hashCode() {
            return super.baseHashCode() ^ this.expression.hashCode();
        }

        public String toString() {
            return this.baseToString() + ".expr[" + this.expression + "]";
        }

        public String getExpression() {
            return this.expression;
        }

        public String getQualifiedExpression() {
            return this.qualifiedExpression;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExpressionDMData
    implements IExpressions.IExpressionDMData {
        private final String varName;
        private final String type;

        public ExpressionDMData(String varName, String type) {
            this.varName = varName;
            this.type = type;
        }

        public IAddress getAddress() {
            return null;
        }

        public IExpressions.IExpressionDMData.BasicType getBasicType() {
            return null;
        }

        public int getBitCount() {
            return 0;
        }

        public String getEncoding() {
            return null;
        }

        public Map<String, Integer> getEnumerations() {
            return null;
        }

        public String getName() {
            return this.varName;
        }

        public IRegisters.IRegisterDMContext getRegister() {
            return null;
        }

        public String getStringValue() {
            return null;
        }

        public String getTypeId() {
            return null;
        }

        public String getTypeName() {
            return this.type;
        }

        public long getArrayLength() {
            return -1L;
        }

        public long getArrayStart() {
            return 0L;
        }

        public Iterator<String> getFields() {
            return null;
        }

        public boolean isValid() {
            return true;
        }
    }
}

