/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.service;

import java.math.BigInteger;
import java.util.Hashtable;
import java.util.concurrent.Executor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.IMemory;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.command.ICommandControl;
import org.eclipse.dd.dsf.mi.DsfMIPlugin;
import org.eclipse.dd.dsf.mi.core.command.DsfMIDataReadMemory;
import org.eclipse.dd.dsf.mi.core.command.DsfMIDataWriteMemory;
import org.eclipse.dd.dsf.mi.core.output.DsfMIDataReadMemoryInfo;
import org.eclipse.dd.dsf.mi.service.MIRunControl;
import org.eclipse.dd.dsf.mi.service.control.MICommandCache;
import org.eclipse.dd.dsf.service.AbstractDsfService;
import org.eclipse.dd.dsf.service.DsfServiceEventHandler;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.debug.core.model.MemoryByte;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIMemory
extends AbstractDsfService
implements IMemory {
    private MIRunControl fRunControl;
    private MICommandCache fMemoryRequestsCache;

    public MIMemory(DsfSession session) {
        super(session);
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

            protected void handleOK() {
                MIMemory.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.register(new String[]{MIMemory.class.getName(), IMemory.class.getName()}, new Hashtable());
        this.fRunControl = (MIRunControl)this.getServicesTracker().getService(MIRunControl.class);
        this.fMemoryRequestsCache = new MICommandCache((ICommandControl)this.getServicesTracker().getService(ICommandControl.class));
        this.getSession().addServiceEventListener((Object)this, null);
        requestMonitor.done();
    }

    public void shutdown(RequestMonitor requestMonitor) {
        this.unregister();
        this.getSession().removeServiceEventListener((Object)this);
        this.fMemoryRequestsCache.reset();
        super.shutdown(requestMonitor);
    }

    protected BundleContext getBundleContext() {
        return DsfMIPlugin.getBundleContext();
    }

    public void getMemory(IDMContext<?> ctx, BigInteger address, int word_size, MemoryByte[] buffer, int offset, int size, int mode, RequestMonitor rm) {
        IRunControl.IContainerDMContext containerDmc = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType(ctx, IRunControl.IContainerDMContext.class);
        if (containerDmc != null) {
            this.getMemoryBlockFromCache(address, word_size, buffer, offset, size, mode, rm);
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Unknown DMC type", null));
            rm.done();
        }
    }

    public void setMemory(IDMContext<?> ctx, BigInteger address, int word_size, byte[] buffer, int offset, int size, int mode, RequestMonitor rm) {
        IRunControl.IContainerDMContext containerDmc = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType(ctx, IRunControl.IContainerDMContext.class);
        if (containerDmc != null) {
            this.writeMemoryBlock(address, word_size, buffer, offset, mode, rm);
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Unknown DMC type", null));
            rm.done();
        }
    }

    public void fillMemory(IDMContext<?> ctx, BigInteger address, int word_size, byte[] buffer, int size, int mode, RequestMonitor rm) {
        IRunControl.IContainerDMContext containerDmc = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType(ctx, IRunControl.IContainerDMContext.class);
        if (containerDmc != null) {
            this.writeMemoryBlock(address, word_size, buffer, 0L, mode, rm);
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Unknown DMC type", null));
            rm.done();
        }
    }

    private void getMemoryBlockFromCache(BigInteger address, int word_size, final MemoryByte[] buffer, final int offset, final int size, int mode, final RequestMonitor rm) {
        mode = 0;
        int nb_rows = 1;
        int nb_cols = size;
        Character asChar = null;
        this.fMemoryRequestsCache.execute(new DsfMIDataReadMemory(offset, address.toString(), mode, word_size, nb_rows, nb_cols, asChar), new DataRequestMonitor<DsfMIDataReadMemoryInfo>((Executor)this.getExecutor(), rm){

            protected void handleOK() {
                MemoryByte[] memoryBlock = ((DsfMIDataReadMemoryInfo)this.getData()).getMIMemoryBlock();
                for (int i = 0; i < size; ++i) {
                    buffer[i + offset] = new MemoryByte(memoryBlock[i].getValue(), memoryBlock[i].getFlags());
                }
                rm.done();
            }
        });
    }

    private void writeMemoryBlock(final BigInteger address, int word_size, final byte[] buffer, final long offset, int mode, final RequestMonitor rm) {
        CountingRequestMonitor countingRM = new CountingRequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleOK() {
                for (int i = 0; i < buffer.length; ++i) {
                    MIMemory.this.getSession().dispatchEvent((Object)new IMemory.MemoryChangedEvent(address.add(BigInteger.valueOf(offset + (long)i))), MIMemory.this.getProperties());
                }
                rm.done();
            }
        };
        countingRM.setCount(buffer.length);
        if (buffer.length == 0) {
            countingRM.done();
        }
        mode = 3;
        String baseAddress = address.toString();
        for (int i = 0; i < buffer.length; ++i) {
            String value = new Byte(buffer[i]).toString();
            this.fMemoryRequestsCache.execute(new DsfMIDataWriteMemory(offset + (long)i, baseAddress, mode, word_size, value), new DataRequestMonitor((Executor)this.getExecutor(), (RequestMonitor)countingRM));
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IResumedDMEvent e) {
        this.fMemoryRequestsCache.setTargetAvailable(false);
        if (e.getReason() != IRunControl.StateChangeReason.STEP) {
            this.fMemoryRequestsCache.reset();
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.ISuspendedDMEvent e) {
        this.fMemoryRequestsCache.setTargetAvailable(true);
        this.fMemoryRequestsCache.reset();
    }

    @DsfServiceEventHandler
    public void eventDispatched(IMemory.MemoryChangedEvent e) {
        this.fMemoryRequestsCache.reset();
    }
}

