/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.service;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Stack;
import java.util.concurrent.Executor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfExecutor;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.IExpressions;
import org.eclipse.dd.dsf.debug.service.IFormattedValues;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.debug.service.command.ICommandControl;
import org.eclipse.dd.dsf.mi.core.command.DsfMIVarCreate;
import org.eclipse.dd.dsf.mi.core.command.DsfMIVarDelete;
import org.eclipse.dd.dsf.mi.core.command.DsfMIVarSetFormat;
import org.eclipse.dd.dsf.mi.core.output.DsfMIInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfMIVarCreateInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfMIVarDeleteInfo;
import org.eclipse.dd.dsf.mi.service.MIStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIVariableManager
implements Observer {
    ICommandControl commandControl;
    LRUVariableCache lruVariableList = new LRUVariableCache(this);
    DsfExecutor executor;

    public MIVariableManager(DsfExecutor executor, ICommandControl commandControl) {
        this.commandControl = commandControl;
        this.executor = executor;
    }

    public void createVariable(IDMContext<?> dmc, DataRequestMonitor<MIVariableObject> rm) {
        String formatId = "NATURAL.Format";
        IFormattedValues.FormattedValueDMContext frmtCxt = (IFormattedValues.FormattedValueDMContext)DMContexts.getAncestorOfType(dmc, IFormattedValues.FormattedValueDMContext.class);
        if (frmtCxt != null) {
            formatId = frmtCxt.getFormatID();
        }
        this.createVariable(dmc, formatId, rm);
    }

    private void createVariable(IDMContext<?> dmc, final String formatId, DataRequestMonitor<MIVariableObject> rm) {
        final MIStack.MIFrameDMC frameDmc = (MIStack.MIFrameDMC)DMContexts.getAncestorOfType(dmc, MIStack.MIFrameDMC.class);
        if (frameDmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Frame dmc is not found", null));
            rm.done();
            return;
        }
        final String exprId = this.generateUniqueMIVarName(dmc, formatId);
        IExpressions.IExpressionDMContext exprCxt = (IExpressions.IExpressionDMContext)DMContexts.getAncestorOfType(dmc, IExpressions.IExpressionDMContext.class);
        if (exprCxt == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Expression dmc is not found", null));
            rm.done();
            return;
        }
        MIVariableObject varObj = (MIVariableObject)this.lruVariableList.get(exprId);
        if (varObj != null) {
            varObj.addVarListener(new VariableObserver(rm));
            return;
        }
        varObj = new MIVariableObject(exprId, exprCxt.getExpression());
        varObj.addVarListener(new VariableObserver(rm));
        this.lruVariableList.put(exprId, varObj);
        final MIVariableObject finVarObj = varObj;
        DataRequestMonitor<DsfMIVarCreateInfo> varCreateCallback = new DataRequestMonitor<DsfMIVarCreateInfo>((Executor)this.executor, null){

            protected void handleOK() {
                finVarObj.setType(((DsfMIVarCreateInfo)this.getData()).getType());
                finVarObj.setChildren(((DsfMIVarCreateInfo)this.getData()).getNumChildren());
                DataRequestMonitor<DsfMIInfo> varSetFormatCallback = new DataRequestMonitor<DsfMIInfo>((Executor)MIVariableManager.this.executor, null){

                    protected void handleOK() {
                        finVarObj.done();
                    }
                };
                DsfMIVarSetFormat varSetFormat = new DsfMIVarSetFormat(frameDmc, exprId, formatId);
                MIVariableManager.this.commandControl.queueCommand((ICommand)varSetFormat, (DataRequestMonitor)varSetFormatCallback);
            }
        };
        DsfMIVarCreate varCreateCmd = new DsfMIVarCreate(frameDmc, exprId, exprCxt.getQualifiedExpression());
        this.commandControl.queueCommand((ICommand)varCreateCmd, (DataRequestMonitor)varCreateCallback);
    }

    private String generateUniqueMIVarName(IDMContext<?> dmc, String formatId) {
        IExpressions.IExpressionDMContext exprCtx = (IExpressions.IExpressionDMContext)DMContexts.getAncestorOfType(dmc, IExpressions.IExpressionDMContext.class);
        String expressionId = "fs";
        if (exprCtx != null) {
            expressionId = exprCtx.getQualifiedExpression().replaceAll(" ", "").trim();
        }
        return "expr_" + expressionId + "_" + formatId;
    }

    public void clear() {
    }

    public void getExpressionValue() {
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof MIVariableObject) {
            MIVariableObject varOjb = (MIVariableObject)arg;
            DataRequestMonitor<DsfMIVarDeleteInfo> varDeleteCallback = new DataRequestMonitor<DsfMIVarDeleteInfo>((Executor)this.executor, null){

                protected void handleOK() {
                }
            };
            DsfMIVarDelete varDelete = new DsfMIVarDelete(varOjb.getName());
            this.commandControl.queueCommand((ICommand)varDelete, (DataRequestMonitor)varDeleteCallback);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LRUVariableCache
    extends LinkedHashMap<String, MIVariableObject> {
        public static final long serialVersionUID = 0L;
        private static final int MAX_VAIRABLE_LIST = 1000;
        private Observer deleteObserver;

        public LRUVariableCache(Observer deleteObserver) {
            super(0, 0.75f, true);
            this.deleteObserver = deleteObserver;
        }

        @Override
        public boolean removeEldestEntry(Map.Entry<String, MIVariableObject> eldest) {
            return eldest.getValue().currentState == MIVariableObject.VarState.DONE && this.size() > 1000;
        }

        public MIVariableObject remove(String key) {
            MIVariableObject varObj = (MIVariableObject)super.remove(key);
            this.deleteObserver.update(null, varObj);
            return varObj;
        }
    }

    public static class MIVariableObject {
        private String varName;
        private String type;
        private String expression;
        private int numChildren;
        private VarState currentState = VarState.PENDING;
        private Stack<VariableObserver> pendingRequests;

        public MIVariableObject(String varName, String expression) {
            this.varName = varName;
            this.expression = expression;
            this.type = "Invalid";
            this.numChildren = 0;
            this.pendingRequests = new Stack();
        }

        public int getChildren() {
            return this.numChildren;
        }

        public String getName() {
            return this.varName;
        }

        public String getExpression() {
            return this.expression;
        }

        public String getType() {
            return this.type;
        }

        public void setChildren(int numChildren) {
            this.numChildren = numChildren;
        }

        public void setType(String type) {
            this.type = type;
        }

        public synchronized void addVarListener(VariableObserver pndNotify) {
            if (this.currentState == VarState.DONE) {
                pndNotify.update(null, this);
            } else {
                this.pendingRequests.add(pndNotify);
            }
        }

        public synchronized void done() {
            this.currentState = VarState.DONE;
            while (this.pendingRequests.size() > 0) {
                this.pendingRequests.pop().update(null, this);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum VarState {
            PENDING,
            DONE,
            USED;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VariableObserver
    implements Observer {
        DataRequestMonitor<MIVariableObject> drMonitor;

        public VariableObserver(DataRequestMonitor<MIVariableObject> drMonitor) {
            this.drMonitor = drMonitor;
        }

        @Override
        public void update(Observable o, Object arg) {
            if (arg instanceof MIVariableObject) {
                this.drMonitor.setData((Object)((MIVariableObject)arg));
                this.drMonitor.done();
            }
        }
    }
}

