/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.service.control;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.debug.service.command.ICommandControl;
import org.eclipse.dd.dsf.debug.service.command.ICommandListener;
import org.eclipse.dd.dsf.debug.service.command.ICommandResult;
import org.eclipse.dd.dsf.debug.service.command.IEventListener;
import org.eclipse.dd.dsf.mi.DsfMIPlugin;
import org.eclipse.dd.dsf.mi.core.command.DsfMICommand;
import org.eclipse.dd.dsf.mi.core.command.DsfMIStackSelectFrame;
import org.eclipse.dd.dsf.mi.core.command.DsfMIThreadSelect;
import org.eclipse.dd.dsf.mi.core.output.DsfMIConst;
import org.eclipse.dd.dsf.mi.core.output.DsfMIInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfMIList;
import org.eclipse.dd.dsf.mi.core.output.DsfMIOOBRecord;
import org.eclipse.dd.dsf.mi.core.output.DsfMIOutput;
import org.eclipse.dd.dsf.mi.core.output.DsfMIParser;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResult;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResultRecord;
import org.eclipse.dd.dsf.mi.core.output.DsfMIValue;
import org.eclipse.dd.dsf.mi.service.MIRunControl;
import org.eclipse.dd.dsf.mi.service.MIStack;
import org.eclipse.dd.dsf.service.AbstractDsfService;
import org.eclipse.dd.dsf.service.DsfSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMIControl
extends AbstractDsfService
implements ICommandControl {
    private TxThread fTxThread;
    private RxThread fRxThread;
    private int fCurrentStackLevel = -1;
    private int fCurrentThreadId = -1;
    private final BlockingQueue<CommandHandle> fTxCommands = new LinkedBlockingQueue<CommandHandle>();
    private final Map<Integer, CommandHandle> fRxCommands = Collections.synchronizedMap(new HashMap());
    private final List<ICommandListener> fCommandProcessors = new ArrayList<ICommandListener>();
    private final List<IEventListener> fEventProcessors = new ArrayList<IEventListener>();
    private final List<CommandHandle> fCommandQueue = new ArrayList<CommandHandle>();
    private static int globalCounter = 0;

    public AbstractMIControl(DsfSession session) {
        super(session);
    }

    protected void startCommandProcessing(InputStream inStream, OutputStream outStream) {
        this.fTxThread = new TxThread(outStream);
        this.fRxThread = new RxThread(inStream);
        this.fTxThread.start();
        this.fRxThread.start();
    }

    private Status genStatus(String str) {
        return new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10001, str, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopCommandProcessing() {
        for (CommandHandle commandHandle : this.fCommandQueue) {
            if (commandHandle.getRequestMonitor() == null) continue;
            commandHandle.getRequestMonitor().setStatus((IStatus)this.genStatus("Connection is shut down"));
            commandHandle.getRequestMonitor().done();
        }
        Map<Integer, CommandHandle> i$ = this.fRxCommands;
        synchronized (i$) {
            for (CommandHandle commandHandle : this.fRxCommands.values()) {
                if (commandHandle.getRequestMonitor() == null) continue;
                commandHandle.getRequestMonitor().setStatus((IStatus)this.genStatus("Connection is shut down"));
                commandHandle.getRequestMonitor().done();
            }
            this.fRxCommands.clear();
        }
        ArrayList txCommands = new ArrayList();
        this.fTxCommands.drainTo(txCommands);
        for (CommandHandle commandHandle : txCommands) {
            if (commandHandle.getRequestMonitor() == null) continue;
            commandHandle.getRequestMonitor().setStatus((IStatus)this.genStatus("Connection is shut down"));
            commandHandle.getRequestMonitor().done();
        }
    }

    public <V extends ICommandResult> void queueCommand(ICommand<V> command, DataRequestMonitor<V> rm) {
        DsfMICommand miCommand = (DsfMICommand)command;
        DataRequestMonitor<V> miDone = rm;
        CommandHandle handle = new CommandHandle(miCommand, miDone);
        if (this.fRxCommands.size() > 3) {
            this.fCommandQueue.add(handle);
            this.processCommandQueued(handle);
        } else {
            this.fCommandQueue.add(handle);
            this.processCommandQueued(handle);
            if (this.fCommandQueue.remove(handle)) {
                CommandHandle cmdHandle;
                this.processCommandSent(handle);
                if (handle.getThreadId() != null && handle.getThreadId() != this.fCurrentThreadId && handle.getThreadId() != 0) {
                    this.fCurrentThreadId = handle.getThreadId();
                    cmdHandle = new CommandHandle(new DsfMIThreadSelect(this.fCurrentThreadId), null);
                    this.fTxCommands.add(cmdHandle);
                }
                if (handle.getStackFrameId() != null && handle.getStackFrameId() != this.fCurrentStackLevel) {
                    this.fCurrentStackLevel = handle.getStackFrameId();
                    cmdHandle = new CommandHandle(new DsfMIStackSelectFrame(this.fCurrentStackLevel), null);
                    this.fTxCommands.add(cmdHandle);
                }
                this.fTxCommands.add(handle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCommand(ICommand<? extends ICommandResult> command) {
        List<CommandHandle> list = this.fCommandQueue;
        synchronized (list) {
            for (CommandHandle handle : this.fCommandQueue) {
                if (!handle.getCommand().equals(command)) continue;
                this.fCommandQueue.remove(handle);
                final CommandHandle finalHandle = handle;
                this.getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        AbstractMIControl.this.processCommandRemoved(finalHandle);
                    }
                });
                break;
            }
        }
    }

    public void cancelCommand(ICommand<? extends ICommandResult> command) {
    }

    public void addCommandListener(ICommandListener processor) {
        this.fCommandProcessors.add(processor);
    }

    public void removeCommandListener(ICommandListener processor) {
        this.fCommandProcessors.remove(processor);
    }

    public void addEventListener(IEventListener processor) {
        this.fEventProcessors.add(processor);
    }

    public void removeEventListener(IEventListener processor) {
        this.fEventProcessors.remove(processor);
    }

    private void processCommandQueued(CommandHandle commandHandle) {
        for (ICommandListener processor : this.fCommandProcessors) {
            processor.commandQueued(commandHandle.getCommand());
        }
    }

    private void processCommandRemoved(CommandHandle commandHandle) {
        for (ICommandListener processor : this.fCommandProcessors) {
            processor.commandRemoved(commandHandle.getCommand());
        }
    }

    private void processCommandSent(CommandHandle commandHandle) {
        DsfMIPlugin.debug(DsfMIPlugin.getDebugTime() + " " + commandHandle.getToken() + commandHandle.getCommand());
        for (ICommandListener processor : this.fCommandProcessors) {
            processor.commandSent(commandHandle.getCommand());
        }
    }

    private void processCommandDone(CommandHandle commandHandle, ICommandResult result) {
        if (result != null) {
            DsfMIInfo cmdResult = (DsfMIInfo)result;
            DsfMIOutput output = cmdResult.getMIOutput();
            DsfMIPlugin.debug(DsfMIPlugin.getDebugTime() + " " + output + "\n");
        } else {
            DsfMIPlugin.debug(DsfMIPlugin.getDebugTime() + " result output not available\n");
        }
        for (ICommandListener processor : this.fCommandProcessors) {
            processor.commandDone(commandHandle == null ? null : commandHandle.getCommand(), result);
        }
    }

    private void processEvent(DsfMIOutput output) {
        DsfMIPlugin.debug(DsfMIPlugin.getDebugTime() + " " + output + "\n");
        for (IEventListener processor : this.fEventProcessors) {
            processor.eventReceived((Object)output);
        }
    }

    private static synchronized int getUniqToken() {
        int count;
        if ((count = ++globalCounter) <= 0) {
            globalCounter = 1;
            count = 1;
        }
        return count;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RxThread
    extends Thread {
        private final InputStream fInputStream;
        private final DsfMIParser fMiParser;
        private final List<DsfMIOOBRecord> fAccumulatedOOBRecords;

        public RxThread(InputStream inputStream) {
            super("MI RX Thread");
            this.fMiParser = new DsfMIParser();
            this.fAccumulatedOOBRecords = new ArrayList<DsfMIOOBRecord>();
            this.fInputStream = inputStream;
        }

        @Override
        public void run() {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.fInputStream));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.length() == 0) continue;
                    this.processMIOutput(line);
                }
            }
            catch (IOException e) {
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }

        private DsfMIResult findResultRecord(DsfMIResult[] results, String variable) {
            for (int i = 0; i < results.length; ++i) {
                if (!variable.equals(results[i].getVariable())) continue;
                return results[i];
            }
            return null;
        }

        private String getStatusString(DsfMICommand<DsfMIInfo> origCommand, DsfMIOutput response) {
            String message = null;
            String[] parameters = null;
            if (response != null && response.getMIResultRecord() != null) {
                DsfMIResult messageRes;
                DsfMIResult[] results = response.getMIResultRecord().getMIResults();
                DsfMIResult paramsRes = this.findResultRecord(results, "parameters");
                if (paramsRes != null && paramsRes.getMIValue() instanceof DsfMIList) {
                    DsfMIValue[] paramValues = ((DsfMIList)paramsRes.getMIValue()).getMIValues();
                    parameters = new String[paramValues.length];
                    for (int i = 0; i < paramValues.length; ++i) {
                        parameters[i] = paramValues[i] instanceof DsfMIConst ? ((DsfMIConst)paramValues[i]).getString() : "";
                    }
                }
                if ((messageRes = this.findResultRecord(results, "message")) != null && messageRes.getMIValue() instanceof DsfMIConst) {
                    message = ((DsfMIConst)messageRes.getMIValue()).getString();
                }
            }
            StringBuilder clientMsg = new StringBuilder();
            clientMsg.append("Failed to execute MI command:\n");
            clientMsg.append(origCommand.toString());
            if (message != null) {
                clientMsg.append("Error message from debugger back end:\n");
                if (parameters != null) {
                    try {
                        clientMsg.append(MessageFormat.format(message, parameters));
                    }
                    catch (IllegalArgumentException e2) {
                        clientMsg.append(message);
                        clientMsg.append(parameters);
                    }
                } else {
                    clientMsg.append(message);
                }
            }
            return clientMsg.toString();
        }

        void processMIOutput(String line) {
            DsfMIParser.RecordType recordType = this.fMiParser.getRecordType(line);
            if (recordType == DsfMIParser.RecordType.ResultRecord) {
                DsfMIResultRecord rr = this.fMiParser.parseMIResultRecord(line);
                final DsfMIOutput response = new DsfMIOutput(rr, this.fAccumulatedOOBRecords.toArray(new DsfMIOOBRecord[this.fAccumulatedOOBRecords.size()]));
                this.fAccumulatedOOBRecords.clear();
                int id = rr.getToken();
                final CommandHandle commandHandle = (CommandHandle)AbstractMIControl.this.fRxCommands.remove(id);
                if (commandHandle != null) {
                    DsfMIInfo result = commandHandle.getCommand().getResult(response);
                    DataRequestMonitor<DsfMIInfo> rm = commandHandle.getRequestMonitor();
                    if (rm != null) {
                        rm.setData((Object)result);
                        String errorResult = rr.getResultClass();
                        if (errorResult.equals("error")) {
                            String status = this.getStatusString(commandHandle.getCommand(), response);
                            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, status, null));
                        }
                        final DsfMIInfo finalResult = result;
                        AbstractMIControl.this.getExecutor().execute((Runnable)new DsfRunnable(){

                            public void run() {
                                if (commandHandle.getRequestMonitor() != null) {
                                    commandHandle.getRequestMonitor().done();
                                }
                                AbstractMIControl.this.processCommandDone(commandHandle, finalResult);
                            }

                            public String toString() {
                                return "MI command output received for: " + commandHandle.getCommand();
                            }
                        });
                    } else {
                        final DsfMIInfo finalResult = result;
                        AbstractMIControl.this.getExecutor().execute((Runnable)new DsfRunnable(){

                            public void run() {
                                AbstractMIControl.this.processCommandDone(commandHandle, finalResult);
                            }

                            public String toString() {
                                return "MI command output received for: " + commandHandle.getCommand();
                            }
                        });
                    }
                } else {
                    AbstractMIControl.this.getExecutor().execute((Runnable)new DsfRunnable(){

                        public void run() {
                            AbstractMIControl.this.processEvent(response);
                        }

                        public String toString() {
                            return "MI asynchronous output received: " + response;
                        }
                    });
                }
            } else if (recordType == DsfMIParser.RecordType.OOBRecord) {
                DsfMIOOBRecord oob = this.fMiParser.parseMIOOBRecord(line);
                this.fAccumulatedOOBRecords.add(oob);
                final DsfMIOutput response = new DsfMIOutput(oob);
                AbstractMIControl.this.getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        AbstractMIControl.this.processEvent(response);
                    }

                    public String toString() {
                        return "MI asynchronous output received: " + response;
                    }
                });
            }
            AbstractMIControl.this.getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    CommandHandle comHandle;
                    if (AbstractMIControl.this.fCommandQueue.size() > 0 && (comHandle = (CommandHandle)AbstractMIControl.this.fCommandQueue.remove(0)) != null) {
                        AbstractMIControl.this.processCommandQueued(comHandle);
                        AbstractMIControl.this.processCommandSent(comHandle);
                        AbstractMIControl.this.fTxCommands.add(comHandle);
                    }
                }
            });
        }
    }

    private class TxThread
    extends Thread {
        private final OutputStream fOutputStream;

        public TxThread(OutputStream outStream) {
            super("MI TX Thread");
            this.fOutputStream = outStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                CommandHandle commandHandle = null;
                BlockingQueue blockingQueue = AbstractMIControl.this.fTxCommands;
                synchronized (blockingQueue) {
                    try {
                        commandHandle = (CommandHandle)AbstractMIControl.this.fTxCommands.take();
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    if (commandHandle == null) {
                        break;
                    }
                    AbstractMIControl.this.fRxCommands.put(commandHandle.getToken(), commandHandle);
                }
                String str = commandHandle.getToken() + commandHandle.getCommand().constructCommand();
                try {
                    if (this.fOutputStream == null) continue;
                    this.fOutputStream.write(str.getBytes());
                    this.fOutputStream.flush();
                }
                catch (IOException e) {
                    break;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CommandHandle {
        private DsfMICommand<DsfMIInfo> fCommand;
        private DataRequestMonitor<DsfMIInfo> fRequestMonitor;
        private int fTokenId;

        CommandHandle(DsfMICommand<DsfMIInfo> c, DataRequestMonitor<DsfMIInfo> d) {
            this.fCommand = c;
            this.fRequestMonitor = d;
            this.fTokenId = AbstractMIControl.getUniqToken();
        }

        public DsfMICommand<DsfMIInfo> getCommand() {
            return this.fCommand;
        }

        public DataRequestMonitor<DsfMIInfo> getRequestMonitor() {
            return this.fRequestMonitor;
        }

        public Integer getToken() {
            return this.fTokenId;
        }

        public Integer getStackFrameId() {
            MIStack.MIFrameDMC frameCtx = (MIStack.MIFrameDMC)DMContexts.getAncestorOfType(this.fCommand.getContext(), MIStack.MIFrameDMC.class);
            if (frameCtx != null) {
                return frameCtx.getLevel();
            }
            return null;
        }

        public Integer getThreadId() {
            MIRunControl.MIExecutionDMC execCtx = (MIRunControl.MIExecutionDMC)DMContexts.getAncestorOfType(this.fCommand.getContext(), MIRunControl.MIExecutionDMC.class);
            if (execCtx != null) {
                return execCtx.getThreadId();
            }
            return null;
        }
    }
}

