/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.model;

import java.math.BigInteger;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.Query;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.debug.model.DsfMemoryBlockRetrieval;
import org.eclipse.dd.dsf.debug.service.IMemory;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.service.DsfServiceEventHandler;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.MemoryByte;

public class DsfMemoryBlock
extends PlatformObject
implements IMemoryBlockExtension {
    private final DsfMemoryBlockRetrieval fRetrieval;
    private final String fModelId;
    private final String fExpression;
    private final BigInteger fStartAddress;
    private BigInteger fEndAddress;
    private long fLength = 0L;

    DsfMemoryBlock(DsfMemoryBlockRetrieval retrieval, String modelId, String expression, BigInteger startAddress, long length) {
        this.fRetrieval = retrieval;
        this.fModelId = modelId;
        this.fExpression = expression;
        this.fStartAddress = startAddress;
        this.fEndAddress = startAddress.add(BigInteger.valueOf(length));
        this.fLength = length;
        try {
            this.fRetrieval.getExecutor().execute(new Runnable(){

                public void run() {
                    DsfMemoryBlock.this.fRetrieval.getSession().addServiceEventListener((Object)DsfMemoryBlock.this, null);
                }
            });
        }
        catch (RejectedExecutionException e) {
            // empty catch block
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(DsfMemoryBlockRetrieval.class)) {
            return this.fRetrieval;
        }
        return super.getAdapter(adapter);
    }

    public IDebugTarget getDebugTarget() {
        return null;
    }

    public String getModelIdentifier() {
        return this.fModelId;
    }

    public ILaunch getLaunch() {
        return null;
    }

    public long getStartAddress() {
        long address = this.fStartAddress.longValue();
        if (this.fStartAddress.equals(BigInteger.valueOf(address))) {
            return address;
        }
        return 0L;
    }

    public long getLength() {
        return this.fLength;
    }

    public byte[] getBytes() throws DebugException {
        byte[] bytes;
        MemoryByte[] block = this.fetchMemoryBlock(this.fStartAddress, this.fLength);
        int length = block.length;
        for (byte i : bytes = new byte[length]) {
            bytes[i] = block[i].getValue();
        }
        return bytes;
    }

    public boolean supportsValueModification() {
        return true;
    }

    public void setValue(long offset, byte[] bytes) throws DebugException {
        if (offset <= Integer.MAX_VALUE) {
            this.writeMemoryBlock((int)offset, bytes);
        }
    }

    public String getExpression() {
        return this.fExpression;
    }

    public BigInteger getBigBaseAddress() throws DebugException {
        return this.fStartAddress;
    }

    public BigInteger getMemoryBlockStartAddress() throws DebugException {
        return null;
    }

    public BigInteger getMemoryBlockEndAddress() throws DebugException {
        return null;
    }

    public BigInteger getBigLength() throws DebugException {
        return BigInteger.ONE.negate();
    }

    public int getAddressSize() throws DebugException {
        return 4;
    }

    public boolean supportBaseAddressModification() throws DebugException {
        return false;
    }

    public boolean supportsChangeManagement() {
        return false;
    }

    public void setBaseAddress(BigInteger address) throws DebugException {
    }

    public MemoryByte[] getBytesFromOffset(BigInteger offset, long units) throws DebugException {
        return this.getBytesFromAddress(this.fStartAddress.add(offset), units);
    }

    public MemoryByte[] getBytesFromAddress(BigInteger address, long units) throws DebugException {
        this.fLength = units;
        this.fEndAddress = this.fStartAddress.add(BigInteger.valueOf(units));
        return this.fetchMemoryBlock(address, units);
    }

    public void setValue(BigInteger offset, byte[] bytes) throws DebugException {
        int offs = offset.intValue();
        if (offset.equals(BigInteger.valueOf(offs))) {
            this.writeMemoryBlock(offs, bytes);
        }
    }

    public void connect(Object client) {
    }

    public void disconnect(Object client) {
    }

    public Object[] getConnections() {
        return new Object[0];
    }

    public void dispose() throws DebugException {
        try {
            this.fRetrieval.getExecutor().execute(new Runnable(){

                public void run() {
                    DsfMemoryBlock.this.fRetrieval.getSession().removeServiceEventListener((Object)DsfMemoryBlock.this);
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    public IMemoryBlockRetrieval getMemoryBlockRetrieval() {
        return this.fRetrieval;
    }

    public int getAddressableSize() throws DebugException {
        return 1;
    }

    private MemoryByte[] fetchMemoryBlock(final BigInteger address, final long length) throws DebugException {
        boolean word_size = true;
        boolean offset = false;
        boolean mode = false;
        Query<MemoryByte[]> query = new Query<MemoryByte[]>(){

            protected void execute(DataRequestMonitor<MemoryByte[]> rm) {
                IMemory memoryService = (IMemory)DsfMemoryBlock.this.fRetrieval.getServiceTracker().getService();
                if (memoryService != null) {
                    MemoryByte[] buffer = new MemoryByte[(int)length];
                    memoryService.getMemory(DsfMemoryBlock.this.fRetrieval.getContext(), address, 1, buffer, 0, (int)length, 0, new RequestMonitor((Executor)DsfMemoryBlock.this.fRetrieval.getExecutor(), (RequestMonitor)rm, (DataRequestMonitor)rm, buffer){
                        final /* synthetic */ DataRequestMonitor val$rm;
                        final /* synthetic */ MemoryByte[] val$buffer;
                        {
                            this.val$rm = dataRequestMonitor;
                            this.val$buffer = memoryByteArray;
                            super(x0, x1);
                        }

                        protected void handleOK() {
                            this.val$rm.setData((Object)this.val$buffer);
                            this.val$rm.done();
                        }
                    });
                }
            }
        };
        this.fRetrieval.getExecutor().execute((Runnable)query);
        try {
            return (MemoryByte[])query.get();
        }
        catch (InterruptedException e) {
        }
        catch (ExecutionException e) {
            // empty catch block
        }
        return null;
    }

    @DsfServiceEventHandler
    public void eventDispatched(IMemory.MemoryChangedEvent e) {
        this.handleMemoryChange(e.getAddress());
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.ISuspendedDMEvent e) {
        this.handleMemoryChange(BigInteger.ZERO);
    }

    private void writeMemoryBlock(int offset, byte[] bytes) throws DebugException {
        boolean word_size = true;
        boolean mode = false;
        IMemory memoryService = (IMemory)this.fRetrieval.getServiceTracker().getService();
        if (memoryService != null) {
            memoryService.setMemory(this.fRetrieval.getContext(), this.fStartAddress, 1, bytes, offset, bytes.length, 0, new RequestMonitor((Executor)this.fRetrieval.getExecutor(), null){

                protected void handleOK() {
                    DsfMemoryBlock.this.handleMemoryChange(DsfMemoryBlock.this.fStartAddress);
                }
            });
        }
    }

    public void handleMemoryChange(BigInteger address) {
        if (address.equals(BigInteger.ZERO) || this.fStartAddress.compareTo(address) != 1 && this.fEndAddress.compareTo(address) == 1) {
            DebugEvent debugEvent = new DebugEvent((Object)this, 16, 512);
            DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{debugEvent});
        }
    }
}

