/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.model;

import java.math.BigInteger;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfExecutor;
import org.eclipse.dd.dsf.concurrent.Query;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.DsfDebugPlugin;
import org.eclipse.dd.dsf.debug.model.DsfMemoryBlock;
import org.eclipse.dd.dsf.debug.service.IExpressions;
import org.eclipse.dd.dsf.debug.service.IFormattedValues;
import org.eclipse.dd.dsf.debug.service.IMemory;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.IMemoryBlockRetrievalExtension;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DsfMemoryBlockRetrieval
extends PlatformObject
implements IMemoryBlockRetrievalExtension {
    private final String fModelId;
    private final DsfSession fSession;
    private final DsfExecutor fExecutor;
    private IDMContext<?> fContext;
    private final ServiceTracker fMemoryServiceTracker;
    private final ServiceTracker fExpressionServiceTracker;

    public DsfMemoryBlockRetrieval(String modelId, IDMContext<?> dmc) throws DebugException {
        this.fModelId = modelId;
        this.fContext = dmc;
        this.fSession = DsfSession.getSession((String)this.fContext.getSessionId());
        if (this.fSession == null) {
            throw new IllegalArgumentException("Session for context " + this.fContext + " is not active");
        }
        this.fExecutor = this.fSession.getExecutor();
        BundleContext bundle = DsfDebugPlugin.getBundleContext();
        String memoryServiceFilter = "(&(OBJECTCLASS=" + IMemory.class.getName() + ")" + "(" + "org.eclipse.dd.dsf.service.IService.session_id" + "=" + dmc.getSessionId() + ")" + ")";
        try {
            this.fMemoryServiceTracker = new ServiceTracker(bundle, bundle.createFilter(memoryServiceFilter), null);
        }
        catch (InvalidSyntaxException e) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.debug.service", 5013, "Error creating service filter.", (Throwable)e));
        }
        this.fMemoryServiceTracker.open();
        String expressionServiceFilter = "(&(OBJECTCLASS=" + IExpressions.class.getName() + ")" + "(" + "org.eclipse.dd.dsf.service.IService.session_id" + "=" + dmc.getSessionId() + ")" + ")";
        try {
            this.fExpressionServiceTracker = new ServiceTracker(bundle, bundle.createFilter(expressionServiceFilter), null);
        }
        catch (InvalidSyntaxException e) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.debug.service", 5013, "Error creating service filter.", (Throwable)e));
        }
        this.fExpressionServiceTracker.open();
    }

    public DsfSession getSession() {
        return this.fSession;
    }

    public DsfExecutor getExecutor() {
        return this.fExecutor;
    }

    public IDMContext<?> getContext() {
        return this.fContext;
    }

    public ServiceTracker getServiceTracker() {
        return this.fMemoryServiceTracker;
    }

    public boolean supportsStorageRetrieval() {
        return true;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        String expression = "0x" + Long.toHexString(startAddress);
        return new DsfMemoryBlock(this, this.fModelId, expression, BigInteger.valueOf(startAddress), length);
    }

    public IMemoryBlockExtension getExtendedMemoryBlock(String expression, Object context) throws DebugException {
        BigInteger blockAddress;
        block7: {
            try {
                int base = 10;
                int offset = 0;
                if (expression.startsWith("0x") || expression.startsWith("0X")) {
                    base = 16;
                    offset = 2;
                } else if (expression.startsWith("0")) {
                    base = 8;
                    offset = 1;
                }
                blockAddress = new BigInteger(expression.substring(offset), base);
            }
            catch (NumberFormatException nfexc) {
                IDMContext dmc = null;
                if (context instanceof IAdaptable) {
                    dmc = (IDMContext)((IAdaptable)context).getAdapter(IDMContext.class);
                }
                if (dmc == null) {
                    return null;
                }
                this.fContext = dmc;
                blockAddress = this.resolveMemoryAddress(this.fContext, expression);
                if (blockAddress != null) break block7;
                return null;
            }
        }
        return new DsfMemoryBlock(this, this.fModelId, expression, blockAddress, 0L);
    }

    private BigInteger resolveMemoryAddress(final IDMContext<?> idmContext, final String expression) throws DebugException {
        Query<BigInteger> query = new Query<BigInteger>(){

            protected void execute(final DataRequestMonitor<BigInteger> rm) {
                final IExpressions expressionService = (IExpressions)DsfMemoryBlockRetrieval.this.fExpressionServiceTracker.getService();
                if (expressionService != null) {
                    final IExpressions.IExpressionDMContext expressionDMC = expressionService.createExpression(idmContext, expression);
                    expressionService.getModelData(expressionDMC, (DataRequestMonitor)new DataRequestMonitor<IExpressions.IExpressionDMData>((Executor)DsfMemoryBlockRetrieval.this.getExecutor(), rm){

                        protected void handleOK() {
                            String formatId = "HEX.Format";
                            IFormattedValues.FormattedValueDMContext valueDmc = expressionService.getFormattedValue(expressionDMC, formatId);
                            expressionService.getModelData((IDMContext)valueDmc, (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)DsfMemoryBlockRetrieval.this.getExecutor(), null){

                                protected void handleOK() {
                                    IFormattedValues.FormattedValueDMData data = (IFormattedValues.FormattedValueDMData)this.getData();
                                    if (data.isValid()) {
                                        String value = data.getFormattedValue().substring(2);
                                        rm.setData((Object)new BigInteger(value, 16));
                                    }
                                    rm.done();
                                }
                            });
                        }
                    });
                }
            }
        };
        this.fExecutor.execute((Runnable)query);
        try {
            return (BigInteger)query.get();
        }
        catch (InterruptedException e) {
        }
        catch (ExecutionException e) {
            // empty catch block
        }
        return null;
    }
}

