/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.sourcelookup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfExecutor;
import org.eclipse.dd.dsf.concurrent.Query;
import org.eclipse.dd.dsf.concurrent.ThreadSafe;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.DsfDebugPlugin;
import org.eclipse.dd.dsf.debug.service.IStack;
import org.eclipse.dd.dsf.service.DsfServicesTracker;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class DsfMISourceLookupParticipant
implements ISourceLookupParticipant {
    protected static final Object[] EMPTY = new Object[0];
    private DsfExecutor fExecutor;
    private String fSessionId;
    private DsfServicesTracker fServicesTracker;
    private ISourceLookupDirector fDirector;
    private Map<String, List<Object>> fLookupCache = Collections.synchronizedMap(new HashMap());

    public DsfMISourceLookupParticipant(DsfSession session) {
        this.fSessionId = session.getId();
        this.fExecutor = DsfSession.getSession((String)this.fSessionId).getExecutor();
        this.fServicesTracker = new DsfServicesTracker(DsfDebugPlugin.getBundleContext(), this.fSessionId);
    }

    public void init(ISourceLookupDirector director) {
        this.fDirector = director;
    }

    public void dispose() {
        this.fServicesTracker.dispose();
        this.fDirector = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] findSourceElements(Object object) throws CoreException {
        CoreException single = null;
        MultiStatus multiStatus = null;
        List<Object> results = null;
        String name = this.getSourceName(object);
        if (name != null) {
            results = this.fLookupCache.get(name);
            if (results != null) {
                return results.toArray();
            }
            results = new ArrayList<Object>();
            ISourceContainer[] containers = this.getSourceContainers();
            for (int i = 0; i < containers.length; ++i) {
                try {
                    Object[] objects;
                    ISourceContainer container = containers[i];
                    if (container == null || (objects = container.findSourceElements(name)).length <= 0) continue;
                    if (this.isFindDuplicates()) {
                        results.addAll(Arrays.asList(objects));
                        continue;
                    }
                    results.add(objects[0]);
                    break;
                }
                catch (CoreException e) {
                    if (single == null) {
                        single = e;
                        continue;
                    }
                    if (multiStatus == null) {
                        multiStatus = new MultiStatus(DebugPlugin.getUniqueIdentifier(), 120, new IStatus[]{single.getStatus()}, "Source Lookup error", null);
                        multiStatus.add(e.getStatus());
                        continue;
                    }
                    multiStatus.add(e.getStatus());
                }
            }
            if (!results.isEmpty()) {
                Map<String, List<Object>> map = this.fLookupCache;
                synchronized (map) {
                    if (!this.fLookupCache.containsKey(name)) {
                        this.fLookupCache.put(name, results);
                    }
                }
            }
        }
        if (results == null || results.isEmpty()) {
            if (multiStatus != null) {
                throw new CoreException(multiStatus);
            }
            if (single != null) {
                throw single;
            }
            return EMPTY;
        }
        return results.toArray();
    }

    protected boolean isFindDuplicates() {
        ISourceLookupDirector director = this.fDirector;
        if (director != null) {
            return director.isFindDuplicates();
        }
        return false;
    }

    protected ISourceContainer[] getSourceContainers() {
        ISourceLookupDirector director = this.fDirector;
        if (director != null) {
            return director.getSourceContainers();
        }
        return new ISourceContainer[0];
    }

    public void sourceContainersChanged(ISourceLookupDirector director) {
        this.fLookupCache.clear();
    }

    public String getSourceName(Object object) throws CoreException {
        block6: {
            if (!(object instanceof IDMContext) || !((IDMContext)object).getSessionId().equals(this.fSessionId)) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.debug.service", -1, "Invalid object", null));
            }
            final IDMContext dmc = (IDMContext)object;
            Query<String> query = new Query<String>(){

                protected void execute(DataRequestMonitor<String> rm) {
                    DsfMISourceLookupParticipant.this.getSourceNameOnDispatchThread(dmc, (DataRequestMonitor<String>)rm);
                }
            };
            this.fExecutor.execute((Runnable)query);
            try {
                return (String)query.get();
            }
            catch (InterruptedException e) {
                assert (false) : "Interrupted exception in DSF executor";
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof CoreException) {
                    throw (CoreException)e.getCause();
                }
                if ($assertionsDisabled) break block6;
                throw new AssertionError((Object)"Unexptected exception");
            }
        }
        return null;
    }

    @ConfinedToDsfExecutor(value="fExecutor")
    private void getSourceNameOnDispatchThread(IDMContext<?> dmc, final DataRequestMonitor<String> rm) {
        if (!(dmc instanceof IStack.IFrameDMContext)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.debug.service", 10002, "No source for this object", null));
            rm.done();
            return;
        }
        IStack.IFrameDMContext frameDmc = (IStack.IFrameDMContext)dmc;
        IStack stackService = (IStack)this.fServicesTracker.getService(IStack.class);
        if (stackService == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.debug.service", 10002, "Stack data not available", null));
            rm.done();
            return;
        }
        stackService.getModelData(frameDmc, (DataRequestMonitor)new DataRequestMonitor<IStack.IFrameDMData>((Executor)this.fExecutor, rm){

            public void handleOK() {
                rm.setData((Object)((IStack.IFrameDMData)this.getData()).getFile());
                rm.done();
            }
        });
    }
}

